unit about;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls;

type
  TAboutBox = class(TForm)
    BitBtn1: TBitBtn;
    Panel1: TPanel;
    Label2: TLabel;
    Label4: TLabel;
    Label1: TLabel;
    Label3: TLabel;
    Image1: TImage;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);

  private

    { Private declarations }
  public
    { Public declarations }
    Lf, Tp: Integer;
           Pict: TPicture;
    sur: String;
    procedure loadpict;
  end;

var
  AboutBox: TAboutBox;

implementation

{$R *.DFM}

procedure TAboutBox.FormShow(Sender: TObject);
begin
Left:=Lf;
Top:=Tp;
end;

procedure TAboutBox.LoadPict;
begin
if Sur='' then exit;
if Pict = nil then Pict := TPicture.Create;
try
Pict.LoadFromFile(sur);
except
ShowMessage('Cannot Open '+sur);
Pict.Free; Pict:=nil; sur:='';
end;
end;

procedure TAboutBox.FormCreate(Sender: TObject);
begin
Pict:=nil; Sur:='';
Label5.Width:=Panel1.Width-8;
Lf:=(Screen.Width-Width) div 2;
Tp:=(Screen.Height-Height) div 2;
end;


procedure TAboutBox.FormPaint(Sender: TObject);
var
i,j: Integer;
begin
if (Pict <> nil) then
for i:=0 to width div Pict.Graphic.Width do
for j:=0 to height div Pict.Graphic.height do
Canvas.Draw(i*Pict.Graphic.width, j*Pict.Graphic.Height, Pict.Graphic);
end;

procedure TAboutBox.FormClose(Sender: TObject; var Action: TCloseAction);
begin
if Pict<>nil then begin Pict.Free; Pict:=nil; end;
end;

end.


