unit Unit2;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Grids, Buttons, Menus;

type
  TForm2 = class(TForm)
    Label2: TLabel;
    Label1: TLabel;
    Label4: TLabel;
    StringGrid1: TStringGrid;
    Label3: TLabel;
    Edit1: TEdit;
    BitBtn2: TBitBtn;
    BitBtn1: TBitBtn;
    BitBtn3: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormPaint(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
     fl: String;
     Names, Scores: Array [1..5] of String;
     Nam, Score, Sco: String;
  public
    { Public declarations }
    lf, tp: Integer;
    Congr: Boolean;
    Moves, RC, FG, AR, AC, ST, TR, TC, Gp, SRC: String;
    Pict: TPicture;
    sur: String;
    procedure loadpict;
  end;

var
  Form2: TForm2;

implementation
var
ScoreV: Integer;
bestfile: Text;

{$R *.DFM}

procedure TForm2.LoadPict;
begin
Pict:=nil;
if sur='' then exit;
Pict := TPicture.Create;
try
Pict.LoadFromFile(sur);
except
ShowMessage('Cannot Open '+sur);
Pict.Free; Pict:=nil; sur:='';
end;
end;

procedure TForm2.FormDeactivate(Sender: TObject);
var
i: Word;
begin
AssignFile(bestfile,fl);
if FileExists(fl) then
begin
for i:=1 to 5 do
begin
Names[i]:=StringGrid1.Cells[1, i];
Scores[i]:=StringGrid1.Cells[2, i];
end;
Erase(bestfile);
AssignFile(bestfile,fl);
Rewrite(bestfile);
for i:=1 to 5 do
begin
WriteLn(bestfile, Names[i]);
WriteLn(bestfile, Scores[i]);
end;
CloseFile(bestfile);
end;
end;

procedure TForm2.BitBtn2Click(Sender: TObject);
var i, k: Word;
begin
if Edit1.Text='' then
begin
ShowMessage('Enter Your Name!');
Edit1.SetFocus; exit;
end
else Nam:=Edit1.Text;
Congr:=True;
k:=6;
if(GP='Scramble')or(GP='Figures')then
for i:=5 downto 1 do
if ScoreV<StrToInt(Scores[i])then k:=i;
if(GP='Tetris')or(GP='Arcanoid')or(GP='Lines')then
for i:=5 downto 1 do if Scorev>StrToInt(Scores[i])then k:=i;
 for i:=5 downto Succ(k) do
 begin
 Scores[i]:=Scores[Pred(i)];
 Names[i]:=Names[Pred(i)];
 end;
 Scores[k]:=Score;
 Names[k]:=Nam;
for i:=1 to 5 do
begin
StringGrid1.Cells[1, i]:=Names[i];
StringGrid1.Cells[2, i]:=Scores[i];
end;
BitBtn2.Enabled:=False; Edit1.Enabled:=False;
Label3.Caption:='Congratulations '+Nam+'!';
BitBtn1.SetFocus;
end;

procedure TForm2.BitBtn3Click(Sender: TObject);
var
i, j: Word;
begin
AssignFile(bestfile,fl);
if FileExists(fl) then Erase(bestfile);
for i:=1 to 2 do
for j:=1 to 5 do
StringGrid1.Cells[i,j]:='';
BitBtn3.Enabled:=False;
BitBtn2.Enabled:=False;
Edit1.Enabled:=False;
BitBtn1.SetFocus;
end;

procedure TForm2.FormCreate(Sender: TObject);
var
i: Word;
begin
With StringGrid1 do
begin
DefaultRowHeight:=Height div 6;
for i:=0 to 6 do
Cells[0,i]:=IntToStr(i);
Cells[0,0]:='Place';
Cells[1,0]:='Name';
Cells[2,0]:='Result';
end;
end;

procedure TForm2.FormShow(Sender: TObject);
var
i : Integer;
begin
Left:=lf; Top:=tp;
Congr:=False;
if GP='Scramble' then
begin
 Sco:='999999';
 Label1.Caption:='Scramble';
 Label2.Caption:='Result: '+Moves+' Moves';
 fl:='scramble.ini';
 Score:=Moves; ScoreV:=StrToInt(Score);
end
else
if GP='Tetris' then
begin
 Sco:='0';
 Label1.Caption:='Tetris';
 Label2.Caption:='Result: '+Moves+' Points';
 fl:='tetris.ini';
 Score:=Moves; ScoreV:=StrToInt(Score);
 end
else
if GP='Figures' then
 begin
 Label1.Caption:='Figures';
 Label2.Caption:='Result: '+Moves+' Moves';
 Sco:='999999';
 fl:='figures.ini';
 Score:=Moves; ScoreV:=StrToInt(Score);
 end
else
if GP='Arcanoid' then
 begin
 Sco:='0';
 Label1.Caption:='Arcanoid';
 Label2.Caption:='Result: '+Moves+' Points';
 fl:='arcanoid.ini';
 Score:=Moves; ScoreV:=StrToInt(Score);
 end;
AssignFile(bestfile,fl);
if not FileExists(fl)
then
begin
Rewrite(bestfile);
for i:=1 to 5 do
begin
Names[i]:='Anonymous';
Scores[i]:=Sco;
WriteLn(bestfile, Names[i]);
WriteLn(bestfile, Scores[i]);
end;
end
else
begin
Reset(bestfile);
for i:=1 to 5 do
begin
ReadLn(bestFile, Names[i]);
ReadLn(bestfile, Scores[i]);
end;
end;
CloseFile(bestfile);
for i:=1 to 5 do
begin
StringGrid1.Cells[1, i]:=Names[i];
StringGrid1.Cells[2, i]:=Scores[i];
end;
if ((GP='Scramble') or (GP='Figures')) then
begin
if ScoreV < StrToInt(Scores[5]) then
begin Label3.Caption:='Enter Your name!'; Edit1.SetFocus; end
else
begin Edit1.Enabled:=False; BitBtn2.Enabled:=False;
BitBtn1.SetFocus;
end;
end;
if ((GP='Arcanoid') or (GP='Tetris')) then
begin
if ScoreV > StrToInt(Scores[5]) then
begin Label3.Caption:='Enter Your name!'; Edit1.SetFocus; end
else
begin
Edit1.Enabled:=False;
BitBtn2.Enabled:=False;
BitBtn1.SetFocus;
end;
end;
end;

procedure TForm2.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
if Key=VK_Return then
  begin
  if (Edit1.Enabled)and(Edit1.Text<>'')then
  BitBtn2Click(Sender);
  end;
end;

procedure TForm2.FormPaint(Sender: TObject);
var
i,j: Integer;
begin
if (Pict <> nil) then
for i:=0 to width div Pict.Graphic.Width do
for j:=0 to height div Pict.Graphic.height do
Canvas.Draw(i*Pict.Graphic.width, j*Pict.Graphic.Height, Pict.Graphic);
end;

procedure TForm2.FormClose(Sender: TObject; var Action: TCloseAction);
begin
if Pict<>nil then begin Pict.Free; Pict:=nil; end;
end;

end.
