/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.vmem;

import com.sun.jimi.core.vmem.PageFrame;
import com.sun.jimi.util.RandomAccessStorage;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class PageMapper {
    protected RandomAccessStorage storage;
    protected Dimension logicalSize;
    protected int pageFrameMemory;
    protected int pageFaults = 0;
    protected OutputStream output;
    protected InputStream input;
    protected int numberOfPageFrames;
    protected Dimension pageDimensions;

    public PageMapper(RandomAccessStorage randomAccessStorage, Dimension dimension, int n) {
        this.storage = randomAccessStorage;
        this.logicalSize = dimension;
        this.pageFrameMemory = n;
        this.output = randomAccessStorage.asOutputStream();
        this.input = randomAccessStorage.asInputStream();
        this.configurePageFrames();
    }

    public void commitPage(PageFrame pageFrame) {
        int n = this.getPageSize() * pageFrame.getLogicalPageNumber();
        this.storage.seek(n);
        pageFrame.writeTo(this.output);
        this.output.flush();
        pageFrame.setModified(false);
    }

    protected void configurePageFrames() {
        this.pageDimensions = new Dimension(this.logicalSize.width / 8, 200);
        this.numberOfPageFrames = 9;
    }

    public Dimension getLogicalSize() {
        return this.logicalSize;
    }

    public PageFrame getPageFrame(int n) {
        Object object = this.getPageFrames();
        long l = Long.MAX_VALUE;
        int n2 = 0;
        int n3 = 0;
        while (n3 < ((PageFrame[])object).length) {
            if (object[n3].getLogicalPageNumber() == n) {
                object[n3].touch();
                return object[n3];
            }
            if (object[n3].lastTouched() < l) {
                n2 = n3;
                l = object[n3].lastTouched();
            }
            ++n3;
        }
        ++this.pageFaults;
        if ((object = object[n2]).isModified()) {
            this.commitPage((PageFrame)object);
        }
        this.readPageIntoFrame((PageFrame)object, n);
        return object;
    }

    public PageFrame getPageFrameForReading(int n) {
        return this.getPageFrame(n);
    }

    public PageFrame getPageFrameForWriting(int n) {
        PageFrame pageFrame = this.getPageFrame(n);
        pageFrame.setModified(true);
        return pageFrame;
    }

    public abstract PageFrame[] getPageFrames();

    public abstract int getPageSize();

    protected abstract int getPixelSize();

    public int howManyPageFaults() {
        return this.pageFaults;
    }

    public void readPageIntoFrame(PageFrame pageFrame, int n) {
        int n2 = this.getPageSize() * n;
        this.storage.seek(n2);
        try {
            pageFrame.readFrom(this.input);
        }
        catch (IOException iOException) {}
        pageFrame.setLogicalPageNumber(n);
        pageFrame.setModified(false);
        pageFrame.touch();
    }

    public void resetPageFaultCount() {
        this.pageFaults = 0;
    }
}

