/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.vmem;

import com.sun.jimi.core.vmem.IntPageFrame;
import com.sun.jimi.core.vmem.PageFrame;
import com.sun.jimi.core.vmem.PageMapper;
import com.sun.jimi.util.RandomAccessStorage;
import java.awt.Dimension;

public class IntPageMapper
extends PageMapper {
    protected static final int SIZEOF_INT = 4;
    protected IntPageFrame[] pageFrames;
    protected int width;
    protected int height;
    protected int pageWidth;
    protected int pageHeight;
    protected int widthInPages;
    protected int heightInPages;

    public IntPageMapper(RandomAccessStorage randomAccessStorage, Dimension dimension, int n) {
        super(randomAccessStorage, dimension, n);
        this.width = dimension.width;
        this.height = dimension.height;
        this.pageWidth = this.pageDimensions.width;
        this.pageHeight = this.pageDimensions.height;
        this.widthInPages = this.width % this.pageWidth == 0 ? this.width / this.pageWidth : this.width / this.pageWidth + 1;
        this.heightInPages = this.height % this.pageHeight == 0 ? this.height / this.pageHeight : this.height / this.pageHeight + 1;
        int n2 = this.pageWidth * this.pageHeight;
        this.pageFrames = new IntPageFrame[this.numberOfPageFrames];
        int n3 = 0;
        while (n3 < this.pageFrames.length) {
            this.pageFrames[n3] = new IntPageFrame(n2);
            ++n3;
        }
    }

    public int getLogicalPageNumberForLocation(int n, int n2) {
        return n / this.pageWidth + n2 / this.pageHeight * this.widthInPages;
    }

    public Dimension getPageDimensions() {
        return new Dimension(this.pageWidth, this.pageHeight);
    }

    public PageFrame[] getPageFrames() {
        return this.pageFrames;
    }

    public int getPageSize() {
        return this.pageWidth * this.pageHeight << 2;
    }

    public int getPixel(int n, int n2) {
        int n3 = this.getLogicalPageNumberForLocation(n, n2);
        return ((IntPageFrame)this.getPageFrameForReading(n3)).getPageData()[n % this.pageWidth + n2 % this.pageHeight * this.pageWidth];
    }

    protected int getPixelSize() {
        return 4;
    }

    public void getRectangle(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        int n7 = n4;
        int n8 = n2;
        while (n7 != 0) {
            int n9 = n3;
            int n10 = n;
            int n11 = Math.min(this.pageHeight - n8 % this.pageHeight, n7);
            while (n9 != 0) {
                n4 = this.getLogicalPageNumberForLocation(n10, n8);
                Object object = (IntPageFrame)this.getPageFrameForReading(n4);
                n4 = Math.min(this.pageWidth - n10 % this.pageWidth, n9);
                object = ((IntPageFrame)object).getPageData();
                int n12 = 0;
                while (n12 < n11) {
                    System.arraycopy(object, n10 % this.pageWidth + (n8 % this.pageHeight + n12) * this.pageWidth, nArray, n5 + n10 - n + (n8 - n2 + n12) * n6, n4);
                    ++n12;
                }
                n10 += n4;
                n9 -= n4;
            }
            n8 += n11;
            n7 -= n11;
        }
    }

    public void setChannelRectangle(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6, int n7) {
        int n8 = ~(255 << n);
        int n9 = n5;
        int n10 = n3;
        while (n9 != 0) {
            int n11 = n4;
            int n12 = n2;
            int n13 = Math.min(this.pageHeight - n10 % this.pageHeight, n9);
            while (n11 != 0) {
                n5 = this.getLogicalPageNumberForLocation(n12, n10);
                Object object = (IntPageFrame)this.getPageFrameForWriting(n5);
                n5 = Math.min(this.pageWidth - n12 % this.pageWidth, n11);
                object = ((IntPageFrame)object).getPageData();
                int n14 = 0;
                while (n14 < n13) {
                    int n15 = n12 % this.pageWidth + (n10 % this.pageHeight + n14) * this.pageWidth;
                    int n16 = n6 + n12 - n2 + (n10 - n3 + n14) * n7;
                    int n17 = 0;
                    while (n17 < n5) {
                        Object object2 = object;
                        int n18 = n15 + n17;
                        object2[n18] = object2[n18] & n8;
                        Object object3 = object;
                        int n19 = n15 + n17;
                        object3[n19] = object3[n19] | (0xFF000000 | (byArray[n16 + n17] & 0xFF) << n);
                        ++n17;
                    }
                    ++n14;
                }
                n12 += n5;
                n11 -= n5;
            }
            n10 += n13;
            n9 -= n13;
        }
    }

    public void setPixel(int n, int n2, int n3) {
        int n4 = this.getLogicalPageNumberForLocation(n, n2);
        ((IntPageFrame)this.getPageFrameForWriting((int)n4)).getPageData()[n % this.pageWidth + n2 % this.pageHeight * this.pageWidth] = n3;
    }

    public void setRectangle(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        int n7 = n4;
        int n8 = n2;
        while (n7 != 0) {
            int n9 = n3;
            int n10 = n;
            int n11 = Math.min(this.pageHeight - n8 % this.pageHeight, n7);
            while (n9 != 0) {
                n4 = this.getLogicalPageNumberForLocation(n10, n8);
                Object object = (IntPageFrame)this.getPageFrameForWriting(n4);
                n4 = Math.min(this.pageWidth - n10 % this.pageWidth, n9);
                object = ((IntPageFrame)object).getPageData();
                int n12 = 0;
                while (n12 < n11) {
                    System.arraycopy(nArray, n5 + n10 - n + (n8 - n2 + n12) * n6, object, n10 % this.pageWidth + (n8 % this.pageHeight + n12) * this.pageWidth, n4);
                    ++n12;
                }
                n10 += n4;
                n9 -= n4;
            }
            n8 += n11;
            n7 -= n11;
        }
    }
}

