/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.vmem;

import com.sun.jimi.core.vmem.BytePageFrame;
import com.sun.jimi.core.vmem.PageFrame;
import com.sun.jimi.core.vmem.PageMapper;
import com.sun.jimi.util.RandomAccessStorage;
import java.awt.Dimension;

public class BytePageMapper
extends PageMapper {
    protected static final int SIZEOF_BYTE = 1;
    protected BytePageFrame[] pageFrames;
    protected int width;
    protected int height;
    protected int pageWidth;
    protected int pageHeight;
    protected int widthInPages;
    protected int heightInPages;

    public BytePageMapper(RandomAccessStorage randomAccessStorage, Dimension dimension, int n) {
        super(randomAccessStorage, dimension, n);
        this.width = dimension.width;
        this.height = dimension.height;
        this.pageWidth = this.pageDimensions.width;
        this.pageHeight = this.pageDimensions.height;
        this.widthInPages = this.width % this.pageWidth == 0 ? this.width / this.pageWidth : this.width / this.pageWidth + 1;
        this.heightInPages = this.height % this.pageHeight == 0 ? this.height / this.pageHeight : this.height / this.pageHeight + 1;
        int n2 = this.pageWidth * this.pageHeight;
        this.pageFrames = new BytePageFrame[this.numberOfPageFrames];
        int n3 = 0;
        while (n3 < this.pageFrames.length) {
            this.pageFrames[n3] = new BytePageFrame(n2);
            ++n3;
        }
    }

    public int getLogicalPageNumberForLocation(int n, int n2) {
        return n / this.pageWidth + n2 / this.pageHeight * this.widthInPages;
    }

    public Dimension getPageDimensions() {
        return new Dimension(this.pageWidth, this.pageHeight);
    }

    public PageFrame[] getPageFrames() {
        return this.pageFrames;
    }

    public int getPageSize() {
        return this.pageWidth * this.pageHeight;
    }

    public byte getPixel(int n, int n2) {
        int n3 = this.getLogicalPageNumberForLocation(n, n2);
        return ((BytePageFrame)this.getPageFrameForReading(n3)).getPageData()[n % this.pageWidth + n2 % this.pageHeight * this.pageWidth];
    }

    protected int getPixelSize() {
        return 1;
    }

    public void getRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
        int n7 = n4;
        int n8 = n2;
        while (n7 != 0) {
            int n9 = n3;
            int n10 = n;
            int n11 = Math.min(this.pageHeight - n8 % this.pageHeight, n7);
            while (n9 != 0) {
                n4 = this.getLogicalPageNumberForLocation(n10, n8);
                Object object = (BytePageFrame)this.getPageFrameForReading(n4);
                n4 = Math.min(this.pageWidth - n10 % this.pageWidth, n9);
                object = ((BytePageFrame)object).getPageData();
                int n12 = 0;
                while (n12 < n11) {
                    System.arraycopy(object, n10 % this.pageWidth + (n8 % this.pageHeight + n12) * this.pageWidth, byArray, n5 + n10 - n + (n8 - n2 + n12) * n6, n4);
                    ++n12;
                }
                n10 += n4;
                n9 -= n4;
            }
            n8 += n11;
            n7 -= n11;
        }
    }

    public void setPixel(int n, int n2, byte by) {
        int n3 = this.getLogicalPageNumberForLocation(n, n2);
        ((BytePageFrame)this.getPageFrameForWriting((int)n3)).getPageData()[n % this.pageWidth + n2 % this.pageHeight * this.pageWidth] = by;
    }

    public void setRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
        int n7 = n4;
        int n8 = n2;
        while (n7 != 0) {
            int n9 = n3;
            int n10 = n;
            int n11 = Math.min(this.pageHeight - n8 % this.pageHeight, n7);
            while (n9 != 0) {
                n4 = this.getLogicalPageNumberForLocation(n10, n8);
                Object object = (BytePageFrame)this.getPageFrameForWriting(n4);
                n4 = Math.min(this.pageWidth - n10 % this.pageWidth, n9);
                object = ((BytePageFrame)object).getPageData();
                int n12 = 0;
                while (n12 < n11) {
                    System.arraycopy(byArray, n5 + n10 - n + (n8 - n2 + n12) * n6, object, n10 % this.pageWidth + (n8 % this.pageHeight + n12) * this.pageWidth, n4);
                    ++n12;
                }
                n10 += n4;
                n9 -= n4;
            }
            n8 += n11;
            n7 -= n11;
        }
    }
}

