/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util.lzw;

import com.sun.jimi.core.util.lzw.BitInput;
import com.sun.jimi.core.util.lzw.a;
import java.io.InputStream;

public final class LZWDecompressor {
    private int a;
    private int b;
    protected BitInput input_;
    protected int initialCodeSize_;
    protected int codeSize_;
    protected int limit_;
    protected boolean tiff_;
    protected a table_;
    protected int count_;
    protected int oldCode_;
    protected byte oldCodeFirstChar_;
    protected int leftOverCode_;
    protected int leftOverIndex_;
    protected int leftOverOldCode_;
    protected boolean isLeftOver_;

    public LZWDecompressor(InputStream inputStream, int n, boolean bl) {
        this.initialCodeSize_ = n;
        this.tiff_ = bl;
        this.a = 1 << n;
        this.b = (1 << n) + 1;
        this.table_ = new a(n, 0);
        this.setInputStream(inputStream);
        this.clearTable();
    }

    protected final void clearTable() {
        a a2 = this.table_;
        this.table_.a = (1 << a2.b) + 2;
        this.resetCodeSize();
    }

    /*
     * Unable to fully structure code
     */
    public final int decompress(byte[] var1_1) {
        var2_2 = this.writeLeftOver(var1_1);
        if (!this.isLeftOver_) ** GOTO lbl34
        return var1_1.length;
        while ((var3_3 = this.getNextCode()) != this.b) {
            if (var3_3 == this.a) {
                this.clearTable();
                var3_3 = this.getNextCode();
                if (var3_3 == this.b) break;
                var1_1[var2_2++] = (byte)var3_3;
                this.oldCode_ = var3_3;
                this.oldCodeFirstChar_ = (byte)var3_3;
            } else {
                var5_6 = var3_3;
                var4_5 = this.table_;
                if (var5_6 < var4_5.a) {
                    var4_4 = this.writeCode(var1_1, var2_2, var3_3);
                    if (this.table_.a(this.oldCode_, var1_1[var2_2]) == this.limit_) {
                        this.incrementCodeSize();
                    }
                    this.oldCode_ = var3_3;
                    this.oldCodeFirstChar_ = var1_1[var2_2];
                    if (var4_4 < 0) {
                        return var1_1.length;
                    }
                    var2_2 += var4_4;
                } else {
                    var4_4 = this.table_.a(this.oldCode_, this.oldCodeFirstChar_);
                    var5_6 = this.writeCode(var1_1, var2_2, var4_4);
                    this.oldCode_ = var3_3;
                    this.oldCodeFirstChar_ = var1_1[var2_2];
                    if (var4_4 == this.limit_) {
                        this.incrementCodeSize();
                    }
                    if (var5_6 < 0) {
                        return var1_1.length;
                    }
                    var2_2 += var5_6;
                }
            }
lbl34:
            // 4 sources

            if (var2_2 < var1_1.length) continue;
        }
        return var2_2;
    }

    protected final int getNextCode() {
        return this.input_.read();
    }

    public final void gifFinishBlocks() {
        if (!this.tiff_) {
            this.input_.gifFinishBlocks();
        }
    }

    protected final void incrementCodeSize() {
        if (this.codeSize_ != 12) {
            ++this.codeSize_;
            this.limit_ = (1 << this.codeSize_) - 1;
            if (this.tiff_) {
                --this.limit_;
            }
            this.input_.setNumBits(this.codeSize_);
        }
    }

    protected final void resetCodeSize() {
        this.count_ = 0;
        this.codeSize_ = this.initialCodeSize_;
        this.incrementCodeSize();
    }

    public final void setInputStream(InputStream inputStream) {
        this.input_ = new BitInput(inputStream, this.tiff_ ^ true);
        this.clearTable();
        this.resetCodeSize();
    }

    protected final int writeCode(byte[] byArray, int n, int n2) {
        return this.writeCode(byArray, n, n2, 0);
    }

    protected final int writeCode(byte[] object, int n, int n2, int n3) {
        a a2 = this.table_;
        int n4 = n3;
        n3 = n;
        byte[] byArray = object;
        object = a2;
        int n5 = byArray.length - n3;
        int n6 = a2.a[n2].length - n4;
        int n7 = n5 > n6 ? n6 : n5;
        System.arraycopy(object.a[n2], n4, byArray, n3, n7);
        int n8 = n6 > n7 ? -(n5 + n4) : n7;
        if (n8 < 0) {
            this.leftOverCode_ = n2;
            this.leftOverOldCode_ = this.oldCode_;
            this.isLeftOver_ = true;
            this.leftOverIndex_ = -n8;
        } else {
            this.isLeftOver_ = false;
        }
        return n8;
    }

    protected final int writeLeftOver(byte[] byArray) {
        if (!this.isLeftOver_) {
            return 0;
        }
        return this.writeCode(byArray, 0, this.leftOverCode_, this.leftOverIndex_);
    }
}

