/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.OutputStream;

public class LEDataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written = 0;

    public LEDataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void flush() {
        this.out.flush();
    }

    public final int size() {
        return this.written;
    }

    public synchronized void write(int n) {
        this.out.write(n);
        ++this.written;
    }

    public synchronized void write(byte[] byArray, int n, int n2) {
        this.out.write(byArray, n, n2);
        this.written += n2;
    }

    public final void writeBoolean(boolean bl) {
        this.out.write(bl ? 1 : 0);
        ++this.written;
    }

    public final void writeByte(int n) {
        this.out.write(n);
        ++this.written;
    }

    public final void writeBytes(String string) {
        OutputStream outputStream = this.out;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            outputStream.write((byte)string.charAt(n2));
            ++n2;
        }
        this.written += n;
    }

    public final void writeChar(int n) {
        OutputStream outputStream = this.out;
        outputStream.write(n & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
        this.written += 2;
    }

    public final void writeChars(String string) {
        OutputStream outputStream = this.out;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c2 = string.charAt(n2);
            outputStream.write(c2 >>> 8 & 0xFF);
            outputStream.write(c2 & 0xFF);
            ++n2;
        }
        this.written += n << 1;
    }

    public final void writeDouble(double d2) {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    public final void writeFloat(float f2) {
        this.writeInt(Float.floatToIntBits(f2));
    }

    public final void writeInt(int n) {
        OutputStream outputStream = this.out;
        outputStream.write(n & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n >>> 16 & 0xFF);
        outputStream.write(n >>> 24);
        this.written += 4;
    }

    public final void writeLong(long l) {
        OutputStream outputStream = this.out;
        outputStream.write((int)l & 0xFF);
        outputStream.write((int)(l >>> 8) & 0xFF);
        outputStream.write((int)(l >>> 16) & 0xFF);
        outputStream.write((int)(l >>> 24) & 0xFF);
        outputStream.write((int)(l >>> 32) & 0xFF);
        outputStream.write((int)(l >>> 40) & 0xFF);
        outputStream.write((int)(l >>> 48) & 0xFF);
        outputStream.write((int)(l >>> 56) & 0xFF);
        this.written += 8;
    }

    public final void writeShort(int n) {
        OutputStream outputStream = this.out;
        outputStream.write(n & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
        this.written += 2;
    }

    public final void writeUTF(String string) {
    }
}

