/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.JimiImageHandle;
import com.sun.jimi.core.JimiLicenseInformation;
import com.sun.jimi.core.MemoryJimiImageFactory;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.ErrorImageProducer;
import com.sun.jimi.core.util.JimiImageFactoryProxy;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class JimiUtil {
    public static final boolean TRUE = true;
    private static byte[] a = new byte[2048];
    private static int[] a = new int[2048];

    static {
        int n = 0;
        int n2 = 0;
        while (n2 < 256) {
            JimiUtil.a[n++] = (n2 & 0x80) == 0 ? (byte)0 : 1;
            JimiUtil.a[n++] = (n2 & 0x40) == 0 ? (byte)0 : 1;
            JimiUtil.a[n++] = (n2 & 0x20) == 0 ? (byte)0 : 1;
            JimiUtil.a[n++] = (n2 & 0x10) == 0 ? (byte)0 : 1;
            JimiUtil.a[n++] = (n2 & 8) == 0 ? (byte)0 : 1;
            JimiUtil.a[n++] = (n2 & 4) == 0 ? (byte)0 : 1;
            JimiUtil.a[n++] = (n2 & 2) == 0 ? (byte)0 : 1;
            JimiUtil.a[n++] = (n2 & 1) == 0 ? (byte)0 : 1;
            ++n2;
        }
        n = 0;
        n2 = 0;
        while (n2 < 256) {
            JimiUtil.a[n++] = (n2 & 0x80) == 0 ? -16777216 : -1;
            JimiUtil.a[n++] = (n2 & 0x40) == 0 ? -16777216 : -1;
            JimiUtil.a[n++] = (n2 & 0x20) == 0 ? -16777216 : -1;
            JimiUtil.a[n++] = (n2 & 0x10) == 0 ? -16777216 : -1;
            JimiUtil.a[n++] = (n2 & 8) == 0 ? -16777216 : -1;
            JimiUtil.a[n++] = (n2 & 4) == 0 ? -16777216 : -1;
            JimiUtil.a[n++] = (n2 & 2) == 0 ? -16777216 : -1;
            JimiUtil.a[n++] = (n2 & 1) == 0 ? -16777216 : -1;
            ++n2;
        }
    }

    public static JimiRasterImage asJimiRasterImage(JimiImage jimiImage) {
        if (jimiImage instanceof JimiRasterImage) {
            return (JimiRasterImage)jimiImage;
        }
        if (jimiImage instanceof JimiImageHandle) {
            try {
                return JimiUtil.asJimiRasterImage(((JimiImageHandle)jimiImage).getWrappedJimiImage());
            }
            catch (JimiException jimiException) {
                return null;
            }
        }
        return null;
    }

    public static byte countBitsSet(int n) {
        byte by = 0;
        int n2 = 1;
        int n3 = 0;
        while (n3 < 32) {
            if ((n & n2) != 0) {
                by = (byte)(by + 1);
            }
            n2 <<= 1;
            ++n3;
        }
        return by;
    }

    public static void expandOneBitPixels(byte[] byArray, byte[] byArray2, int n) {
        int n2 = n % 8;
        n /= 8;
        int n3 = 0;
        while (n3 < n) {
            int n4 = (byArray[n3] & 0xFF) << 3;
            System.arraycopy(a, n4, byArray2, n3 << 3, 8);
            ++n3;
        }
        if (n2 != 0) {
            System.arraycopy(a, (byArray[n] & 0xFF) << 3, byArray2, n << 3, n2);
        }
    }

    public static void expandOneBitPixels(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        int n4 = n2 % 8;
        n2 /= 8;
        if (n4 != 0) {
            n4 = 8 - n4;
            System.arraycopy(a, ((byArray[n2++] & 0xFF) << 3) + 8 - n4, byArray2, n3, n4);
            n3 += n4;
        }
        n4 = n % 8;
        n = n2 + n / 8;
        while (n2 < n) {
            System.arraycopy(a, (byArray[n2] & 0xFF) << 3, byArray2, n3, 8);
            n3 += 8;
            ++n2;
        }
        if (n4 != 0) {
            System.arraycopy(a, (byArray[n - 1] & 0xFF) << 3, byArray2, n3, n4);
        }
    }

    public static void expandOneBitPixelsToBW(byte[] byArray, int[] nArray, int n, int n2, int n3) {
        int n4 = n2 % 8;
        n2 /= 8;
        if (n4 != 0) {
            n4 = 8 - n4;
            System.arraycopy(a, (byArray[n2++] << 3) + 8 - n4, nArray, n3, n4);
            n3 += n4;
        }
        n4 = n % 8;
        n = n2 + n / 8;
        while (n2 < n) {
            System.arraycopy(a, (byArray[n2] & 0xFF) << 3, nArray, n3, 8);
            n3 += 8;
            ++n2;
        }
        if (n4 != 0) {
            System.arraycopy(a, (byArray[n] & 0xFF) << 3, nArray, n3, n4);
        }
    }

    public static void expandPixels(int n, byte[] byArray, byte[] byArray2, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (n == 1) {
            JimiUtil.expandOneBitPixels(byArray, byArray2, n2);
            return;
        }
        switch (n) {
            case 1: {
                n7 = 128;
                n6 = 1;
                n5 = 8;
                n4 = 7;
                n3 = 1;
                break;
            }
            case 2: {
                n7 = 192;
                n6 = 2;
                n5 = 4;
                n4 = 6;
                n3 = 2;
                break;
            }
            case 4: {
                n7 = 240;
                n6 = 4;
                n5 = 2;
                n4 = 4;
                n3 = 4;
                break;
            }
            default: {
                throw new RuntimeException("support only expand for 1, 2, 4");
            }
        }
        n = 0;
        n2 = 0;
        while (n2 < byArray2.length) {
            int n8 = n7;
            int n9 = n4;
            byte by = byArray[n];
            int n10 = 0;
            while (n10 < n5 && n2 < byArray2.length) {
                byArray2[n2] = (byte)((by & n8) >>> n9);
                n8 = (byte)((n8 & 0xFF) >>> n6);
                n9 -= n3;
                ++n10;
                ++n2;
            }
            ++n;
        }
    }

    public static boolean flagSet(int n, int n2) {
        return (n & n2) != 0;
    }

    public static boolean flagsSet(int n, int n2) {
        return (n & n2) == n2;
    }

    public static byte[] getChannelWidths(ColorModel colorModel) {
        byte[] byArray = new byte[8];
        if (colorModel instanceof DirectColorModel) {
            colorModel = (DirectColorModel)colorModel;
            byArray[0] = JimiUtil.countBitsSet(((DirectColorModel)colorModel).getAlphaMask());
            byArray[1] = JimiUtil.countBitsSet(((DirectColorModel)colorModel).getRedMask());
            byArray[2] = JimiUtil.countBitsSet(((DirectColorModel)colorModel).getGreenMask());
            byArray[3] = JimiUtil.countBitsSet(((DirectColorModel)colorModel).getBlueMask());
        } else if (colorModel instanceof IndexColorModel) {
            byArray[0] = 8;
            byArray[1] = 8;
            byArray[2] = 8;
            byArray[3] = 8;
        }
        return byArray;
    }

    public static Image getErrorImage() {
        return Toolkit.getDefaultToolkit().createImage(JimiUtil.getErrorImageProducer());
    }

    public static ImageProducer getErrorImageProducer() {
        return new ErrorImageProducer();
    }

    public static boolean isCompatibleWithJavaVersion(int n, int n2) {
        try {
            String string = System.getProperty("java.version");
            int n3 = Integer.parseInt(string.substring(0, string.indexOf(46)));
            string = string.substring(string.indexOf(".") + 1);
            if (string.indexOf(46) != -1) {
                string = string.substring(0, string.indexOf(46));
            }
            int n4 = Integer.parseInt(string);
            return n3 > n || n3 == n && n4 >= n2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isRGBDefault(ColorModel colorModel) {
        if (colorModel instanceof DirectColorModel) {
            colorModel = (DirectColorModel)colorModel;
            DirectColorModel directColorModel = (DirectColorModel)ColorModel.getRGBdefault();
            int n = directColorModel.getAlphaMask();
            int n2 = directColorModel.getRedMask();
            int n3 = directColorModel.getGreenMask();
            int n4 = directColorModel.getBlueMask();
            int n5 = ((DirectColorModel)colorModel).getAlphaMask();
            int n6 = ((DirectColorModel)colorModel).getRedMask();
            int n7 = ((DirectColorModel)colorModel).getGreenMask();
            int n8 = ((DirectColorModel)colorModel).getBlueMask();
            return n == n5 && n2 == n6 && n3 == n7 && n4 == n8;
        }
        return false;
    }

    public static void packOneBitPixels(byte[] byArray, int n, byte[] byArray2, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        n2 += n3 / 8;
        int n8 = (n3 %= 8) == 0 ? n4 / 8 : (n4 - (8 - n3)) / 8;
        int n9 = n3 == 0 ? 0 : 1;
        int n10 = n2 + (n3 == 0 ? 0 : 1);
        int n11 = n7 = n4 < 8 - n3 ? n4 : 8 - n3;
        if (n3 != 0) {
            n6 = 7 - n3;
            n5 = 0;
            while (n5 < n7) {
                if (byArray[n++] == 0) {
                    int n12 = n2;
                    byArray2[n12] = (byte)(byArray2[n12] & ~(1 << n6 - n5));
                } else {
                    int n13 = n2;
                    byArray2[n13] = (byte)(byArray2[n13] | 1 << n6 - n5);
                }
                ++n5;
            }
        }
        n6 = n9;
        while (n6 < n8) {
            n9 = 0;
            if (byArray[n++] != 0) {
                n9 += 128;
            }
            if (byArray[n++] != 0) {
                n9 += 64;
            }
            if (byArray[n++] != 0) {
                n9 += 32;
            }
            if (byArray[n++] != 0) {
                n9 += 16;
            }
            if (byArray[n++] != 0) {
                n9 += 8;
            }
            if (byArray[n++] != 0) {
                n9 += 4;
            }
            if (byArray[n++] != 0) {
                n9 += 2;
            }
            if (byArray[n++] != 0) {
                ++n9;
            }
            byArray2[n10 + n6] = (byte)n9;
            ++n6;
        }
        n5 = n3 == 0 ? n4 % 8 : n4 - (8 - n3) % 8;
        n2 += n8;
        if ((n5 %= 8) > 0) {
            n3 = 0;
            while (n3 < n5) {
                if (byArray[n++] == 0) {
                    int n14 = n2;
                    byArray2[n14] = (byte)(byArray2[n14] & ~(1 << 7 - n3));
                } else {
                    int n15 = n2;
                    byArray2[n15] = (byte)(byArray2[n15] | 1 << 7 - n3);
                }
                ++n3;
            }
        }
    }

    public static int packPixels(int n, byte[] byArray, byte[] byArray2) {
        int n2 = (1 << n) - 1;
        int n3 = byArray.length;
        switch (n) {
            case 1: {
                int n4 = n3 % 8;
                int n5 = n3 / 8;
                n = n5 + 1;
                int n6 = n3;
                int n7 = 0;
                switch (n4) {
                    case 7: {
                        n7 = 0 | (byArray[--n6] & n2) << 1;
                    }
                    case 6: {
                        n7 |= (byArray[--n6] & n2) << 2;
                    }
                    case 5: {
                        n7 |= (byArray[--n6] & n2) << 3;
                    }
                    case 4: {
                        n7 |= (byArray[--n6] & n2) << 4;
                    }
                    case 3: {
                        n7 |= (byArray[--n6] & n2) << 5;
                    }
                    case 2: {
                        n7 |= (byArray[--n6] & n2) << 6;
                    }
                    case 1: {
                        byArray2[n5] = (byte)(n7 |= (byArray[--n6] & n2) << 7);
                        break;
                    }
                    case 0: {
                        --n;
                    }
                }
                n6 = n3 - n4;
                n3 = n5;
                while (--n3 >= 0) {
                    byArray2[n3] = (byte)(byArray[--n6] & n2 | (byArray[--n6] & n2) << 1 | (byArray[--n6] & n2) << 2 | (byArray[--n6] & n2) << 3 | (byArray[--n6] & n2) << 4 | (byArray[--n6] & n2) << 5 | (byArray[--n6] & n2) << 6 | (byArray[--n6] & n2) << 7);
                }
                return n;
            }
            case 2: {
                int n8 = n3 % 4;
                int n9 = n3 / 4;
                n = n9 + 1;
                int n10 = n3;
                int n11 = 0;
                switch (n8) {
                    case 3: {
                        n11 = 0 | (byArray[--n10] & n2) << 2;
                    }
                    case 2: {
                        n11 |= (byArray[--n10] & n2) << 4;
                    }
                    case 1: {
                        byArray2[n9] = (byte)(n11 |= (byArray[--n10] & n2) << 6);
                        break;
                    }
                    case 0: {
                        --n;
                    }
                }
                n10 = n3 - n8;
                n3 = n9;
                while (--n3 >= 0) {
                    byArray2[n3] = (byte)(byArray[--n10] & n2 | (byArray[--n10] & n2) << 2 | (byArray[--n10] & n2) << 4 | (byArray[--n10] & n2) << 6);
                }
                return n;
            }
            case 4: {
                int n12 = n3 % 2;
                int n13 = n3 / 2;
                n = n13 + 1;
                int n14 = n3;
                switch (n12) {
                    case 1: {
                        int n15 = 0 | (byArray[--n14] & n2) << 4;
                        byArray2[n13] = (byte)n15;
                        break;
                    }
                    case 0: {
                        --n;
                    }
                }
                n14 = n3 - n12;
                n3 = n13;
                while (--n3 >= 0) {
                    byArray2[n3] = (byte)(byArray[--n14] & n2 | (byArray[--n14] & n2) << 4);
                }
                return n;
            }
            case 8: {
                System.arraycopy(byArray, 0, byArray2, 0, n3);
                return n3;
            }
        }
        throw new IllegalArgumentException(new StringBuffer("depth must be 1 2 4 or 8, not ").append(n).toString());
    }

    public static void packPixels(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = n3 / 8;
        int n6 = 0;
        while (n6 < n5) {
            n4 = 0;
            if (nArray[n++] == -1) {
                n4 = 128;
            }
            if (nArray[n++] == -1) {
                n4 |= 0x40;
            }
            if (nArray[n++] == -1) {
                n4 |= 0x20;
            }
            if (nArray[n++] == -1) {
                n4 |= 0x10;
            }
            if (nArray[n++] == -1) {
                n4 |= 8;
            }
            if (nArray[n++] == -1) {
                n4 |= 4;
            }
            if (nArray[n++] == -1) {
                n4 |= 2;
            }
            if (nArray[n++] == -1) {
                n4 |= 1;
            }
            byArray[n2 + n6] = (byte)n4;
            ++n6;
        }
        n4 = n3 % 8;
        n3 = 7;
        n6 = 255;
        while (n4-- > 0) {
            if (nArray[n++] == -1) continue;
            n6 &= ~(1 << n3--);
        }
        byArray[n2 + n5] = (byte)n6;
    }

    public static void pixelDepthChange(int n, byte[] byArray, int n2) {
        if (n2 <= n) {
            throw new IllegalArgumentException("pixelDepth Must < newPixelSize");
        }
        n2 = (1 << n2) - 1;
        int n3 = (1 << n) - 1;
        n = byArray.length;
        while (--n >= 0) {
            byArray[n] = (byte)(byArray[n] * n2 / n3);
        }
    }

    public static void runCommands(Vector object) {
        object = ((Vector)object).elements();
        while (object.hasMoreElements()) {
            ((Runnable)object.nextElement()).run();
        }
    }

    public static JimiImageFactory stripStamping(JimiImageFactory jimiImageFactory) {
        if (JimiLicenseInformation.isCrippled()) {
            return jimiImageFactory;
        }
        JimiImageFactory jimiImageFactory2 = jimiImageFactory;
        while (jimiImageFactory2 instanceof JimiImageFactoryProxy) {
            jimiImageFactory2 = ((JimiImageFactoryProxy)jimiImageFactory2).getProxiedFactory();
        }
        if (jimiImageFactory2 instanceof MemoryJimiImageFactory || jimiImageFactory2.getClass().getName().equals("com.sun.jimi.core.VMemStampedJimiImageFactory")) {
            jimiImageFactory = jimiImageFactory2;
        }
        return jimiImageFactory;
    }
}

