/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.raster.MemoryByteRasterImage;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.MulticastImageConsumer;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;

public class OneshotByteRasterImage
extends MemoryByteRasterImage {
    protected byte[] pixelBuffer = new byte[1];
    protected byte[] rowUnpackedBuffer;
    protected int rowByteWidth;

    public OneshotByteRasterImage(int n, int n2, ColorModel object, boolean bl) {
        super(n, n2, (ColorModel)object);
        this.rowByteWidth = (n + 7) / 8;
        if (bl && !(object instanceof IndexColorModel)) {
            n = ((ColorModel)object).getRGB(0);
            n2 = ((ColorModel)object).getRGB(1);
            object = new byte[]{n >> 24, n2 >> 24};
            byte[] byArray = new byte[]{(byte)(n >> 16), (byte)(n2 >> 16)};
            byte[] byArray2 = new byte[]{(byte)(n >> 8), (byte)(n2 >> 8)};
            Object object2 = new byte[]{(byte)n, (byte)n2};
            object2 = new IndexColorModel(1, 2, byArray, byArray2, (byte[])object2, (byte[])object);
            this.setColorModel((ColorModel)object2);
        }
        try {
            this.initStorage();
            return;
        }
        catch (JimiException jimiException) {
            this.setError();
            return;
        }
    }

    protected void addWaitingConsumer(ImageConsumer imageConsumer) {
        imageConsumer.imageComplete(1);
    }

    public void getRectanglePacked(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
    }

    public void getRowPacked(int n, byte[] byArray, int n2) {
    }

    protected void initStorage() {
        this.rowUnpackedBuffer = new byte[this.rowByteWidth << 3];
    }

    protected synchronized void sendPixel(int n, int n2, byte by) {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer multicastImageConsumer = this.getDirectConsumer();
        this.pixelBuffer[0] = by;
        multicastImageConsumer.setPixels(n, n2, 1, 1, this.getColorModel(), this.pixelBuffer, 0, 1);
    }

    protected void sendRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
        if (!this.hasDirectConsumer()) {
            return;
        }
        this.getDirectConsumer().setPixels(n, n2, n3, n4, this.getColorModel(), byArray, n5, n6);
    }

    protected void sendRectanglePacked(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer multicastImageConsumer = this.getDirectConsumer();
        n6 = 0;
        while (n6 < n4) {
            JimiUtil.expandOneBitPixels(byArray, this.rowUnpackedBuffer, n3, n6 * n3 << 3, 0);
            multicastImageConsumer.setPixels(n, n2 + n6, n3, 1, this.getColorModel(), this.rowUnpackedBuffer, 0, n3);
            ++n6;
        }
    }

    protected void sendRegionToConsumerFully(ImageConsumer imageConsumer, Rectangle rectangle) {
        throw new ImageAccessException();
    }

    protected void sendRow(int n, byte[] byArray, int n2) {
        if (!this.hasDirectConsumer()) {
            return;
        }
        this.getDirectConsumer().setPixels(0, n, this.getWidth(), 1, this.getColorModel(), byArray, n2, 0);
    }

    protected void sendToConsumerFully(ImageConsumer imageConsumer) {
        throw new ImageAccessException();
    }

    public void setPixel(int n, int n2, byte by) {
        this.setModified();
        this.sendPixel(n, n2, by);
    }

    public void setRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
        this.setModified();
        this.sendRectangle(n, n2, n3, n4, byArray, n5, n6);
    }

    public void setRectanglePacked(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
        this.setModified();
        this.sendRectanglePacked(n, n2, n3, n4, byArray, n5, n6);
    }

    public void setRowPacked(int n, byte[] byArray, int n2) {
        this.setRectanglePacked(0, n, this.getWidth(), 1, byArray, n2, this.getWidth());
    }
}

