/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiDecodingController;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.MemoryJimiImageFactory;
import com.sun.jimi.core.options.BasicFormatOptionSet;
import com.sun.jimi.core.options.FormatOption;
import com.sun.jimi.core.options.FormatOptionSet;
import com.sun.jimi.core.raster.CroppedRasterImageProducer;
import com.sun.jimi.core.raster.MutableJimiRasterImage;
import com.sun.jimi.core.util.MulticastImageConsumer;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class JimiRasterImageSupport
implements MutableJimiRasterImage,
ImageProducer {
    protected boolean error = false;
    protected boolean abort = false;
    protected boolean productionStarted = false;
    protected boolean modified = false;
    protected boolean productionAllowed = false;
    protected boolean finished = false;
    protected boolean newFrameData = false;
    protected ColorModel colorModel;
    protected Hashtable properties = new Hashtable();
    private boolean a;
    private int a;
    private int b;
    private int c;
    private int d = this.c = 30;
    private MulticastImageConsumer a;
    private MulticastImageConsumer b;
    private JimiDecodingController a;
    private JimiImageFactory a;
    private FormatOptionSet a = new MulticastImageConsumer();
    protected ColorModel sourceColorModel = null;
    protected boolean forceRGB = false;
    protected int[] rowBuf;
    protected boolean waitForOptions;

    protected JimiRasterImageSupport(int n, int n2, ColorModel colorModel) {
        this.b = new MulticastImageConsumer();
        this.a = new MemoryJimiImageFactory();
        this.a = new BasicFormatOptionSet(new FormatOption[0]);
        this.a = n;
        this.b = n2;
        this.setColorModel(colorModel);
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        this.a = true;
        this.initConsumer(imageConsumer);
        if (!this.productionStarted) {
            this.addDirectConsumer(imageConsumer);
            this.productionStarted = true;
            if (this.a != null) {
                this.a.requestDecoding();
                return;
            }
        } else {
            if (!this.finished && this.catchupConsumer(imageConsumer)) {
                this.addDirectConsumer(imageConsumer);
                return;
            }
            this.addWaitingConsumer(imageConsumer);
        }
    }

    protected void addDirectConsumer(ImageConsumer imageConsumer) {
        imageConsumer.setDimensions(this.getWidth(), this.getHeight());
        this.a.addConsumer(imageConsumer);
        imageConsumer.setHints(this.d);
    }

    protected synchronized void addWaitingConsumer(ImageConsumer imageConsumer) {
        imageConsumer.setDimensions(this.getWidth(), this.getHeight());
        imageConsumer.setHints(this.c);
        if (this.finished) {
            try {
                this.sendToConsumerFully(imageConsumer);
                imageConsumer.imageComplete(3);
                return;
            }
            catch (ImageAccessException imageAccessException) {
                imageConsumer.imageComplete(1);
                return;
            }
        }
        this.b.addConsumer(imageConsumer);
    }

    protected synchronized boolean catchupConsumer(ImageConsumer imageConsumer) {
        return false;
    }

    protected ColorModel getAppropriateColorModel(ColorModel colorModel) {
        return colorModel;
    }

    public void getChannelRectangle(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6, int n7) {
        try {
            if (this.rowBuf == null) {
                this.rowBuf = new int[n4];
            }
            n2 = 0;
            while (n2 < n5) {
                this.getRowRGB(n3 + n2, this.rowBuf, 0);
                int n8 = 0;
                while (n8 < n4) {
                    byArray[n6 + n8 + n2 * n7] = (byte)(this.rowBuf[n8] >>> n);
                    ++n8;
                }
                ++n2;
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            throw new ImageAccessException(runtimeException.toString());
        }
    }

    public synchronized void getChannelRow(int n, int n2, byte[] byArray, int n3) {
        this.getChannelRectangle(n, 0, n2, this.getWidth(), 1, byArray, n3, 0);
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public ImageProducer getCroppedImageProducer(int n, int n2, int n3, int n4) {
        return new CroppedRasterImageProducer(this, n, n2, n3, n4);
    }

    protected MulticastImageConsumer getDirectConsumer() {
        return this.a;
    }

    public JimiImageFactory getFactory() {
        return this.a;
    }

    public int getHeight() {
        return this.b;
    }

    public ImageProducer getImageProducer() {
        return this;
    }

    public FormatOptionSet getOptions() {
        if (this.waitForOptions) {
            this.waitFinished();
        }
        return this.a;
    }

    public abstract int getPixelRGB(int var1, int var2);

    public Hashtable getProperties() {
        return this.properties;
    }

    public synchronized void getRectangleARGBChannels(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
        if (this.rowBuf == null) {
            this.rowBuf = new int[n3];
        }
        n = 0;
        while (n < n4) {
            this.getRowRGB(n2 + n, this.rowBuf, 0);
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            while (n9 < n3) {
                byArray[n * n6 + n8++ + n5] = this.rowBuf[n7] >> 24;
                byArray[n * n6 + n8++ + n5] = (byte)(this.rowBuf[n7] >>> 16);
                byArray[n * n6 + n8++ + n5] = (byte)(this.rowBuf[n7] >>> 8);
                byArray[n * n6 + n8++ + n5] = (byte)this.rowBuf[n7++];
                ++n9;
            }
            ++n;
        }
    }

    public abstract void getRectangleRGB(int var1, int var2, int var3, int var4, int[] var5, int var6, int var7);

    public synchronized void getRectangleRGBAChannels(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
        if (this.rowBuf == null) {
            this.rowBuf = new int[n3];
        }
        n = 0;
        while (n < n4) {
            this.getRowRGB(n2 + n, this.rowBuf, 0);
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            while (n9 < n3) {
                byArray[n * n6 + n8++ + n5] = (byte)(this.rowBuf[n7] >>> 16);
                byArray[n * n6 + n8++ + n5] = (byte)(this.rowBuf[n7] >>> 8);
                byArray[n * n6 + n8++ + n5] = (byte)this.rowBuf[n7];
                byArray[n * n6 + n8++ + n5] = this.rowBuf[n7++] >> 24;
                ++n9;
            }
            ++n;
        }
    }

    public synchronized void getRectangleRGBChannels(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
        if (this.rowBuf == null) {
            this.rowBuf = new int[n3];
        }
        n = 0;
        while (n < n4) {
            this.getRowRGB(n2 + n, this.rowBuf, 0);
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            while (n9 < n3) {
                byArray[n * n6 + n8++ + n5] = (byte)(this.rowBuf[n7] >>> 16);
                byArray[n * n6 + n8++ + n5] = (byte)(this.rowBuf[n7] >>> 8);
                byArray[n * n6 + n8++ + n5] = (byte)this.rowBuf[n7++];
                ++n9;
            }
            ++n;
        }
    }

    public abstract void getRowRGB(int var1, int[] var2, int var3);

    public int getWidth() {
        return this.a;
    }

    protected boolean hasDirectConsumer() {
        return this.a.isEmpty() ^ true;
    }

    protected void initConsumer(ImageConsumer imageConsumer) {
        imageConsumer.setColorModel(this.getColorModel());
        imageConsumer.setProperties(this.properties);
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.a.contains(imageConsumer) || this.b.contains(imageConsumer);
    }

    public boolean isError() {
        return this.error;
    }

    public boolean mustWaitForOptions() {
        return this.waitForOptions;
    }

    public synchronized void produceCroppedImage(ImageConsumer imageConsumer, Rectangle rectangle) {
        this.waitFinished();
        this.initConsumer(imageConsumer);
        imageConsumer.setDimensions(rectangle.width, rectangle.height);
        imageConsumer.setHints(this.c);
        try {
            this.sendRegionToConsumerFully(imageConsumer, rectangle);
            imageConsumer.imageComplete(3);
            return;
        }
        catch (Exception exception) {
            imageConsumer.imageComplete(1);
            return;
        }
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        this.a.removeConsumer(imageConsumer);
        this.b.removeConsumer(imageConsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        this.addWaitingConsumer(imageConsumer);
    }

    protected abstract void sendRegionToConsumerFully(ImageConsumer var1, Rectangle var2);

    protected abstract void sendToConsumerFully(ImageConsumer var1);

    public void setColorModel(ColorModel colorModel) {
        if (!this.forceRGB) {
            this.colorModel = this.getAppropriateColorModel(colorModel);
            this.forceRGB |= colorModel != this.colorModel;
        }
        this.sourceColorModel = colorModel;
    }

    public synchronized void setDecodingController(JimiDecodingController jimiDecodingController) {
        this.a = jimiDecodingController;
        if (this.a || this.productionStarted) {
            jimiDecodingController.requestDecoding();
        }
    }

    public synchronized void setError() {
        this.error = true;
        this.a.imageComplete(1);
        this.b.imageComplete(1);
        this.notifyAll();
    }

    public void setFactory(JimiImageFactory jimiImageFactory) {
        this.a = jimiImageFactory;
    }

    public synchronized void setFinished() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.newFrameData = false;
        this.a.imageComplete(3);
        this.a.removeAll();
        if (!this.b.isEmpty()) {
            try {
                this.sendToConsumerFully(this.b);
            }
            catch (ImageAccessException imageAccessException) {
                this.setError();
                return;
            }
        }
        this.b.getConsumers();
        this.b.imageComplete(3);
        this.b.removeAll();
        this.notifyAll();
    }

    public void setImageConsumerHints(int n) {
        this.d = n |= 0x10;
    }

    protected void setModified() {
        if (!this.modified) {
            this.modified = true;
            this.a.setHints(this.d);
            this.productionStarted = true;
            if (this.a != null) {
                this.a.requestDecoding();
            }
        }
    }

    public void setOptions(FormatOptionSet formatOptionSet) {
        this.a = formatOptionSet;
    }

    public void setWaitForOptions(boolean bl) {
        this.waitForOptions = bl;
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.removeConsumer(imageConsumer);
        this.addConsumer(imageConsumer);
    }

    public synchronized void waitFinished() {
        this.productionStarted = true;
        if (this.a != null) {
            this.a.requestDecoding();
        }
        while (!this.finished && !this.error) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void waitInfoAvailable() {
    }
}

