/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.options;

import com.sun.jimi.core.options.BasicFormatOptionSet;
import com.sun.jimi.core.options.BooleanOption;
import com.sun.jimi.core.options.FormatOption;
import com.sun.jimi.core.options.IntOption;

public class GIFOptions
extends BasicFormatOptionSet {
    public static final int NO_TRANSPARENCY = -1;
    public static final int LOOP_FOREVER = 0;
    protected IntOption transparentIndex = new IntOption("Transparent index", "The palette index of the image which should be treated as transparent, or -1 for no transparency.", -1);
    protected BooleanOption interlace = new BooleanOption("Interlace", "Whether the image is interlaced.", false);
    protected IntOption frameDelay = new IntOption("Frame delay", "For Animated GIFs, the number of hundredths of seconds to display a frame for.", 100, 0, 65535);
    protected BooleanOption localPalette = new BooleanOption("Local palette", "For Animated GIFs, whether each frame has its own palette.", true);
    protected IntOption numberOfLoops = new IntOption("Number of loops", "For Animated GIFs, how many times to loop through the animation, or -1 to loop forever.", 0);

    public GIFOptions() {
        this.initWithOptions(new FormatOption[]{this.transparentIndex, this.interlace, this.frameDelay, this.localPalette, this.numberOfLoops});
    }

    public int getFrameDelay() {
        return this.frameDelay.getIntValue();
    }

    public int getNumberOfLoops() {
        return this.numberOfLoops.getIntValue();
    }

    public int getTransparentIndex() {
        return this.transparentIndex.getIntValue();
    }

    public boolean isInterlaced() {
        return this.interlace.getBooleanValue();
    }

    public boolean isUsingLocalPalettes() {
        return this.localPalette.getBooleanValue();
    }

    public void setFrameDelay(int n) {
        this.frameDelay.setIntValue(n);
    }

    public void setInterlaced(boolean bl) {
        this.interlace.setBooleanValue(bl);
    }

    public void setNumberOfLoops(int n) {
        this.numberOfLoops.setIntValue(n);
    }

    public void setTransparentIndex(int n) {
        this.transparentIndex.setIntValue(n);
    }

    public void setUseLocalPalettes(boolean bl) {
        this.localPalette.setBooleanValue(bl);
    }

    public final String toString() {
        return new StringBuffer("[transparentIndex=").append(this.transparentIndex.getIntValue()).append(", interlace=").append(this.interlace.getBooleanValue()).append(", frameDelay=").append(this.frameDelay.getIntValue()).append(", localPalette=").append(this.localPalette.getBooleanValue()).append(", numberOfLoops=").append(this.numberOfLoops.getIntValue()).append("]").toString();
    }
}

