/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.filters;

import com.sun.jimi.core.filters.ReplicatingScaleFilter;
import java.awt.image.ColorModel;

public class AspectReplicateScaleFilter
extends ReplicatingScaleFilter {
    protected int fixedDimension;
    protected int maxWidth;
    protected int maxHeight;
    protected boolean noScaling;

    public AspectReplicateScaleFilter(int n, int n2) {
        super(n, n2);
        this.maxWidth = n;
        this.maxHeight = n2;
    }

    public void setDimensions(int n, int n2) {
        this.srcWidth = n;
        this.srcHeight = n2;
        if (n <= this.maxWidth && n2 <= this.maxHeight) {
            this.destWidth = n;
            this.destHeight = n2;
            this.noScaling = true;
            this.consumer.setDimensions(n, n2);
            return;
        }
        double d2 = (double)n / (double)this.maxWidth;
        double d3 = (double)n2 / (double)this.maxHeight;
        if (d2 < d3) {
            n2 = this.maxHeight;
            n = (int)((double)n / d3);
        } else {
            n = this.maxWidth;
            n2 = (int)((double)n2 / d2);
        }
        this.destWidth = n;
        this.destHeight = n2;
        this.consumer.setDimensions(this.destWidth, this.destHeight);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        if (this.noScaling) {
            this.consumer.setPixels(n, n2, n3, n4, colorModel, byArray, n5, n6);
            return;
        }
        super.setPixels(n, n2, n3, n4, colorModel, byArray, n5, n6);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (this.noScaling) {
            this.consumer.setPixels(n, n2, n3, n4, colorModel, nArray, n5, n6);
            return;
        }
        super.setPixels(n, n2, n3, n4, colorModel, nArray, n5, n6);
    }
}

