/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.xpm;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import java.awt.image.IndexColorModel;
import java.io.OutputStream;
import java.io.PrintStream;

public class XPMEncoder
extends JimiEncoderBase {
    protected static final String MAGIC = "/* XPM */\n";
    protected static final String HEADER_STRING = "static char* image[]={\n";
    protected static char[] paletteStringCharacters;
    protected PrintStream output;
    protected AdaptiveRasterImage jimiImage;
    protected int state;
    protected int paletteSize;
    protected String[] paletteStrings;
    protected int entrySize;

    public XPMEncoder() {
        if (paletteStringCharacters == null) {
            this.generatePaletteStringCharacters();
        }
    }

    protected void createPaletteStrings(IndexColorModel indexColorModel) {
        int n = indexColorModel.getMapSize();
        this.entrySize = 0;
        int n2 = n;
        do {
            ++this.entrySize;
        } while ((n2 /= paletteStringCharacters.length) != 0);
        this.paletteStrings = new String[n];
        n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            String string = "";
            int n4 = 0;
            while (n4 < this.entrySize) {
                string = new StringBuffer(String.valueOf(String.valueOf(paletteStringCharacters[n3 % paletteStringCharacters.length]))).append(string).toString();
                n3 /= paletteStringCharacters.length;
                ++n4;
            }
            this.paletteStrings[n2] = string;
            ++n2;
        }
    }

    protected void doImageEncode() {
        if (!(this.jimiImage.getColorModel() instanceof IndexColorModel)) {
            throw new JimiException("XPM only encodes palette-based images.");
        }
        IndexColorModel indexColorModel = (IndexColorModel)this.jimiImage.getColorModel();
        this.createPaletteStrings(indexColorModel);
        this.writeHeader();
        this.writePalette(indexColorModel);
        this.writeImageData();
        this.writeTrailer();
    }

    public boolean driveEncoder() {
        try {
            this.jimiImage = this.getJimiImage();
            this.doImageEncode();
        }
        catch (Exception exception) {
            this.state = 1;
            exception.printStackTrace();
            throw new JimiException(exception.toString());
        }
        this.state = 2;
        return false;
    }

    protected void generatePaletteStringCharacters() {
        paletteStringCharacters = new char[62];
        int n = 0;
        int n2 = 48;
        while (n2 <= 57) {
            XPMEncoder.paletteStringCharacters[n++] = n2;
            n2 = (char)(n2 + 1);
        }
        n2 = 97;
        while (n2 <= 122) {
            XPMEncoder.paletteStringCharacters[n++] = n2;
            n2 = (char)(n2 + 1);
        }
        n2 = 65;
        while (n2 <= 90) {
            XPMEncoder.paletteStringCharacters[n++] = n2;
            n2 = (char)(n2 + 1);
        }
    }

    public int getState() {
        return this.state;
    }

    public void initSpecificEncoder(OutputStream outputStream, AdaptiveRasterImage adaptiveRasterImage) {
        this.output = new PrintStream(outputStream);
    }

    protected String toPaddedHexString(int n) {
        String string = Integer.toHexString(n);
        while (string.length() < 6) {
            string = new StringBuffer("0").append(string).toString();
        }
        return string;
    }

    protected void writeHeader() {
        this.output.print(MAGIC);
        this.output.print(HEADER_STRING);
        int n = this.jimiImage.getWidth();
        int n2 = this.jimiImage.getHeight();
        this.output.println(new StringBuffer("\"").append(n).append(" ").append(n2).append(" ").append(this.paletteStrings.length).append(" ").append(this.entrySize).append("\",").toString());
    }

    protected void writeImageData() {
        int[] nArray = new int[this.jimiImage.getWidth()];
        int n = this.jimiImage.getHeight();
        int n2 = 0;
        while (n2 < n) {
            this.jimiImage.getChannel(n2, nArray, 0);
            this.output.print("\"");
            int n3 = 0;
            while (n3 < nArray.length) {
                this.output.print(this.paletteStrings[nArray[n3]]);
                ++n3;
            }
            if (n2 < n - 1) {
                this.output.println("\",");
            }
            ++n2;
        }
    }

    protected void writePalette(IndexColorModel indexColorModel) {
        int n = 0;
        while (n < this.paletteStrings.length) {
            this.output.println(new StringBuffer("\"").append(this.paletteStrings[n]).append(" c #").append(this.toPaddedHexString(indexColorModel.getRGB(n) & 0xFFFFFF)).append("\",").toString());
            ++n;
        }
    }

    protected void writeTrailer() {
        this.output.println("\"};");
    }
}

