/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.xbm;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.util.JimiImageColorReducer;
import java.awt.image.IndexColorModel;
import java.io.OutputStream;
import java.io.PrintStream;

public class XBMEncoder
extends JimiEncoderBase {
    protected PrintStream output;
    protected AdaptiveRasterImage jimiImage;
    protected int state;

    protected void doImageEncode() {
        this.jimiImage = this.getJimiImage();
        this.writeHeader();
        this.writeImageData();
        this.writeTrailer();
    }

    public boolean driveEncoder() {
        try {
            this.jimiImage = this.getJimiImage();
            this.doImageEncode();
        }
        catch (Exception exception) {
            this.state = 1;
            throw new JimiException(exception.getMessage());
        }
        this.state = 2;
        return false;
    }

    public int getState() {
        return this.state;
    }

    public void initSpecificEncoder(OutputStream outputStream, AdaptiveRasterImage adaptiveRasterImage) {
        this.output = new PrintStream(outputStream);
    }

    protected int intensity(int n) {
        return (n & 0xFF) + (n >> 8 & 0xFF) + (n >> 16 & 0xFF);
    }

    protected void writeHeader() {
        this.output.println(new StringBuffer("#define jimi_xbitmap_width ").append(this.jimiImage.getWidth()).toString());
        this.output.println(new StringBuffer("#define jimi_xbitmap_height ").append(this.jimiImage.getHeight()).toString());
        this.output.println("static char jimi_xbitmap_bits = {");
    }

    protected void writeImageData() {
        int n;
        Object object = new JimiImageColorReducer(2);
        this.jimiImage = new AdaptiveRasterImage(((JimiImageColorReducer)object).colorReduceFS(this.jimiImage.getBackend()));
        object = (IndexColorModel)this.jimiImage.getColorModel();
        int n2 = this.intensity(((IndexColorModel)object).getRGB(0));
        n = n2 < (n = this.intensity(((IndexColorModel)object).getRGB(1))) ? n2 : n;
        n2 = this.jimiImage.getWidth();
        int n3 = this.jimiImage.getHeight();
        n2 = n2 % 8 == 0 ? n2 / 8 : n2 / 8 + 1;
        int[] nArray = new int[n2 << 3];
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            this.jimiImage.getChannel(n4, nArray, 0);
            int n6 = 0;
            while (n6 < n2) {
                int n7 = 0;
                int n8 = 0;
                while (n8 < 8) {
                    if (nArray[n5++] != n) {
                        n7 = (byte)(n7 | 1 << n8);
                    }
                    ++n8;
                }
                this.output.print(new StringBuffer("0x").append(Integer.toHexString(n7 & 0xFF)).toString());
                if (n4 != n3 - 1 || n6 < n2 - 1) {
                    this.output.print(",");
                }
                ++n6;
            }
            this.output.println();
            ++n4;
        }
    }

    protected void writeTrailer() {
        this.output.println("};");
    }
}

