/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.sunraster;

import com.sun.jimi.core.compat.AdaptiveRasterImage;
import java.awt.image.IndexColorModel;
import java.io.DataOutputStream;
import java.io.OutputStream;

public class SunRasterHeader {
    protected static final int MAGIC_NUMBER = 1504078485;
    public static final int TYPE_OLD = 0;
    public static final int TYPE_STANDARD = 1;
    public static final int TYPE_BYTE_ENCODED = 2;
    public static final int TYPE_RGB = 3;
    public static final int TYPE_TIFF = 4;
    public static final int TYPE_IFF = 5;
    public static final int TYPE_EXPERIMENTAL = 65535;
    public static final int NO_COLOR_MAP = 0;
    public static final int RGB_COLOR_MAP = 1;
    public static final int RAW_COLOR_MAP = 2;
    protected static final int NO_COLORMAP = 0;
    protected static final int RGB_COLORMAP = 1;
    protected static final int RAW_COLORMAP = 2;
    protected AdaptiveRasterImage jimiImage_;
    protected int width_;
    protected int height_;
    protected int depth_;
    protected int type_;
    protected int colorMapType_;
    protected int colorMapLength_;
    protected IndexColorModel palette_;
    protected int scanLineSize_;

    public SunRasterHeader() {
        this.type_ = 1;
        this.colorMapType_ = 0;
    }

    public SunRasterHeader(AdaptiveRasterImage adaptiveRasterImage) {
        this.width_ = adaptiveRasterImage.getWidth();
        this.height_ = adaptiveRasterImage.getHeight();
        this.type_ = 1;
        this.colorMapType_ = 0;
    }

    public int getDepth() {
        return this.depth_;
    }

    public IndexColorModel getPalette() {
        return this.palette_;
    }

    public int getType() {
        return this.type_;
    }

    public void setDepth(int n) {
        this.depth_ = n;
    }

    public void setPalette(IndexColorModel indexColorModel) {
        this.palette_ = indexColorModel;
    }

    public void setType(int n) {
        this.type_ = n;
    }

    protected void writePaletteInfoTo(DataOutputStream dataOutputStream) {
        if (this.palette_ == null) {
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            return;
        }
        byte[] byArray = new byte[this.palette_.getMapSize()];
        dataOutputStream.writeInt(1);
        dataOutputStream.writeInt(byArray.length * 3);
        this.palette_.getReds(byArray);
        dataOutputStream.write(byArray);
        this.palette_.getGreens(byArray);
        dataOutputStream.write(byArray);
        this.palette_.getBlues(byArray);
        dataOutputStream.write(byArray);
    }

    public void writeTo(OutputStream outputStream) {
        outputStream = new DataOutputStream(outputStream);
        ((DataOutputStream)outputStream).writeInt(1504078485);
        ((DataOutputStream)outputStream).writeInt(this.width_);
        ((DataOutputStream)outputStream).writeInt(this.height_);
        ((DataOutputStream)outputStream).writeInt(this.depth_);
        ((DataOutputStream)outputStream).writeInt(0);
        ((DataOutputStream)outputStream).writeInt(this.type_);
        this.writePaletteInfoTo((DataOutputStream)outputStream);
        ((DataOutputStream)outputStream).flush();
    }
}

