/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.sunraster;

import com.sun.jimi.core.InvalidOptionException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.OptionsObject;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.encoder.sunraster.PaletteSunRasterEncoder;
import com.sun.jimi.core.encoder.sunraster.RGBSunRasterEncoder;
import com.sun.jimi.core.encoder.sunraster.SpecificEncoder;
import com.sun.jimi.core.encoder.sunraster.SunRasterHeader;
import com.sun.jimi.core.options.SunRasterOptions;
import com.sun.jimi.util.ArrayEnumeration;
import com.sun.jimi.util.PropertyOwner;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.OutputStream;
import java.util.Enumeration;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class SunRasterEncoder
extends JimiEncoderBase
implements OptionsObject {
    protected int state_;
    protected OutputStream output_;
    protected boolean useRLE_ = true;
    private static Boolean[] a = PropertyOwner.BOOLEAN_ARRAY;
    private static String[] a = new String[]{"compression"};

    public void clearProperties() {
        this.useRLE_ = true;
    }

    protected SpecificEncoder createEncoder() {
        AdaptiveRasterImage adaptiveRasterImage = this.getJimiImage();
        SunRasterHeader sunRasterHeader = new SunRasterHeader(adaptiveRasterImage);
        Object object = adaptiveRasterImage.getColorModel();
        if (object instanceof IndexColorModel && ((ColorModel)object).getPixelSize() == 8) {
            object = new PaletteSunRasterEncoder();
            ((PaletteSunRasterEncoder)object).setUseRLE(this.useRLE_);
        } else {
            object = new RGBSunRasterEncoder();
        }
        ((SpecificEncoder)object).initEncoder(sunRasterHeader, this.output_, adaptiveRasterImage);
        return object;
    }

    public boolean driveEncoder() {
        try {
            this.createEncoder().doImageEncode();
        }
        catch (JimiException jimiException) {
            this.state_ = 1;
            throw jimiException;
        }
        this.state_ = 2;
        return false;
    }

    public OptionsObject getOptionsObject() {
        return this;
    }

    public Object getPossibleValuesForProperty(String string) {
        if (string.equalsIgnoreCase("compression")) {
            return a;
        }
        return null;
    }

    public Object getProperty(String string) {
        return null;
    }

    public String getPropertyDescription(String string) {
        if (string.equalsIgnoreCase("compression")) {
            return "RLE compression tends to be smaller than not using compression";
        }
        throw new InvalidOptionException("No such option");
    }

    public Enumeration getPropertyNames() {
        return new ArrayEnumeration(a);
    }

    public int getState() {
        return this.state_;
    }

    public void initSpecificEncoder(OutputStream outputStream, AdaptiveRasterImage adaptiveRasterImage) {
        this.output_ = outputStream;
        if (adaptiveRasterImage.getOptions() instanceof SunRasterOptions) {
            this.useRLE_ = ((SunRasterOptions)adaptiveRasterImage.getOptions()).isUsingRLE();
        }
    }

    public void setProperty(String string, Object object) {
        if (string.equalsIgnoreCase("compression")) {
            try {
                this.useRLE_ = (Boolean)object;
            }
            catch (ClassCastException classCastException) {
                throw new InvalidOptionException("Must specify a java.lang.Boolean value");
            }
        }
        throw new InvalidOptionException("No such option");
    }
}

