/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.sunraster;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.sunraster.RLEOutputStream;
import com.sun.jimi.core.encoder.sunraster.SpecificEncoder;
import com.sun.jimi.core.encoder.sunraster.SunRasterHeader;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.OutputStream;

public class PaletteSunRasterEncoder
extends SpecificEncoder {
    protected boolean useRLE_ = false;

    public void doImageEncode() {
        this.getJimiImage();
        try {
            this.writeImage();
            return;
        }
        catch (IOException iOException) {
            throw new JimiException(iOException.toString());
        }
    }

    public void setUseRLE(boolean bl) {
        this.useRLE_ = bl;
    }

    protected void writeImage() {
        AdaptiveRasterImage adaptiveRasterImage = this.getJimiImage();
        Object object = this.getHeader();
        ((SunRasterHeader)object).setDepth(8);
        if (this.useRLE_) {
            ((SunRasterHeader)object).setType(2);
        } else {
            ((SunRasterHeader)object).setType(1);
        }
        ((SunRasterHeader)object).setPalette((IndexColorModel)adaptiveRasterImage.getColorModel());
        this.writeHeader();
        object = this.getOutputStream();
        if (this.useRLE_) {
            object = new RLEOutputStream((OutputStream)object);
        }
        int n = adaptiveRasterImage.getHeight();
        int n2 = adaptiveRasterImage.getWidth();
        if (n2 % 2 != 0) {
            ++n2;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n) {
            adaptiveRasterImage.getChannel(0, n3, byArray, 0);
            ((OutputStream)object).write(byArray);
            ++n3;
        }
        ((OutputStream)object).flush();
    }
}

