/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.pcx;

import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.encoder.pcx.RLEOutputStreamForPCX;
import com.sun.jimi.core.util.LEDataOutputStream;
import java.awt.Toolkit;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class PCXEncoder
extends JimiEncoderBase {
    private OutputStream a;
    private RLEOutputStreamForPCX a;
    private LEDataOutputStream a;
    private int a;
    private int b = 8;
    private int c = 1;
    private int d = 0;
    private int e = 1;
    private int f = 5;
    protected int COLOR_MODEL = 0;

    public boolean driveEncoder() {
        AdaptiveRasterImage adaptiveRasterImage = this.getJimiImage();
        try {
            this.writePcxHeader(this.a, adaptiveRasterImage);
            this.writePcxImage(this.a, adaptiveRasterImage);
            if (this.COLOR_MODEL == 0) {
                this.writePcxFooter(this.a, adaptiveRasterImage);
            }
            this.a.flush();
            this.a.flush();
            this.a.flush();
            this.a = 2;
        }
        catch (IOException iOException) {
            this.a = 1;
        }
        return false;
    }

    public void freeEncoder() {
        this.a = null;
        this.a = null;
        this.a = null;
        super.freeEncoder();
    }

    public int getState() {
        return this.a;
    }

    public void initSpecificEncoder(OutputStream outputStream, AdaptiveRasterImage adaptiveRasterImage) {
        this.a = 0;
        this.a = outputStream;
        if (adaptiveRasterImage.getColorModel() instanceof DirectColorModel) {
            this.c = 3;
            this.COLOR_MODEL = 1;
        }
        this.a = new LEDataOutputStream(new BufferedOutputStream(this.a));
        this.a = new RLEOutputStreamForPCX(this.a);
    }

    public byte[] makePalette(IndexColorModel indexColorModel, int n) {
        int n2 = n * 3;
        byte[] byArray = new byte[n2];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        int n3 = indexColorModel.getMapSize();
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n3];
        byte[] byArray4 = new byte[n3];
        indexColorModel.getReds(byArray2);
        indexColorModel.getGreens(byArray3);
        indexColorModel.getBlues(byArray4);
        try {
            int n4 = n < n3 ? n : n3;
            int n5 = 0;
            while (n5 < n4) {
                byteArrayOutputStream.write(byArray2[n5]);
                byteArrayOutputStream.write(byArray3[n5]);
                byteArrayOutputStream.write(byArray4[n5]);
                ++n5;
            }
            if (n > n3) {
                n3 = 0;
                while (n3 < n - n4) {
                    byteArrayOutputStream.write(0);
                    byteArrayOutputStream.write(0);
                    byteArrayOutputStream.write(0);
                    ++n3;
                }
            }
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            this.a = 1;
        }
        return byArray;
    }

    public void writePcxFooter(LEDataOutputStream lEDataOutputStream, AdaptiveRasterImage object) {
        object = (IndexColorModel)((AdaptiveRasterImage)object).getColorModel();
        object = this.makePalette((IndexColorModel)object, 256);
        try {
            lEDataOutputStream.write(12);
            lEDataOutputStream.write((byte[])object, 0, ((Object)object).length);
            return;
        }
        catch (IOException iOException) {
            this.a = 1;
            return;
        }
    }

    public void writePcxHeader(LEDataOutputStream lEDataOutputStream, AdaptiveRasterImage object) {
        byte[] byArray = new byte[54];
        byte[] byArray2 = new byte[48];
        int n = ((AdaptiveRasterImage)object).getWidth();
        int n2 = ((AdaptiveRasterImage)object).getHeight();
        int n3 = n - 1;
        int n4 = n2 - 1;
        try {
            lEDataOutputStream.write(10);
            lEDataOutputStream.write((byte)this.f);
            lEDataOutputStream.write(1);
            lEDataOutputStream.write((byte)this.b);
            lEDataOutputStream.writeShort(0);
            lEDataOutputStream.writeShort(0);
            lEDataOutputStream.writeShort(n3);
            lEDataOutputStream.writeShort(n4);
            lEDataOutputStream.writeShort(n);
            lEDataOutputStream.writeShort(n2);
            if (this.COLOR_MODEL == 0) {
                object = (IndexColorModel)((AdaptiveRasterImage)object).getColorModel();
                byArray2 = this.makePalette((IndexColorModel)object, 16);
            }
            lEDataOutputStream.write(byArray2);
            lEDataOutputStream.write(0);
            lEDataOutputStream.write((byte)this.c);
            lEDataOutputStream.writeShort(n);
            lEDataOutputStream.writeShort(this.e);
            object = Toolkit.getDefaultToolkit();
            lEDataOutputStream.writeShort(((Toolkit)object).getScreenSize().width);
            lEDataOutputStream.writeShort(((Toolkit)object).getScreenSize().height);
            lEDataOutputStream.write(byArray);
            lEDataOutputStream.flush();
            return;
        }
        catch (IOException iOException) {
            this.a = 1;
            return;
        }
    }

    public void writePcxImage(RLEOutputStreamForPCX rLEOutputStreamForPCX, AdaptiveRasterImage adaptiveRasterImage) {
        int n = adaptiveRasterImage.getWidth();
        int n2 = adaptiveRasterImage.getHeight();
        this.d = n + 1;
        byte[] byArray = new byte[this.d];
        try {
            int n3 = 0;
            while (n3 < n2) {
                if (this.COLOR_MODEL == 0) {
                    adaptiveRasterImage.getChannel(0, n3, byArray, 0);
                    rLEOutputStreamForPCX.write(byArray);
                } else {
                    adaptiveRasterImage.setRGBDefault(true);
                    adaptiveRasterImage.getChannel(1, n3, byArray, 0);
                    rLEOutputStreamForPCX.write(byArray);
                    adaptiveRasterImage.getChannel(2, n3, byArray, 0);
                    rLEOutputStreamForPCX.write(byArray);
                    adaptiveRasterImage.getChannel(3, n3, byArray, 0);
                    rLEOutputStreamForPCX.write(byArray);
                }
                this.setProgress(n3 * 100 / n2);
                ++n3;
            }
            return;
        }
        catch (IOException iOException) {
            this.a = 1;
            return;
        }
    }
}

