/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.jpg;

import com.sun.jimi.core.encoder.jpg.CompressInfo;
import com.sun.jimi.core.encoder.jpg.JpegComponentInfo;
import com.sun.jimi.core.encoder.jpg.util;

public class CompressSetup {
    public static final short MAX_COMPS_IN_SCAN = 4;
    public static final short DCTSIZE = 8;
    public static final short MAX_BLOCKS_IN_MCU = 10;
    public static final short BITS_IN_SAMPLE = 8;
    public static final short MAX_SAMP_FACTOR = 4;
    public static final byte CS_UNKNOWN = 0;
    public static final byte CS_GRAYSCALE = 1;
    public static final byte CS_RGB = 2;
    public static final byte CS_YCbCr = 3;

    public static void initial_setup(CompressInfo compressInfo) {
        JpegComponentInfo jpegComponentInfo;
        compressInfo.max_h_samp_factor = 1;
        compressInfo.max_v_samp_factor = 1;
        short s = 0;
        while (s < compressInfo.num_components) {
            jpegComponentInfo = compressInfo.comp_info[s];
            if (jpegComponentInfo.b <= 0 || jpegComponentInfo.b > 4 || jpegComponentInfo.c <= 0 || jpegComponentInfo.c > 4) {
                util.errexit("Bogus sampling factors");
            }
            compressInfo.max_h_samp_factor = (short)Math.max(compressInfo.max_h_samp_factor, jpegComponentInfo.b);
            compressInfo.max_v_samp_factor = (short)Math.max(compressInfo.max_v_samp_factor, jpegComponentInfo.c);
            s = (short)(s + 1);
        }
        s = 0;
        while (s < compressInfo.num_components) {
            jpegComponentInfo = compressInfo.comp_info[s];
            compressInfo.comp_info[s].a = (compressInfo.image_width * jpegComponentInfo.b + compressInfo.max_h_samp_factor - 1) / compressInfo.max_h_samp_factor;
            jpegComponentInfo.b = (compressInfo.image_height * jpegComponentInfo.c + compressInfo.max_v_samp_factor - 1) / compressInfo.max_v_samp_factor;
            s = (short)(s + 1);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static void a(CompressInfo compressInfo) {
        if (compressInfo.comps_in_scan > 4) {
            util.errexit("Too many components for interleaved scan");
        }
        compressInfo.MCUs_per_row = (compressInfo.image_width + (compressInfo.max_h_samp_factor << 3) - 1) / (compressInfo.max_h_samp_factor << 3);
        compressInfo.MCU_rows_in_scan = (compressInfo.image_height + (compressInfo.max_v_samp_factor << 3) - 1) / (compressInfo.max_v_samp_factor << 3);
        compressInfo.blocks_in_MCU = 0;
        short s = 0;
        while (s < compressInfo.comps_in_scan) {
            block6: {
                short s2;
                short s3;
                block5: {
                    block4: {
                        JpegComponentInfo jpegComponentInfo = compressInfo.cur_comp_info[s];
                        jpegComponentInfo.g = jpegComponentInfo.b;
                        jpegComponentInfo.h = jpegComponentInfo.c;
                        jpegComponentInfo.i = (short)(jpegComponentInfo.g * jpegComponentInfo.h);
                        jpegComponentInfo.c = util.roundUp(jpegComponentInfo.a, jpegComponentInfo.g << 3);
                        jpegComponentInfo.d = util.roundUp(jpegComponentInfo.b, jpegComponentInfo.h << 3);
                        s3 = jpegComponentInfo.i;
                        if (compressInfo.blocks_in_MCU + s3 > 10) break block4;
                        s2 = s3;
                        s3 = (short)(s2 - 1);
                        if (s2 > 0) break block5;
                        break block6;
                    }
                    util.errexit("Sampling factors too large for interleaved scan");
                    if (!true) break block5;
                    s2 = s3;
                    s3 = (short)(s2 - 1);
                    if (s2 <= 0) break block6;
                }
                do {
                    short s4 = compressInfo.blocks_in_MCU;
                    compressInfo.blocks_in_MCU = (short)(s4 + 1);
                    compressInfo.MCU_membership[s4] = s;
                    s2 = s3;
                    s3 = (short)(s2 - 1);
                } while (s2 > 0);
            }
            s = (short)(s + 1);
        }
    }

    public static void setCDefaults(CompressInfo compressInfo) {
        compressInfo.comp_info = null;
        compressInfo.data_precision = (short)8;
        compressInfo.jpeg_color_space = (short)3;
        compressInfo.num_components = (short)3;
        compressInfo.comps_in_scan = (short)3;
        compressInfo.comp_info = new JpegComponentInfo[3];
        compressInfo.comp_info[0] = new JpegComponentInfo();
        compressInfo.comp_info[0].a = 1;
        compressInfo.comp_info[0].b = (short)2;
        compressInfo.comp_info[0].c = (short)2;
        compressInfo.comp_info[0].d = 0;
        compressInfo.comp_info[0].e = 0;
        compressInfo.comp_info[0].f = 0;
        compressInfo.comp_info[1] = new JpegComponentInfo();
        compressInfo.comp_info[1].a = (short)2;
        compressInfo.comp_info[1].b = 1;
        compressInfo.comp_info[1].c = 1;
        compressInfo.comp_info[1].d = 1;
        compressInfo.comp_info[1].e = 1;
        compressInfo.comp_info[1].f = 1;
        compressInfo.comp_info[2] = new JpegComponentInfo();
        compressInfo.comp_info[2].a = (short)3;
        compressInfo.comp_info[2].b = 1;
        compressInfo.comp_info[2].c = 1;
        compressInfo.comp_info[2].d = 1;
        compressInfo.comp_info[2].e = 1;
        compressInfo.comp_info[2].f = 1;
        compressInfo.cur_comp_info = new JpegComponentInfo[4];
        compressInfo.cur_comp_info[0] = compressInfo.comp_info[0];
        compressInfo.cur_comp_info[1] = compressInfo.comp_info[1];
        compressInfo.cur_comp_info[2] = compressInfo.comp_info[2];
        compressInfo.interleave = true;
    }

    public static void setMDefaults(CompressInfo compressInfo) {
        compressInfo.jpeg_color_space = 1;
        compressInfo.num_components = 1;
        compressInfo.comp_info[0].b = 1;
        compressInfo.comp_info[0].c = 1;
        compressInfo.comps_in_scan = 1;
        compressInfo.interleave = false;
    }
}

