/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.ico;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.util.LEDataOutputStream;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.OutputStream;

public class ICOEncoder
extends JimiEncoderBase {
    protected static final int BMPINFOHEADER_SIZE = 40;
    protected LEDataOutputStream destination;
    public short TYPE_FLAG = 1;
    protected int stateFlag = 4;
    public int currentOffset = 0;

    public int computeBitCount(int n) {
        if (n <= 4) {
            return 2;
        }
        if (n <= 16) {
            return 4;
        }
        return 8;
    }

    public int computeImageSize(int n, int n2, int n3, int n4) {
        return n3 * n4;
    }

    public boolean driveEncoder() {
        AdaptiveRasterImage adaptiveRasterImage = this.getJimiImage();
        try {
            AdaptiveRasterImage[] adaptiveRasterImageArray = new AdaptiveRasterImage[1];
            AdaptiveRasterImage[] adaptiveRasterImageArray2 = adaptiveRasterImageArray;
            adaptiveRasterImageArray[0] = adaptiveRasterImage;
            this.writeICOCURDirectory(this.destination, adaptiveRasterImageArray2);
            this.writeDIBImage(this.destination, adaptiveRasterImage);
        }
        catch (IOException iOException) {
            this.stateFlag = 1;
            throw new JimiException(iOException.toString());
        }
        catch (JimiException jimiException) {
            this.stateFlag = 1;
            throw jimiException;
        }
        this.stateFlag = 2;
        return false;
    }

    public void freeEncoder() {
    }

    public int getState() {
        return this.stateFlag;
    }

    public void initSpecificEncoder(OutputStream outputStream, AdaptiveRasterImage adaptiveRasterImage) {
        this.destination = new LEDataOutputStream(outputStream);
    }

    protected void writeBitmapInfoHeader(LEDataOutputStream lEDataOutputStream, int n, int n2, AdaptiveRasterImage adaptiveRasterImage, IndexColorModel indexColorModel) {
        int n3 = adaptiveRasterImage.getWidth();
        int n4 = adaptiveRasterImage.getHeight() << 1;
        n2 = this.computeImageSize(n2, n, n3, n4);
        lEDataOutputStream.writeInt(40);
        lEDataOutputStream.writeInt(n3);
        lEDataOutputStream.writeInt(n4);
        lEDataOutputStream.writeShort(1);
        lEDataOutputStream.writeShort((short)n);
        lEDataOutputStream.writeInt(0);
        lEDataOutputStream.writeInt(n2);
        lEDataOutputStream.writeInt(0);
        lEDataOutputStream.writeInt(0);
        lEDataOutputStream.writeInt(0);
        lEDataOutputStream.writeInt(0);
    }

    protected void writeDIBImage(LEDataOutputStream lEDataOutputStream, AdaptiveRasterImage adaptiveRasterImage) {
        IndexColorModel indexColorModel = (IndexColorModel)adaptiveRasterImage.getColorModel();
        int n = indexColorModel.getMapSize();
        int n2 = this.computeBitCount(n);
        this.writeBitmapInfoHeader(lEDataOutputStream, n2, n, adaptiveRasterImage, indexColorModel);
        this.writeRGBQuads(lEDataOutputStream, indexColorModel);
        this.writePixels(lEDataOutputStream, n2, adaptiveRasterImage);
    }

    protected void writeICOCURDIREntry(LEDataOutputStream lEDataOutputStream, AdaptiveRasterImage adaptiveRasterImage) {
        IndexColorModel indexColorModel;
        try {
            indexColorModel = (IndexColorModel)adaptiveRasterImage.getColorModel();
        }
        catch (ClassCastException classCastException) {
            throw new JimiException("image/x-ico formats can only be created from palette images");
        }
        int n = indexColorModel.getMapSize();
        if (n > 256) {
            throw new JimiException("image/x-ico formats can only support palette with up to 256 colors");
        }
        int n2 = this.computeBitCount(n);
        int n3 = adaptiveRasterImage.getWidth();
        int n4 = adaptiveRasterImage.getHeight();
        if (n3 > 256 || n4 > 256) {
            throw new JimiException("image/x-ico formats can only encode images up to 256 x 256 pixels");
        }
        int n5 = this.computeImageSize(n, n2, n3, n4);
        lEDataOutputStream.writeByte((byte)n3);
        lEDataOutputStream.writeByte((byte)n4);
        lEDataOutputStream.writeByte((byte)n);
        lEDataOutputStream.writeByte(0);
        lEDataOutputStream.writeShort(0);
        lEDataOutputStream.writeShort((short)n2);
        n4 = 40 + n5 * n2 / 8 + (int)Math.pow(2.0, n2);
        lEDataOutputStream.writeInt(n4);
        lEDataOutputStream.writeInt(this.currentOffset);
        this.currentOffset += n5;
    }

    protected void writeICOCURDirectory(LEDataOutputStream lEDataOutputStream, AdaptiveRasterImage[] adaptiveRasterImageArray) {
        lEDataOutputStream.writeShort(0);
        lEDataOutputStream.writeShort(1);
        lEDataOutputStream.writeShort((short)adaptiveRasterImageArray.length);
        this.currentOffset = 6;
        this.currentOffset += adaptiveRasterImageArray.length << 4;
        int n = 0;
        while (n < adaptiveRasterImageArray.length) {
            this.writeICOCURDIREntry(lEDataOutputStream, adaptiveRasterImageArray[n]);
            ++n;
        }
    }

    protected void writePixels(LEDataOutputStream lEDataOutputStream, int n, AdaptiveRasterImage adaptiveRasterImage) {
        adaptiveRasterImage.setRGBDefault(false);
        int n2 = adaptiveRasterImage.getHeight();
        int n3 = adaptiveRasterImage.getWidth();
        int[] nArray = new int[n3];
        if (n == 2) {
            n = n2 - 1;
            while (n >= 0) {
                adaptiveRasterImage.getChannel(n, nArray, 0);
                --n;
            }
            byte[] byArray = new byte[n3 / 4];
            int n4 = 0;
            while (n4 < n2) {
                lEDataOutputStream.write(byArray);
                ++n4;
            }
            return;
        }
        if (n == 4) {
            int n5;
            n = n2 - 1;
            while (n >= 0) {
                adaptiveRasterImage.getChannel(n, nArray, 0);
                int n6 = 0;
                while (n6 < n3) {
                    n5 = (byte)((byte)(nArray[n6] << 4) | (byte)nArray[++n6]);
                    lEDataOutputStream.writeByte(n5);
                    ++n6;
                }
                --n;
            }
            byte[] byArray = new byte[n3 / 2];
            n5 = 0;
            while (n5 < n2) {
                lEDataOutputStream.write(byArray);
                ++n5;
            }
            return;
        }
        if (n == 8) {
            n = n2 - 1;
            while (n >= 0) {
                adaptiveRasterImage.getChannel(n, nArray, 0);
                int n7 = 0;
                while (n7 < n3) {
                    lEDataOutputStream.writeByte((byte)nArray[n7]);
                    ++n7;
                }
                --n;
            }
            byte[] byArray = new byte[n3];
            int n8 = 0;
            while (n8 < n2) {
                lEDataOutputStream.write(byArray);
                ++n8;
            }
        }
    }

    protected void writeRGBQuads(LEDataOutputStream lEDataOutputStream, IndexColorModel indexColorModel) {
        int n = indexColorModel.getMapSize();
        int n2 = this.computeBitCount(n);
        n2 = (int)Math.pow(2.0, n2) - n;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        indexColorModel.getReds(byArray);
        indexColorModel.getBlues(byArray2);
        indexColorModel.getGreens(byArray3);
        int n3 = 0;
        while (n3 < n) {
            lEDataOutputStream.writeByte(byArray2[n3]);
            lEDataOutputStream.writeByte(byArray3[n3]);
            lEDataOutputStream.writeByte(byArray[n3]);
            lEDataOutputStream.writeByte(0);
            ++n3;
        }
        byte[] byArray4 = new byte[4];
        n = 0;
        while (n < n2) {
            lEDataOutputStream.write(byArray4);
            ++n;
        }
    }
}

