/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.cur;

import com.sun.jimi.core.InvalidOptionException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.ico.ICOEncoder;
import com.sun.jimi.core.util.LEDataOutputStream;
import com.sun.jimi.util.ArrayEnumeration;
import com.sun.jimi.util.IntegerRange;
import java.awt.image.IndexColorModel;
import java.util.Enumeration;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CUREncoder
extends ICOEncoder {
    private short a = 0;
    private short b = 0;
    private static String[] a = new String[]{"hotspot location X", "hotpost location Y"};
    private static IntegerRange a;
    private static IntegerRange b;

    static {
        b = a = new IntegerRange(0, 65536);
    }

    public CUREncoder() {
        this.TYPE_FLAG = (short)2;
    }

    public void clearProperties() {
        this.setHotspot((short)0, (short)0);
    }

    public Object getPossibleValuesForProperty(String string) {
        if (string.equalsIgnoreCase("hotspot location X")) {
            return a;
        }
        if (string.equalsIgnoreCase("hotpost location Y")) {
            return b;
        }
        return null;
    }

    public String getPropertyDescription(String string) {
        if (string.equalsIgnoreCase("hotspot location X")) {
            return "The location of the cursor's pointer along the X-axis";
        }
        if (string.equalsIgnoreCase("hotpost location Y")) {
            return "The location of the cursor's pointer along the Y-axis";
        }
        throw new InvalidOptionException("No such option");
    }

    public Enumeration getPropertyNames() {
        return new ArrayEnumeration(a);
    }

    public void setHotspot(short s, short s2) {
        this.a = s;
        this.b = s2;
    }

    public void setProperty(String string, Object object) {
        short s;
        try {
            s = (short)((Integer)object).intValue();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidOptionException("Must specify a java.lang.Integer value");
        }
        if (string.equalsIgnoreCase("hotspot location X")) {
            if (!a.isInRange(object)) {
                throw new InvalidOptionException("Value is out of range");
            }
            this.setHotspot(s, this.b);
            return;
        }
        if (string.equalsIgnoreCase("hotpost location Y")) {
            if (!b.isInRange(object)) {
                throw new InvalidOptionException("Value is out of range");
            }
            this.setHotspot(this.a, s);
            return;
        }
        throw new InvalidOptionException("No such Option");
    }

    protected void writeICOCURDIREntry(LEDataOutputStream lEDataOutputStream, AdaptiveRasterImage adaptiveRasterImage) {
        IndexColorModel indexColorModel;
        try {
            indexColorModel = (IndexColorModel)adaptiveRasterImage.getColorModel();
        }
        catch (ClassCastException classCastException) {
            throw new JimiException("image/x-cur formats can only be created from palette images");
        }
        int n = indexColorModel.getMapSize();
        if (n > 256) {
            throw new JimiException("image/x-cur formats can only support palette with up to 256 colors");
        }
        int n2 = this.computeBitCount(n);
        int n3 = adaptiveRasterImage.getWidth();
        int n4 = adaptiveRasterImage.getHeight();
        if (n3 > 256 || n4 > 256) {
            throw new JimiException("image/x-cur formats can only encode images up to 256 x 256 pixels");
        }
        int n5 = this.computeImageSize(n, n2, n3, n4);
        lEDataOutputStream.writeByte((byte)n3);
        lEDataOutputStream.writeByte((byte)n4);
        lEDataOutputStream.writeByte((byte)n);
        lEDataOutputStream.writeByte(0);
        lEDataOutputStream.writeShort(this.a);
        lEDataOutputStream.writeShort(this.b);
        n4 = 40 + n5 * n2 / 8 + (int)Math.pow(2.0, n2);
        lEDataOutputStream.writeInt(n4);
        lEDataOutputStream.writeInt(this.currentOffset);
        this.currentOffset += n5;
    }
}

