/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.bmp;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.bmp.BMPEncoder;
import com.sun.jimi.core.encoder.bmp.BMPEncoderIfc;
import com.sun.jimi.core.util.LEDataOutputStream;
import java.awt.image.IndexColorModel;
import java.io.IOException;

public class BMP8Encoder
implements BMPEncoderIfc {
    public void encodeBMP(BMPEncoder bMPEncoder, AdaptiveRasterImage adaptiveRasterImage, LEDataOutputStream lEDataOutputStream) {
        try {
            IndexColorModel indexColorModel;
            int n = ((adaptiveRasterImage.getWidth() << 3) + 31) / 32 << 2;
            int n2 = n * adaptiveRasterImage.getHeight() + 1078;
            lEDataOutputStream.writeShort(19778);
            lEDataOutputStream.writeInt(n2);
            lEDataOutputStream.writeShort(0);
            lEDataOutputStream.writeShort(0);
            lEDataOutputStream.writeInt(1078);
            lEDataOutputStream.writeInt(40);
            lEDataOutputStream.writeInt(adaptiveRasterImage.getWidth());
            lEDataOutputStream.writeInt(adaptiveRasterImage.getHeight());
            lEDataOutputStream.writeShort(1);
            lEDataOutputStream.writeShort(8);
            lEDataOutputStream.writeInt(0);
            lEDataOutputStream.writeInt(n * adaptiveRasterImage.getHeight());
            lEDataOutputStream.writeInt(0);
            lEDataOutputStream.writeInt(0);
            lEDataOutputStream.writeInt(0);
            lEDataOutputStream.writeInt(0);
            try {
                indexColorModel = (IndexColorModel)adaptiveRasterImage.getColorModel();
            }
            catch (ClassCastException classCastException) {
                throw new JimiException("BMP8 encoding requires an IndexColorModel.");
            }
            int n3 = Math.max(256, indexColorModel.getMapSize());
            byte[] byArray = new byte[n3];
            byte[] byArray2 = new byte[n3];
            byte[] byArray3 = new byte[n3];
            indexColorModel.getReds(byArray);
            indexColorModel.getGreens(byArray2);
            indexColorModel.getBlues(byArray3);
            int n4 = 0;
            while (n4 < 256) {
                if (n4 < n3) {
                    lEDataOutputStream.writeByte(byArray3[n4]);
                    lEDataOutputStream.writeByte(byArray2[n4]);
                    lEDataOutputStream.writeByte(byArray[n4]);
                    lEDataOutputStream.writeByte(0);
                } else {
                    lEDataOutputStream.writeInt(0);
                }
                ++n4;
            }
            n4 = adaptiveRasterImage.getWidth();
            n3 = adaptiveRasterImage.getHeight() - 1;
            byArray = new byte[n4];
            n -= n4;
            n4 = n3;
            while (n4 >= 0) {
                adaptiveRasterImage.getChannel(0, n4, byArray, 0);
                lEDataOutputStream.write(byArray);
                int n5 = 0;
                while (n5 < n) {
                    lEDataOutputStream.write(0);
                    ++n5;
                }
                bMPEncoder.setProgress((n3 - n4) * 100 / n3);
                --n4;
            }
            return;
        }
        catch (IOException iOException) {
            throw new JimiException("BMP8Encoder encodeBMP() IOException encountered");
        }
    }
}

