/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.tga;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.tga.TGAColorMap;
import com.sun.jimi.core.decoder.tga.TGAFileHeader;
import com.sun.jimi.core.util.LEDataInputStream;
import com.sun.jimi.core.util.ProgressMonitorSupport;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TGADecoder
extends JimiDecoderBase {
    private AdaptiveRasterImage a;
    private LEDataInputStream a;
    private int a;
    private TGAFileHeader a;
    private TGAColorMap a;

    private void a(LEDataInputStream object) {
        switch (this.a.b) {
            case 1: {
                this.b((LEDataInputStream)object);
                return;
            }
            case 2: {
                switch (this.a.b) {
                    case 16: {
                        LEDataInputStream lEDataInputStream = object;
                        object = this;
                        int[] nArray = new int[((TGADecoder)object).a.e];
                        int n = 0;
                        while (n < ((TGADecoder)object).a.f) {
                            int n2 = 0;
                            while (n2 < ((TGADecoder)object).a.e) {
                                nArray[n2] = lEDataInputStream.readUnsignedShort() & Short.MAX_VALUE;
                                ++n2;
                            }
                            n2 = ((TGADecoder)object).a.a ? n : ((TGADecoder)object).a.f - n - 1;
                            ((TGADecoder)object).a.setChannel(n2, nArray);
                            ((ProgressMonitorSupport)object).setProgress(n * 100 / ((TGADecoder)object).a.f);
                            ++n;
                        }
                        return;
                    }
                    case 24: 
                    case 32: {
                        LEDataInputStream lEDataInputStream = object;
                        object = this;
                        int n = ((TGADecoder)object).a.e * (((TGADecoder)object).a.b / 8);
                        byte[] byArray = new byte[n];
                        int[] nArray = new int[((TGADecoder)object).a.e];
                        int n3 = 0;
                        while (n3 < ((TGADecoder)object).a.f) {
                            int n4;
                            int n5;
                            lEDataInputStream.readFully(byArray, 0, n);
                            if (((TGADecoder)object).a.b == 24) {
                                n5 = 0;
                                n4 = 0;
                                while (n4 < ((TGADecoder)object).a.e) {
                                    nArray[n4] = -16777216 + ((byArray[n5 + 2] & 0xFF) << 16) + ((byArray[n5 + 1] & 0xFF) << 8) + (byArray[n5] & 0xFF);
                                    n5 += 3;
                                    ++n4;
                                }
                            } else if (((TGADecoder)object).a.b == 32) {
                                n5 = 0;
                                n4 = 0;
                                while (n4 < ((TGADecoder)object).a.e) {
                                    nArray[n4] = ((byArray[n5 + 3] & 0xFF) << 24) + ((byArray[n5 + 2] & 0xFF) << 16) + ((byArray[n5 + 1] & 0xFF) << 8) + (byArray[n5] & 0xFF);
                                    n5 += 4;
                                    ++n4;
                                }
                            } else {
                                throw new JimiException("TGADecoder pixelDepth not 24 or 32");
                            }
                            n4 = ((TGADecoder)object).a.a ? n3 : ((TGADecoder)object).a.f - n3 - 1;
                            ((TGADecoder)object).a.setChannel(n4, nArray);
                            ((ProgressMonitorSupport)object).setProgress(n3 * 100 / ((TGADecoder)object).a.f);
                            ++n3;
                        }
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 3: {
                this.b((LEDataInputStream)object);
                return;
            }
            case 9: {
                throw new JimiException("TGADecoder Compressed Colormapped images not supported");
            }
            case 10: {
                throw new IOException("TGADecoder Compressed True Color images not supported");
            }
            case 11: {
                throw new IOException("TGADecoder Compressed Grayscale images not supported");
            }
            default: {
                return;
            }
        }
    }

    private void b(LEDataInputStream lEDataInputStream) {
        byte[] byArray = new byte[this.a.e];
        int n = 0;
        while (n < this.a.f) {
            lEDataInputStream.readFully(byArray, 0, this.a.e);
            int n2 = this.a.a ? n : this.a.f - n - 1;
            this.a.setChannel(0, n2, byArray);
            this.setProgress(n * 100 / this.a.f);
            ++n;
        }
    }

    public boolean driveDecoder() {
        try {
            this.a = new TGAFileHeader(this.a);
            this.a = new TGAColorMap(this.a, this.a);
            TGADecoder tGADecoder = this;
            block1 : switch (tGADecoder.a.b) {
                case 0: {
                    throw new JimiException("TGADecoder no image found.");
                }
                case 1: 
                case 9: {
                    if (tGADecoder.a.a == 0) {
                        throw new JimiException("TGADecoder color mapped images require a color map.");
                    }
                    tGADecoder.a.setColorModel(new IndexColorModel(8, tGADecoder.a.a.length / 3, tGADecoder.a.a, 0, tGADecoder.a.a == 32));
                    break;
                }
                case 3: 
                case 11: {
                    if (tGADecoder.a.a != 0) {
                        throw new JimiException("TGADecoder gray scale should not have color map.");
                    }
                    tGADecoder.a.setColorModel(new DirectColorModel(8, 255, 255, 255));
                    break;
                }
                case 2: 
                case 10: {
                    switch (tGADecoder.a.b) {
                        case 16: {
                            tGADecoder.a.setColorModel(new DirectColorModel(16, 31744, 992, 31));
                            break block1;
                        }
                        case 24: 
                        case 32: {
                            tGADecoder.a.setColorModel(new DirectColorModel(24, 0xFF0000, 65280, 255));
                        }
                    }
                }
            }
            tGADecoder.a.setSize(tGADecoder.a.e, tGADecoder.a.f);
            tGADecoder.a.setPixels();
            this.a |= 2;
            this.a(this.a);
            this.a |= 4;
            this.a.addFullCoverage();
        }
        catch (IOException iOException) {
            throw new JimiException("IO error reading TGA file");
        }
        return false;
    }

    public void freeDecoder() {
        this.a = null;
        this.a = null;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.a;
    }

    public int getState() {
        return this.a;
    }

    public void initDecoder(InputStream inputStream, AdaptiveRasterImage adaptiveRasterImage) {
        this.a = new LEDataInputStream(new BufferedInputStream(inputStream));
        this.a = adaptiveRasterImage;
        this.a = 0;
    }
}

