/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.sunraster;

import java.io.FilterInputStream;
import java.io.InputStream;

public class RLEInputStream
extends FilterInputStream {
    protected static final int RLE_ESCAPE = 128;
    protected int runLength_;
    protected int runValue_;

    public RLEInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public boolean markSupported() {
        return false;
    }

    public int read() {
        if (this.runLength_ != 0) {
            --this.runLength_;
            return this.runValue_;
        }
        int n = super.read() & 0xFF;
        if (n == 128) {
            n = super.read() & 0xFF;
            if (n == 0) {
                return 128;
            }
            this.runLength_ = n;
            this.runValue_ = super.read() & 0xFF;
            return this.runValue_;
        }
        return n;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read();
            if (n4 == -1) break;
            byArray[n + n3] = (byte)n4;
            ++n3;
        }
        return n3;
    }

    public void skip(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.read();
            ++n2;
        }
    }
}

