/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.pcx;

import com.sun.jimi.core.decoder.pcx.PCXHeader;
import com.sun.jimi.core.util.LEDataInputStream;
import java.io.IOException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class PCXImage {
    private PCXHeader a;
    private byte[] a;
    private int a;
    private int b;
    private int c;
    private int d = 0;
    private int e = 0;

    public PCXImage(LEDataInputStream lEDataInputStream, PCXHeader pCXHeader) {
        this.a = pCXHeader;
        this.c = pCXHeader.getPlanes();
        this.a = pCXHeader.getBytesPerLine();
        this.b = this.getBitCount();
        this.a = new byte[this.getHeight() * this.getWidth()];
        switch (this.b) {
            case 1: {
                if (this.c <= 0 || this.c > 4) break;
                this.get16ColorPCX(lEDataInputStream);
                return;
            }
            case 2: 
            case 4: {
                if (this.c == 1) {
                    this.get16ColorPCX(lEDataInputStream);
                }
            }
            case 8: {
                switch (this.c) {
                    case 1: {
                        this.get256ColorPCX(lEDataInputStream);
                        return;
                    }
                    case 3: 
                    case 4: {
                        this.getTrueColorPCX(lEDataInputStream);
                    }
                }
            }
        }
    }

    public void get16ColorPCX(LEDataInputStream lEDataInputStream) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = (this.a << 3) / this.b;
        if (n > n3) {
            n = n3;
        }
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[this.c * this.a];
        int n4 = 0;
        while (n4 < n2) {
            this.getPCXRow(lEDataInputStream, byArray2, this.c * this.a);
            if (this.c == 1) {
                this.pcxUnpackPixels(byArray, byArray2);
            } else {
                this.pcxPlanesToPixels(byArray, byArray2);
            }
            int n5 = 0;
            while (n5 < n) {
                this.a[n4 * this.getWidth() + n5] = byArray[n5];
                ++n5;
            }
            ++n4;
        }
    }

    public void get256ColorPCX(LEDataInputStream lEDataInputStream) {
        try {
            int n = 0;
            while (n < this.getHeight()) {
                int n2 = 0;
                while (n2 < this.a) {
                    int n3 = lEDataInputStream.readByte();
                    if ((n3 & 0xC0) == 192) {
                        byte by = lEDataInputStream.readByte();
                        n3 &= 0x3F;
                        int n4 = 0;
                        while (n4 < n3) {
                            this.a[n2 + n * this.a] = by;
                            ++n2;
                            ++n4;
                        }
                        continue;
                    }
                    this.a[n2 + n * this.a] = (byte)n3;
                    ++n2;
                }
                ++n;
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public int getBitCount() {
        return this.a.getDepth();
    }

    public int getBytesPerLine() {
        return this.a;
    }

    public int getHeight() {
        return this.a.getHeight();
    }

    public byte[] getImageData() {
        return this.a;
    }

    public void getPCXRow(LEDataInputStream lEDataInputStream, byte[] byArray, int n) {
        try {
            this.d = 0;
            int n2 = 0;
            while (n2 < n) {
                if (this.d > 0) {
                    byArray[n2++] = (byte)this.e;
                    --this.d;
                    continue;
                }
                this.e = lEDataInputStream.readByte();
                if ((this.e & 0xC0) != 192) {
                    byArray[n2++] = (byte)this.e;
                    continue;
                }
                this.d = this.e & 0x3F;
                this.e = lEDataInputStream.readByte();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void getTrueColorPCX(LEDataInputStream lEDataInputStream) {
    }

    public int getWidth() {
        return this.a.getWidth();
    }

    public void pcxPlanesToPixels(byte[] byArray, byte[] byArray2) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.c) {
            int n3 = 0;
            int n4 = 1 << n2;
            int n5 = 0;
            while (n5 < this.a) {
                byte by = byArray2[n++];
                int n6 = 128;
                while (n6 != 0) {
                    if ((by & n6) > 0) {
                        int n7 = n3;
                        byArray[n7] = (byte)(byArray[n7] | n4);
                    }
                    n6 >>= 1;
                    ++n3;
                }
                ++n5;
            }
            ++n2;
        }
    }

    public void pcxUnpackPixels(byte[] byArray, byte[] byArray2) {
        int n = this.a;
        int n2 = 0;
        int n3 = 0;
        if (this.b == 8) {
            while (--n >= 0) {
                byArray[n2++] = byArray2[n3++];
            }
            return;
        }
        if (this.b == 4) {
            while (--n >= 0) {
                byte by = byArray2[n3++];
                byArray[n2++] = (byte)(by >> 4 & 0xF);
                byArray[n2++] = (byte)(by & 0xF);
            }
            return;
        }
        if (this.b == 2) {
            while (--n >= 0) {
                byte by = byArray2[n3++];
                byArray[n2++] = (byte)(by >> 6 & 3);
                byArray[n2++] = (byte)(by >> 4 & 3);
                byArray[n2++] = (byte)(by >> 2 & 3);
                byArray[n2++] = (byte)(by & 3);
            }
            return;
        }
        if (this.b == 1) {
            while (--n >= 0) {
                byte by = byArray2[n3++];
                byArray[n2++] = (byte)(by >> 7 & 1);
                byArray[n2++] = (byte)(by >> 6 & 1);
                byArray[n2++] = (byte)(by >> 5 & 1);
                byArray[n2++] = (byte)(by >> 4 & 1);
                byArray[n2++] = (byte)(by >> 3 & 1);
                byArray[n2++] = (byte)(by >> 2 & 1);
                byArray[n2++] = (byte)(by >> 1 & 1);
                byArray[n2++] = (byte)(by & 1);
            }
        }
    }
}

