/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.pcx;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.pcx.PCXHeader;
import com.sun.jimi.core.decoder.pcx.PCXImage;
import com.sun.jimi.core.util.LEDataInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class PCXDecoder
extends JimiDecoderBase {
    private AdaptiveRasterImage a;
    private LEDataInputStream a;
    private int a;
    private int b;
    private PCXHeader a;
    private PCXImage a;

    public boolean driveDecoder() {
        try {
            this.a = new PCXHeader(this.a, this.b);
            this.a |= 2;
            this.a = new PCXImage(this.a, this.a);
            this.loadImage();
            this.a.addFullCoverage();
        }
        catch (IOException iOException) {
            this.a |= 1;
            throw new JimiException("IO error reading PCX file");
        }
        catch (JimiException jimiException) {
            this.a |= 1;
            throw jimiException;
        }
        return false;
    }

    public void freeDecoder() {
        this.a = null;
        this.a = null;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.a;
    }

    public int getState() {
        return this.a;
    }

    public void initDecoder(InputStream inputStream, AdaptiveRasterImage adaptiveRasterImage) {
        inputStream = new BufferedInputStream(inputStream, 2048);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        try {
            int n2;
            while ((n2 = ((FilterInputStream)inputStream).read(byArray)) != -1) {
                n += n2;
                byteArrayOutputStream.write(byArray);
            }
        }
        catch (IOException iOException) {}
        this.a = new LEDataInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        this.b = n;
        this.a = adaptiveRasterImage;
        this.a = 0;
    }

    protected void loadImage() {
        try {
            PCXImage pCXImage = this.a;
            PCXDecoder pCXDecoder = this;
            pCXDecoder.a.setSize(pCXImage.getWidth(), pCXImage.getHeight());
            pCXDecoder.a.setColorModel(pCXDecoder.a.getColorModel());
            pCXDecoder.a.setPixels();
            this.a.setChannel(0L);
            int n = 0;
            while (n < this.a.getHeight()) {
                int n2 = n * this.a.getWidth();
                this.a.setChannel(0, n, this.a.getImageData(), n2, this.a.getWidth());
                this.setProgress(n * 100 / this.a.getHeight());
                ++n;
            }
            this.a |= 4;
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.a |= 1;
            throw new JimiException("No more images");
        }
        catch (JimiException jimiException) {
            this.a |= 1;
            throw jimiException;
        }
    }
}

