/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.filters.ReplicatingScaleFilter;
import com.sun.jimi.core.util.GraphicsUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.net.URL;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class JimiCanvasLW
extends Component {
    public static final int EAST = 0;
    public static final int NORTH = 1;
    public static final int NORTHEAST = 2;
    public static final int NORTHWEST = 3;
    public static final int SOUTH = 4;
    public static final int SOUTHEAST = 5;
    public static final int SOUTHWEST = 6;
    public static final int WEST = 7;
    public static final int CENTER = 8;
    public static final int BEST_FIT = 0;
    public static final int CROP_AS_NECESSARY = 1;
    public static final int SCALE = 2;
    public static final int SCROLL = 3;
    public static final int FIT_TO_WIDTH = 4;
    public static final int AREA_AVERAGING = 0;
    public static final int REPLICATE = 1;
    protected transient Image myImage;
    protected URL myImageLocation;
    protected boolean willSizeToFit = false;
    protected int justificationPolicy = 8;
    protected int resizePolicy = 3;
    protected int scalingPolicy = 1;
    private transient Image a;
    private int a;
    private int b;
    private int c;
    private int d;
    private int e = -1;

    public JimiCanvasLW() {
    }

    public JimiCanvasLW(Image image) {
        this();
        this.myImage = image;
        this.myImageLocation = null;
    }

    public JimiCanvasLW(URL uRL) {
        this();
        this.myImage = null;
        this.myImageLocation = uRL;
    }

    protected void LoadImage() {
        if (this.myImageLocation == null) {
            return;
        }
        Image image = Jimi.getImage(this.myImageLocation);
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
            if (!mediaTracker.isErrorAny()) {
                this.setImage(image);
                return;
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private synchronized void a() {
        if (this.myImage == null) {
            return;
        }
        this.setSize(new Dimension(this.myImage.getWidth(this), this.myImage.getHeight(this)));
        Container container = this.getParent();
        if (container != null) {
            container.invalidate();
            container.layout();
        }
    }

    protected Image getCacheImage() {
        if (this.a == null) {
            this.a = this.a(this.myImage, this.size().width, this.size().height, this.resizePolicy, this.justificationPolicy);
        }
        return this.a;
    }

    public Image getImage() {
        return this.myImage;
    }

    public URL getImageLocation() {
        return this.myImageLocation;
    }

    public int getJustificationPolicy() {
        return this.justificationPolicy;
    }

    public Dimension getPreferredSize() {
        if (this.myImage != null && this.getWillSizeToFit()) {
            if (this.getResizePolicy() == 4) {
                Image image = this.getCacheImage();
                if (image != null) {
                    return new Dimension(image.getWidth(null), image.getHeight(null));
                }
            } else {
                return new Dimension(this.myImage.getWidth(null), this.myImage.getHeight(null));
            }
        }
        return super.getPreferredSize();
    }

    public int getResizePolicy() {
        return this.resizePolicy;
    }

    private Image a(Image object, int n, int n2, int n3, int n4) {
        int n5 = ((Image)object).getWidth(this);
        int n6 = ((Image)object).getHeight(this);
        if (n3 == 3) {
            return object;
        }
        if (n3 == 1) {
            n3 = 0;
            int n7 = 0;
            n = n5 - n;
            n2 = n6 - n2;
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n == 0 && n2 == 0) {
                return object;
            }
            int n8 = n / 2;
            int n9 = n2 / 2;
            switch (n4) {
                case 8: {
                    n3 = n8;
                    n7 = n9;
                    break;
                }
                case 3: {
                    n3 = 0;
                    n7 = 0;
                    break;
                }
                case 7: {
                    n3 = 0;
                    n7 = n9;
                    break;
                }
                case 6: {
                    n3 = 0;
                    n7 = n2;
                    break;
                }
                case 4: {
                    n3 = n8;
                    n7 = n2;
                    break;
                }
                case 5: {
                    n3 = n;
                    n7 = n2;
                    break;
                }
                case 0: {
                    n3 = n;
                    n7 = n9;
                    break;
                }
                case 2: {
                    n3 = n;
                    n7 = 0;
                    break;
                }
                case 1: {
                    n3 = n8;
                    n7 = 0;
                }
            }
            Object object2 = new CropImageFilter(n3, n7, n5, n6);
            object2 = new FilteredImageSource(((Image)object).getSource(), (ImageFilter)object2);
            object2 = Toolkit.getDefaultToolkit().createImage((ImageProducer)object2);
            ((Image)object).flush();
            GraphicsUtils.waitForImage(this, (Image)object2);
            return object2;
        }
        if (n3 == 2) {
            ImageFilter imageFilter = this.getScalingPolicy() == 0 ? new AreaAveragingScaleFilter(n, n2) : new ReplicatingScaleFilter(n, n2);
            FilteredImageSource filteredImageSource = new FilteredImageSource(((Image)object).getSource(), imageFilter);
            return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        }
        if (n3 == 0) {
            float f2 = (float)n / (float)n5;
            float f3 = (float)n2 / (float)n6;
            if (f2 < f3) {
                n = (int)((float)n5 * f2);
                n2 = (int)((float)n6 * f2);
            } else {
                n = (int)((float)n5 * f3);
                n2 = (int)((float)n6 * f3);
            }
            ImageFilter imageFilter = this.getScalingPolicy() == 0 ? new AreaAveragingScaleFilter(n, n2) : new ReplicatingScaleFilter(n, n2);
            object = new FilteredImageSource(((Image)object).getSource(), imageFilter);
            return Toolkit.getDefaultToolkit().createImage((ImageProducer)object);
        }
        if (n5 < this.e) {
            return object;
        }
        n3 = this.e == -1 ? n : this.e;
        float f4 = (float)n3 / (float)n5;
        n = (int)((float)n6 * f4);
        if (this.a != null && this.a.getWidth(null) == n3 && this.a.getHeight(null) == n) {
            return this.a;
        }
        ImageFilter imageFilter = this.getScalingPolicy() == 0 ? new AreaAveragingScaleFilter(n3, n) : new ReplicatingScaleFilter(n3, n);
        FilteredImageSource filteredImageSource = new FilteredImageSource(((Image)object).getSource(), imageFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public int getScalingPolicy() {
        return this.scalingPolicy;
    }

    public boolean getWillSizeToFit() {
        return this.willSizeToFit;
    }

    public synchronized void paint(Graphics graphics) {
        if (this.myImage == null) {
            graphics.setColor(this.getForeground());
            graphics.fillRect(0, 0, this.size().width, this.size().height);
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.size().width;
        int n4 = this.size().height;
        if (this.a == null || n3 != this.a || n4 != this.b || this.resizePolicy != this.c || this.justificationPolicy != this.d) {
            this.a = this.a(this.myImage, n3, n4, this.resizePolicy, this.justificationPolicy);
            this.a = n3;
            this.b = n4;
            this.c = this.resizePolicy;
            this.d = this.justificationPolicy;
        }
        int n5 = this.a.getWidth(this);
        int n6 = this.a.getHeight(this);
        switch (this.justificationPolicy) {
            case 8: {
                n = (n3 - n5) / 2;
                n2 = (n4 - n6) / 2;
                break;
            }
            case 3: {
                n = 0;
                n2 = 0;
                break;
            }
            case 2: {
                n = n3 - n5;
                n2 = 0;
                break;
            }
            case 1: {
                n = (n3 - n5) / 2;
                n2 = 0;
                break;
            }
            case 4: {
                n = (n3 - n5) / 2;
                n2 = n4 - n6;
                break;
            }
            case 6: {
                n = 0;
                n2 = n4 - n6;
                break;
            }
            case 5: {
                n = n3 - n5;
                n2 = n4 - n6;
                break;
            }
            case 0: {
                n = n3 - n5;
                n2 = (n4 - n6) / 2;
                break;
            }
            case 7: {
                n = 0;
                n2 = (n4 - n6) / 2;
            }
        }
        graphics.setColor(this.getForeground());
        graphics.fillRect(0, 0, n3, n4);
        graphics.drawImage(this.a, n, n2, n5, n6, this);
    }

    public void setFitWidth(int n) {
        this.e = n;
    }

    public synchronized void setImage(Image image) {
        if (this.a != null) {
            this.a.flush();
            this.a = null;
        }
        if (this.myImage != null) {
            this.myImage.flush();
        }
        this.myImage = image;
        if (this.willSizeToFit || this.getResizePolicy() == 4) {
            this.a();
        }
        this.repaint();
    }

    public synchronized void setImageLocation(URL uRL) {
        this.myImageLocation = uRL;
        this.LoadImage();
    }

    public synchronized void setJustificationPolicy(int n) {
        this.justificationPolicy = n;
    }

    public synchronized void setResizePolicy(int n) {
        this.resizePolicy = n;
    }

    public synchronized void setScalingPolicy(int n) {
        this.scalingPolicy = n;
    }

    public synchronized void setWillSizeToFit(boolean bl) {
        this.willSizeToFit = bl;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

