/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.component.AspectScaler;
import com.sun.jimi.core.component.JimiCanvas;
import com.sun.jimi.core.util.GraphicsUtils;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;

public class FitToWidthPanel
extends Canvas {
    protected ImageProducer producer;
    protected Image cache;
    protected int position;
    protected boolean needsRedraw;
    protected JimiCanvas canvas;

    public FitToWidthPanel(JimiCanvas jimiCanvas) {
        this.canvas = jimiCanvas;
    }

    public synchronized void paint(Graphics graphics) {
        int n;
        int n2;
        if (this.cache == null || this.needsRedraw) {
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
            this.needsRedraw = false;
        }
        if (this.producer == null) {
            return;
        }
        if (this.cache == null || this.getSize().width != this.cache.getWidth(null)) {
            this.updateCache();
        }
        if ((n2 = Math.max(0, this.getSize().height - this.cache.getHeight(null))) > 0) {
            this.position = 0;
        }
        if (n2 <= 0) {
            n = -this.position;
        } else {
            n = this.canvas.getJustificationPolicy();
            if ((n & 2) != 0) {
                n = 0;
                graphics.fillRect(0, this.getSize().height - n2, this.getSize().width, n2);
            } else if ((n & 4) != 0) {
                n = n2;
                graphics.fillRect(0, 0, this.getSize().width, n2);
            } else {
                n = n2 / 2;
                graphics.fillRect(0, 0, this.getSize().width, n);
                graphics.fillRect(0, this.getSize().height - n, this.getSize().width, n);
            }
        }
        graphics.drawImage(this.cache, 0, n, this);
    }

    public synchronized void redraw() {
        this.needsRedraw = true;
        this.repaint();
    }

    public void setImageProducer(ImageProducer imageProducer) {
        this.producer = imageProducer;
        this.cache = null;
        this.position = 0;
        this.redraw();
    }

    public void setPosition(int n) {
        this.position = n;
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    protected void updateCache() {
        Object object = new AspectScaler(this.getSize().width, Integer.MAX_VALUE);
        object = new FilteredImageSource(this.producer, (ImageFilter)object);
        this.cache = this.createImage((ImageProducer)object);
        GraphicsUtils.waitForImage(this.cache);
        this.position = 0;
    }
}

