/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.GraphicsUtils;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ScrollPane;
import java.awt.image.ImageProducer;

public class CroppedPreviewCanvas
extends Canvas {
    protected int cropWidth;
    protected int cropHeight;
    protected JimiRasterImage rasterImage;
    protected Image previewImage;
    protected Image completeImage;

    public CroppedPreviewCanvas() {
    }

    public CroppedPreviewCanvas(int n, int n2) {
        this.setCropDimensions(n, n2);
    }

    public CroppedPreviewCanvas(int n, int n2, JimiRasterImage jimiRasterImage) {
        this(n, n2);
        this.setImage(jimiRasterImage);
    }

    protected void createCompleteImage() {
        this.completeImage = this.createImage(this.rasterImage.getImageProducer());
        GraphicsUtils.waitForImage(this, this.completeImage);
    }

    protected void createPreviewImage() {
        int n = Math.min(this.cropWidth, this.rasterImage.getWidth());
        int n2 = Math.min(this.cropHeight, this.rasterImage.getHeight());
        if (n != this.rasterImage.getWidth() || n2 != this.rasterImage.getHeight()) {
            ImageProducer imageProducer = this.rasterImage.getCroppedImageProducer(0, 0, n, n2);
            this.previewImage = this.createImage(imageProducer);
            GraphicsUtils.waitForImage(this, this.previewImage);
        }
        if (n == this.rasterImage.getWidth() && n2 == this.rasterImage.getHeight()) {
            this.previewImage = this.createImage(this.rasterImage.getImageProducer());
            GraphicsUtils.waitForImage(this, this.previewImage);
            this.completeImage = this.previewImage;
        }
    }

    public Dimension getPreferredSize() {
        if (this.rasterImage != null) {
            return new Dimension(this.rasterImage.getWidth(), this.rasterImage.getHeight());
        }
        return new Dimension(610, 410);
    }

    public synchronized void paint(Graphics graphics) {
        if (this.rasterImage == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        if (this.rasterImage.getWidth() < this.cropWidth) {
            n = (this.cropWidth - this.rasterImage.getWidth()) / 2;
        }
        if (this.rasterImage.getHeight() < this.cropHeight) {
            n2 = (this.cropHeight - this.rasterImage.getHeight()) / 2;
        }
        if (this.rasterImage == null || this.rasterImage.isError()) {
            return;
        }
        this.getSize();
        if (this.completeImage != null) {
            if (this.getParent() instanceof ScrollPane) {
                this.getParent().enable();
            }
            graphics.drawImage(this.completeImage, n, n2, null);
            return;
        }
        if (this.previewImage != null) {
            if (this.getParent() instanceof ScrollPane) {
                this.getParent().disable();
            }
            graphics.drawImage(this.previewImage, n, n2, null);
            this.getToolkit().sync();
            if (this.completeImage == null) {
                this.createCompleteImage();
            }
            this.paint(graphics);
            return;
        }
        this.createPreviewImage();
        this.paint(graphics);
    }

    public void setCropDimensions(int n, int n2) {
        this.cropWidth = n;
        this.cropHeight = n2;
        this.repaint();
    }

    public synchronized void setImage(JimiRasterImage jimiRasterImage) {
        jimiRasterImage.waitInfoAvailable();
        this.rasterImage = jimiRasterImage;
        if (this.previewImage != null) {
            this.previewImage.flush();
        }
        if (this.completeImage != null) {
            this.completeImage.flush();
        }
        this.previewImage = null;
        this.completeImage = null;
        ((Component)this).update(this.getGraphics());
        this.getParent().invalidate();
    }
}

