/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.component.AbstractRenderer;
import com.sun.jimi.core.component.JimiCanvas;
import com.sun.jimi.core.util.GraphicsUtils;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;

public class CropRenderer
extends AbstractRenderer {
    protected Rectangle cachedArea = new Rectangle();
    protected Image cacheImage;

    public CropRenderer(JimiCanvas jimiCanvas) {
        this.canvas = jimiCanvas;
    }

    public void paint(Graphics graphics) {
        this.blankBackground(graphics);
        Object object = this.getRasterImage();
        if (object == null) {
            return;
        }
        object.waitInfoAvailable();
        int n = object.getWidth();
        int n2 = object.getHeight();
        int n3 = this.canvas.size().width;
        int n4 = this.canvas.size().height;
        int n5 = 0;
        int n6 = 0;
        int n7 = n - n3;
        int n8 = n2 - n4;
        n = Math.min(n, n3);
        n2 = Math.min(n2, n4);
        if (n7 < 0) {
            n7 = 0;
        }
        if (n8 < 0) {
            n8 = 0;
        }
        n3 = n7 / 2;
        n4 = n8 / 2;
        switch (this.canvas.getJustificationPolicy()) {
            case 0: {
                n5 = n3;
                n6 = n4;
                break;
            }
            case 18: {
                n5 = 0;
                n6 = 0;
                break;
            }
            case 16: {
                n5 = 0;
                n6 = n4;
                break;
            }
            case 20: {
                n5 = 0;
                n6 = n8;
                break;
            }
            case 4: {
                n5 = n3;
                n6 = n8;
                break;
            }
            case 12: {
                n5 = n7;
                n6 = n8;
                break;
            }
            case 8: {
                n5 = n7;
                n6 = n4;
                break;
            }
            case 10: {
                n5 = n7;
                n6 = 0;
                break;
            }
            case 2: {
                n5 = n3;
                n6 = 0;
            }
        }
        if (this.cacheImage == null || this.cachedArea.x != n5 || this.cachedArea.y != n6 || this.cachedArea.width != n || this.cachedArea.height != n2) {
            object = object.getCroppedImageProducer(n5, n6, n, n2);
            this.cacheImage = Toolkit.getDefaultToolkit().createImage((ImageProducer)object);
            GraphicsUtils.waitForImage(this.cacheImage);
            this.cachedArea.x = n5;
            this.cachedArea.y = n6;
            this.cachedArea.width = n;
            this.cachedArea.height = n2;
        }
        this.image = this.cacheImage;
        super.paint(graphics);
    }

    public void render() {
        this.repaint();
    }
}

