/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.component.AbstractRenderer$ResizeWatcher;
import com.sun.jimi.core.component.JimiCanvas;
import com.sun.jimi.core.component.JimiImageRenderer;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.GraphicsUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;

public abstract class AbstractRenderer
extends Panel
implements JimiImageRenderer {
    public JimiRasterImage raster;
    public Image image;
    public ImageProducer producer;
    public JimiCanvas canvas;

    public AbstractRenderer() {
        this.addComponentListener(new AbstractRenderer$ResizeWatcher(this));
    }

    public final void blankBackground(Graphics graphics) {
        graphics.setColor(this.getForeground());
        graphics.fillRect(0, 0, this.canvas.size().width, this.canvas.size().height);
    }

    public Component getContentPane() {
        if (this.image != null) {
            this.render();
        }
        return this;
    }

    public Image getImage() {
        if (this.image != null) {
            return this.image;
        }
        if (this.producer != null) {
            Image image = Toolkit.getDefaultToolkit().createImage(this.producer);
            GraphicsUtils.waitForImage(image);
            this.image = image;
            return image;
        }
        return null;
    }

    public Dimension getPreferredSize() {
        if (this.image != null) {
            return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        }
        return super.getPreferredSize();
    }

    public JimiRasterImage getRasterImage() {
        if (this.raster != null) {
            return this.raster;
        }
        if (this.producer != null) {
            try {
                return Jimi.createRasterImage(this.producer);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public synchronized void paint(Graphics graphics) {
        this.blankBackground(graphics);
        if (this.producer == null) {
            return;
        }
        Image image = this.getImage();
        int n = this.size().width;
        int n2 = this.size().height;
        int n3 = 0;
        int n4 = 0;
        int n5 = image.getWidth(this);
        int n6 = image.getHeight(this);
        switch (this.canvas.getJustificationPolicy()) {
            case 0: {
                n4 = (n - n5) / 2;
                n3 = (n2 - n6) / 2;
                break;
            }
            case 18: {
                n4 = 0;
                n3 = 0;
                break;
            }
            case 10: {
                n4 = n - n5;
                n3 = 0;
                break;
            }
            case 2: {
                n4 = (n - n5) / 2;
                n3 = 0;
                break;
            }
            case 4: {
                n4 = (n - n5) / 2;
                n3 = n2 - n6;
                break;
            }
            case 20: {
                n4 = 0;
                n3 = n2 - n6;
                break;
            }
            case 12: {
                n4 = n - n5;
                n3 = n2 - n6;
                break;
            }
            case 8: {
                n4 = n - n5;
                n3 = (n2 - n6) / 2;
                break;
            }
            case 16: {
                n4 = 0;
                n3 = (n2 - n6) / 2;
            }
        }
        graphics.drawImage(image, n4, n3, this);
    }

    public void render() {
        this.repaint();
    }

    public void setImage(Image image) {
        if (image == null) {
            this.image = null;
            this.producer = null;
            this.raster = null;
        } else {
            this.image = image;
            this.producer = image.getSource();
        }
        this.render();
    }

    public void setImageProducer(ImageProducer imageProducer) {
        if (imageProducer == null) {
            this.setImage(null);
            return;
        }
        this.image = null;
        this.producer = imageProducer;
        this.raster = null;
        this.render();
    }

    public void setRasterImage(JimiRasterImage jimiRasterImage) {
        if (jimiRasterImage == null) {
            this.setImage(null);
            return;
        }
        this.raster = jimiRasterImage;
        this.producer = jimiRasterImage.getImageProducer();
        this.image = null;
        this.render();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

