/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.compat;

import com.sun.jimi.core.JimiEncoder;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.JimiImageEnumeration;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.JimiImageColorReducer;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.ProgressListener;
import com.sun.jimi.core.util.ProgressMonitorSupport;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.OutputStream;

public abstract class JimiEncoderBase
extends ProgressMonitorSupport
implements JimiEncoder {
    public static final int MULTIIMAGE = 1;
    public static final int ERROR = 1;
    public static final int DONE = 2;
    public static final int NEXTIMAGE = 4;
    protected AdaptiveRasterImage currentImage;
    protected JimiImageFactory factory;
    protected static final int MAX_COLORS_RGB = -1;

    public AdaptiveRasterImage createAdaptiveRasterImage() {
        return new AdaptiveRasterImage(this.factory);
    }

    public AdaptiveRasterImage createAdaptiveRasterImage(int n, int n2, ColorModel colorModel) {
        AdaptiveRasterImage adaptiveRasterImage = new AdaptiveRasterImage(this.factory);
        adaptiveRasterImage.setSize(n, n2);
        adaptiveRasterImage.setColorModel(colorModel);
        return adaptiveRasterImage;
    }

    public abstract boolean driveEncoder();

    public void encodeImage(JimiImage object, OutputStream outputStream) {
        object.waitFinished();
        if (this.progressListener != null) {
            this.progressListener.setStarted();
        }
        try {
            if (!(object instanceof JimiRasterImage)) {
                throw new JimiException("Only encodes RasterImages.");
            }
            object = JimiUtil.asJimiRasterImage((JimiImage)object);
            if (this.getMaxColors() != -1 && !(object.getColorModel() instanceof IndexColorModel)) {
                object = new JimiImageColorReducer(this.getMaxColors()).colorReduceFS((JimiRasterImage)object);
            }
            this.currentImage = object = new AdaptiveRasterImage((JimiRasterImage)object);
            this.setNumberOfImages(1);
            this.initSpecificEncoder(outputStream, (AdaptiveRasterImage)object);
            this.setJimiImage((AdaptiveRasterImage)object);
            while (this.driveEncoder()) {
            }
            if (this.progressListener != null) {
                this.progressListener.setFinished();
                return;
            }
        }
        catch (JimiException jimiException) {
            if (this.progressListener != null) {
                this.progressListener.setAbort();
            }
            throw jimiException;
        }
    }

    public void encodeImage(JimiImage jimiImage, OutputStream outputStream, ProgressListener progressListener) {
        this.progressListener = progressListener;
        this.encodeImage(jimiImage, outputStream);
    }

    public void encodeImages(JimiImageEnumeration jimiImageEnumeration, OutputStream outputStream) {
        this.setNumberOfImages(jimiImageEnumeration.countImages());
        if (this.progressListener != null) {
            this.progressListener.setStarted();
        }
        try {
            int n;
            AdaptiveRasterImage adaptiveRasterImage;
            JimiRasterImage jimiRasterImage = JimiUtil.asJimiRasterImage(jimiImageEnumeration.getNextImage());
            if (this.getMaxColors() != -1 && !(jimiRasterImage.getColorModel() instanceof IndexColorModel)) {
                jimiRasterImage = new JimiImageColorReducer(this.getMaxColors()).colorReduceFS(jimiRasterImage);
            }
            this.currentImage = adaptiveRasterImage = new AdaptiveRasterImage(jimiRasterImage);
            this.factory = jimiRasterImage.getFactory();
            this.initSpecificEncoder(outputStream, adaptiveRasterImage);
            this.setNumberOfImages(jimiImageEnumeration.countImages());
            this.setJimiImage(adaptiveRasterImage);
            do {
                this.driveEncoder();
                n = this.getState();
                if (n != 4) continue;
                adaptiveRasterImage = new AdaptiveRasterImage(JimiUtil.asJimiRasterImage(jimiImageEnumeration.getNextImage()));
                this.setJimiImage(adaptiveRasterImage);
            } while ((n & 1) == 0 && (n & 2) == 0);
            if (n == 1) {
                throw new JimiException("Error during encoding.");
            }
            if (this.progressListener != null) {
                this.progressListener.setFinished();
                return;
            }
        }
        catch (JimiException jimiException) {
            if (this.progressListener != null) {
                this.progressListener.setAbort();
            }
            throw jimiException;
        }
    }

    public void encodeImages(JimiImageEnumeration jimiImageEnumeration, OutputStream outputStream, ProgressListener progressListener) {
    }

    public void freeEncoder() {
    }

    protected int getCapabilties() {
        return 0;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.currentImage;
    }

    protected int getMaxColors() {
        return -1;
    }

    protected int getState() {
        return 0;
    }

    protected abstract void initSpecificEncoder(OutputStream var1, AdaptiveRasterImage var2);

    protected void setJimiImage(AdaptiveRasterImage adaptiveRasterImage) {
    }

    public void setNumberOfImages(int n) {
    }

    public void setProgress(int n) {
        if (this.progressListener != null) {
            this.progressListener.setProgressLevel(n);
        }
    }
}

