/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.compat;

import com.sun.jimi.core.ImageSeriesDecodingController;
import com.sun.jimi.core.JimiDecoder;
import com.sun.jimi.core.JimiDecodingController;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.JimiImageHandle;
import com.sun.jimi.core.MemoryJimiImageFactory;
import com.sun.jimi.core.MutableJimiImage;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.a;
import com.sun.jimi.core.util.ErrorJimiImage;
import com.sun.jimi.core.util.JimiImageFactoryProxy;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.ProgressMonitorSupport;
import java.awt.image.ColorModel;
import java.io.InputStream;
import java.util.Vector;

public abstract class JimiDecoderBase
extends ProgressMonitorSupport
implements JimiDecoder,
Runnable {
    public static final int ERROR = 1;
    public static final int INFOAVAIL = 2;
    public static final int IMAGEAVAIL = 4;
    public static final int MOREIMAGES = 8;
    public static final int MULTIIMAGE = 1;
    public static final int UNKNOWNCOUNT = -1;
    protected AdaptiveRasterImage jimiImage;
    protected JimiImageFactory factory;
    protected InputStream input;
    protected JimiDecodingController currentController;
    protected JimiImageHandle currentHandle;
    protected boolean error;
    protected volatile boolean busyDecoding;
    protected Object decodingLock = new Object();
    protected Vector cleanupCommands = new Vector();
    protected boolean finishedDecoding;

    public void addCleanupCommand(Runnable runnable) {
        this.cleanupCommands.addElement(runnable);
    }

    public AdaptiveRasterImage createAdaptiveRasterImage() {
        while (this.factory instanceof JimiImageFactoryProxy) {
            this.factory = ((JimiImageFactoryProxy)this.factory).getProxiedFactory();
        }
        if (this.factory.getClass().getName().equals("com.sun.jimi.core.OneshotJimiImageFactory")) {
            return new AdaptiveRasterImage(new MemoryJimiImageFactory());
        }
        return new AdaptiveRasterImage(this.factory);
    }

    public AdaptiveRasterImage createAdaptiveRasterImage(int n, int n2, ColorModel colorModel) {
        if (this.factory instanceof JimiImageFactoryProxy) {
            this.factory = ((JimiImageFactoryProxy)this.factory).getProxiedFactory();
        }
        AdaptiveRasterImage adaptiveRasterImage = this.factory.getClass().getName().equals("com.sun.jimi.core.OneshotJimiImageFactory") ? new AdaptiveRasterImage(new MemoryJimiImageFactory()) : new AdaptiveRasterImage(this.factory);
        adaptiveRasterImage.setSize(n, n2);
        adaptiveRasterImage.setColorModel(colorModel);
        return adaptiveRasterImage;
    }

    protected JimiDecodingController decodeNextImage() {
        if (this.currentController != null) {
            this.currentController.requestDecoding();
        }
        JimiDecoderBase jimiDecoderBase = this;
        synchronized (jimiDecoderBase) {
            this.waitReady();
            this.busyDecoding = true;
        }
        this.currentHandle = new JimiImageHandle();
        this.currentController = new JimiDecodingController(this.currentHandle);
        new Thread(this).start();
        return this.currentController;
    }

    protected abstract boolean driveDecoder();

    protected synchronized void finishedDecode() {
        this.busyDecoding = false;
        this.notifyAll();
        if (this.finishedDecoding || (this.getState() & 8) == 0) {
            JimiUtil.runCommands(this.cleanupCommands);
        }
    }

    protected abstract void freeDecoder();

    protected int getCapabilities() {
        return 0;
    }

    public int getNumberOfImages() {
        return 1;
    }

    protected abstract int getState();

    protected abstract void initDecoder(InputStream var1, AdaptiveRasterImage var2);

    public ImageSeriesDecodingController initDecoding(JimiImageFactory jimiImageFactory, InputStream inputStream) {
        block2: {
            this.jimiImage = new AdaptiveRasterImage(jimiImageFactory, this);
            this.jimiImage.setDecoder(this);
            this.factory = jimiImageFactory;
            this.input = inputStream;
            try {
                this.initDecoder(inputStream, this.jimiImage);
            }
            catch (JimiException jimiException) {
                this.error = true;
                if (this.currentHandle == null) break block2;
                this.currentHandle.setJimiImage(new ErrorJimiImage());
            }
        }
        return new a(this);
    }

    protected void jimiImageCreated(MutableJimiImage mutableJimiImage) {
        this.currentHandle.setJimiImage(mutableJimiImage);
        mutableJimiImage.setDecodingController(this.currentController);
        this.currentController.waitDecodingRequest();
        if (this.progressListener != null) {
            this.progressListener.setStarted();
        }
    }

    public boolean mustWaitForOptions() {
        return false;
    }

    public void run() {
        if (this.finishedDecoding) {
            this.error = true;
            this.currentHandle.setJimiImage(new ErrorJimiImage());
            return;
        }
        Object object = this.decodingLock;
        synchronized (object) {
            block10: {
                if (this.error) break block10;
                do {
                    try {
                        while (this.driveDecoder()) {
                        }
                    }
                    catch (Exception exception) {
                        this.error = true;
                        this.currentHandle.setJimiImage(new ErrorJimiImage());
                    }
                    if ((this.getState() & 1) != 0 || !this.currentHandle.isImageSet()) {
                        this.error = true;
                        this.currentHandle.setJimiImage(new ErrorJimiImage());
                        continue;
                    }
                    if (this.progressListener == null) continue;
                    this.progressListener.setFinished();
                } while (!this.error && (this.getState() & 4) == 0);
                if ((this.getState() & 1) != 0 && this.progressListener != null) {
                    this.progressListener.setAbort();
                }
                this.finishedDecode();
                return;
            }
            return;
        }
    }

    public void setFinished() {
        this.finishedDecoding = true;
    }

    public void skipImage() {
    }

    public boolean usesChanneledData() {
        return false;
    }

    protected synchronized void waitReady() {
        while (this.busyDecoding) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

