/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.MemoryJimiImageFactory;
import com.sun.jimi.core.VMMControl;
import com.sun.jimi.core.raster.BitRasterImage;
import com.sun.jimi.core.raster.ByteRasterImage;
import com.sun.jimi.core.raster.ChanneledIntRasterImage;
import com.sun.jimi.core.raster.IntRasterImage;
import com.sun.jimi.core.raster.VMemByteRasterImage;
import com.sun.jimi.core.raster.VMemChanneledIntRasterImage;
import com.sun.jimi.core.raster.VMemIntRasterImage;
import com.sun.jimi.util.FileRandomAccessStorage;
import com.sun.jimi.util.RandomAccessStorage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.File;

public class VMemJimiImageFactory
implements JimiImageFactory {
    protected static long id;
    protected JimiImageFactory memoryFactory = new MemoryJimiImageFactory();

    public BitRasterImage createBitRasterImage(int n, int n2, ColorModel colorModel) {
        try {
            if (n * n2 / 8 < VMMControl.threshold) {
                return this.memoryFactory.createBitRasterImage(n, n2, colorModel);
            }
            int n3 = colorModel.getRGB(0);
            int n4 = colorModel.getRGB(1);
            byte[] byArray = new byte[]{n3 >> 24, n4 >> 24};
            byte[] byArray2 = new byte[]{(byte)(n3 >> 16), (byte)(n4 >> 16)};
            byte[] byArray3 = new byte[]{(byte)(n3 >> 8), (byte)(n4 >> 8)};
            Object object = new byte[]{(byte)n3, (byte)n4};
            object = new IndexColorModel(8, 2, byArray2, byArray3, (byte[])object, byArray);
            return (BitRasterImage)this.createByteRasterImage(n, n2, (ColorModel)object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ByteRasterImage createByteRasterImage(int n, int n2, ColorModel colorModel) {
        try {
            if (n * n2 < VMMControl.threshold) {
                return this.memoryFactory.createByteRasterImage(n, n2, colorModel);
            }
            return new VMemByteRasterImage(VMemJimiImageFactory.createNextStorage(VMMControl.getDirectory()), n, n2, colorModel);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ChanneledIntRasterImage createChanneledIntRasterImage(int n, int n2, ColorModel colorModel) {
        try {
            if (n * n2 << 2 < VMMControl.threshold) {
                return this.memoryFactory.createChanneledIntRasterImage(n, n2, colorModel);
            }
            return new VMemChanneledIntRasterImage(VMemJimiImageFactory.createNextStorage(VMMControl.getDirectory()), n, n2, colorModel);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IntRasterImage createIntRasterImage(int n, int n2, ColorModel colorModel) {
        try {
            if (n * n2 << 2 < VMMControl.threshold) {
                return this.memoryFactory.createIntRasterImage(n, n2, colorModel);
            }
            return new VMemIntRasterImage(VMemJimiImageFactory.createNextStorage(VMMControl.getDirectory()), n, n2, colorModel);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static synchronized RandomAccessStorage createNextStorage(File file) {
        Object object;
        do {
            object = new StringBuffer(String.valueOf(String.valueOf(file))).append("/").append("jimidat.").append(++id).toString();
        } while (((File)(object = new File((String)object))).exists() && !((File)object).delete());
        return new FileRandomAccessStorage((File)object);
    }
}

