/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.InvalidOptionException;
import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiControl;
import com.sun.jimi.core.JimiEncoder;
import com.sun.jimi.core.JimiEncoderFactory;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.JimiImageEnumeration;
import com.sun.jimi.core.MutableJimiImage;
import com.sun.jimi.core.g;
import com.sun.jimi.core.options.BasicFormatOptionSet;
import com.sun.jimi.core.options.FormatOption;
import com.sun.jimi.core.options.FormatOptionSet;
import com.sun.jimi.core.options.OptionException;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.ProgressListener;
import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

public class JimiWriter {
    protected JimiEncoder encoder;
    protected JimiImage sourceImage;
    protected JimiImageEnumeration sourceImageEnumeration;
    protected FormatOptionSet options = new BasicFormatOptionSet();
    protected FormatOptionSet overrideOptions;
    protected ProgressListener listener;

    protected JimiWriter() {
    }

    protected JimiWriter(OutputStream object, String string) {
        object = JimiControl.getEncoderByType(string);
        if (object == null) {
            throw new JimiException(new StringBuffer("Cannot find encoder for type: ").append(string).toString());
        }
        this.initJimiWriter((JimiEncoderFactory)object);
    }

    protected JimiWriter(String string) {
        JimiEncoderFactory jimiEncoderFactory = JimiControl.getEncoderByFileExtension(string);
        if (jimiEncoderFactory == null) {
            throw new JimiException(new StringBuffer("Cannot find encoder for ").append(string).toString());
        }
        this.initJimiWriter(jimiEncoderFactory);
    }

    protected JimiWriter(String object, String string) {
        object = JimiControl.getEncoderByType(string);
        if (object == null) {
            throw new JimiException(new StringBuffer("Cannot find encoder for type: ").append(string).toString());
        }
        this.initJimiWriter((JimiEncoderFactory)object);
    }

    public void clearProperties() {
        this.options = new BasicFormatOptionSet();
    }

    public Object getPossibleValuesForProperty(String string) {
        try {
            return this.options.getOption(string).getPossibleValues();
        }
        catch (OptionException optionException) {
            throw new InvalidOptionException(optionException.getMessage());
        }
    }

    public Object getProperty(String string) {
        try {
            return this.options.getOption(string).getValue();
        }
        catch (OptionException optionException) {
            return null;
        }
    }

    public String getPropertyDescription(String string) {
        try {
            return this.options.getOption(string).getDescription();
        }
        catch (OptionException optionException) {
            throw new InvalidOptionException(optionException.getMessage());
        }
    }

    public Enumeration getPropertyNames() {
        FormatOption[] formatOptionArray = this.options.getOptions();
        return new g(formatOptionArray);
    }

    protected void initJimiWriter(JimiEncoderFactory jimiEncoderFactory) {
        this.encoder = jimiEncoderFactory.createEncoder();
        if (this.listener != null) {
            this.encoder.setProgressListener(this.listener);
        }
    }

    public void putImage(OutputStream outputStream) {
        if (this.sourceImage != null) {
            this.sourceImage.setOptions(this.options);
            this.encoder.encodeImages(new JimiImageEnumeration(this.sourceImage), outputStream);
            return;
        }
        if (this.sourceImageEnumeration != null) {
            this.sourceImageEnumeration.setOptions(this.options);
            this.encoder.encodeImages(this.sourceImageEnumeration, outputStream);
            return;
        }
        throw new JimiException("No source image set.");
    }

    public void putImage(String object) {
        try {
            object = new FileOutputStream((String)object);
            object = new BufferedOutputStream((OutputStream)object);
            this.putImage((OutputStream)object);
            ((OutputStream)object).close();
            return;
        }
        catch (IOException iOException) {
            throw new JimiException();
        }
    }

    protected void setMimeType(String string) {
        JimiEncoderFactory jimiEncoderFactory = JimiControl.getEncoderByType(string);
        if (jimiEncoderFactory == null) {
            throw new JimiException(new StringBuffer("Cannot find encoder for type: ").append(string).toString());
        }
        this.initJimiWriter(jimiEncoderFactory);
    }

    public void setOptions(FormatOptionSet formatOptionSet) {
        this.options = formatOptionSet;
        this.overrideOptions = formatOptionSet;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.listener = progressListener;
        if (this.encoder != null) {
            this.encoder.setProgressListener(progressListener);
        }
    }

    public void setProperty(String string, Object object) {
        try {
            this.options.getOption(string).setValue(object);
            return;
        }
        catch (OptionException optionException) {
            throw new InvalidOptionException(optionException.getMessage());
        }
    }

    public void setSource(JimiImage jimiImage) {
        this.sourceImage = JimiUtil.asJimiRasterImage(jimiImage);
        if (this.overrideOptions != null) {
            ((MutableJimiImage)this.sourceImage).setOptions(this.overrideOptions);
        }
    }

    public void setSource(Image image) {
        this.setSource(image.getSource());
    }

    public void setSource(ImageProducer imageProducer) {
        try {
            this.sourceImage = Jimi.createRasterImage(imageProducer);
            return;
        }
        catch (JimiException jimiException) {
            return;
        }
    }

    public void setSource(JimiImage[] jimiImageArray) {
        this.sourceImageEnumeration = new JimiImageEnumeration(jimiImageArray);
    }

    public void setSource(Image[] imageArray) {
        this.sourceImageEnumeration = new JimiImageEnumeration(imageArray);
    }

    public void setSource(ImageProducer[] imageProducerArray) {
        this.sourceImageEnumeration = new JimiImageEnumeration(imageProducerArray);
    }

    public void setSource(Object[] objectArray) {
        if (objectArray instanceof JimiImage[]) {
            this.setSource((JimiImage[])objectArray);
            return;
        }
        if (objectArray instanceof ImageProducer[]) {
            this.setSource((ImageProducer[])objectArray);
            return;
        }
        if (objectArray instanceof Image[]) {
            this.setSource((Image[])objectArray);
            return;
        }
        throw new JimiException("Invalid source.");
    }
}

