/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.filters.AspectAdjustReplicateScaleFilter;
import com.sun.jimi.core.filters.AspectReplicateScaleFilter;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.JimiUtil;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.io.InputStream;
import java.net.URL;

public class JimiUtils {
    public static ImageProducer aspectAdjust(JimiRasterImage jimiRasterImage) {
        if (jimiRasterImage == null) {
            return JimiUtil.getErrorImageProducer();
        }
        jimiRasterImage.waitInfoAvailable();
        if (jimiRasterImage.getProperties() == null) {
            return jimiRasterImage.getImageProducer();
        }
        if (jimiRasterImage.getProperties().get("fixedaspect") != null) {
            return jimiRasterImage.getImageProducer();
        }
        Object object = jimiRasterImage.getProperties().get("xres");
        Object v = jimiRasterImage.getProperties().get("yres");
        if (object != null && v != null && object instanceof Number && v instanceof Number) {
            double d2;
            double d3 = ((Number)object).doubleValue();
            if (d3 == (d2 = ((Number)v).doubleValue())) {
                return jimiRasterImage.getImageProducer();
            }
            object = new AspectAdjustReplicateScaleFilter(d3, d2);
            return new FilteredImageSource(jimiRasterImage.getImageProducer(), (ImageFilter)object);
        }
        return jimiRasterImage.getImageProducer();
    }

    public static Image getThumbnail(InputStream inputStream, int n, int n2, int n3) {
        return Toolkit.getDefaultToolkit().createImage(JimiUtils.getThumbnailProducer(inputStream, n, n2, n3));
    }

    public static Image getThumbnail(InputStream inputStream, int n, int n2, int n3, String string) {
        return Toolkit.getDefaultToolkit().createImage(JimiUtils.getThumbnailProducer(inputStream, n, n2, n3, string));
    }

    public static Image getThumbnail(String string, int n, int n2, int n3) {
        return Toolkit.getDefaultToolkit().createImage(JimiUtils.getThumbnailProducer(string, n, n2, n3));
    }

    public static Image getThumbnail(URL uRL, int n, int n2, int n3) {
        return Toolkit.getDefaultToolkit().createImage(JimiUtils.getThumbnailProducer(uRL, n, n2, n3));
    }

    public static ImageProducer getThumbnailProducer(InputStream object, int n, int n2, int n3) {
        object = Jimi.getImageProducer((InputStream)object, n3);
        AspectReplicateScaleFilter aspectReplicateScaleFilter = new AspectReplicateScaleFilter(n, n2);
        return new FilteredImageSource((ImageProducer)object, aspectReplicateScaleFilter);
    }

    public static ImageProducer getThumbnailProducer(InputStream object, int n, int n2, int n3, String string) {
        object = Jimi.getImageProducer((InputStream)object, string, n3);
        AspectReplicateScaleFilter aspectReplicateScaleFilter = new AspectReplicateScaleFilter(n, n2);
        return new FilteredImageSource((ImageProducer)object, aspectReplicateScaleFilter);
    }

    public static ImageProducer getThumbnailProducer(String object, int n, int n2, int n3) {
        object = Jimi.getImageProducer((String)object, n3);
        AspectReplicateScaleFilter aspectReplicateScaleFilter = new AspectReplicateScaleFilter(n, n2);
        return new FilteredImageSource((ImageProducer)object, aspectReplicateScaleFilter);
    }

    public static ImageProducer getThumbnailProducer(URL object, int n, int n2, int n3) {
        object = Jimi.getImageProducer((URL)object, n3);
        AspectReplicateScaleFilter aspectReplicateScaleFilter = new AspectReplicateScaleFilter(n, n2);
        return new FilteredImageSource((ImageProducer)object, aspectReplicateScaleFilter);
    }
}

