/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.ImageSeriesDecodingController;
import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiControl;
import com.sun.jimi.core.JimiDecoder;
import com.sun.jimi.core.JimiDecoderFactory;
import com.sun.jimi.core.JimiDecodingController;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.d;
import com.sun.jimi.core.f;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.FreeFormat;
import com.sun.jimi.core.util.GraphicsUtils;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.ProgressListener;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;

public class JimiReader {
    public static final int UNKNOWN = -1;
    protected static final int STREAM_BUFFER_SIZE = 10240;
    protected JimiDecoderFactory decoderFactory;
    protected JimiDecoder decoder;
    protected JimiImageFactory imageFactory;
    protected InputStream input;
    protected JimiRasterImage cacheJimiImage;
    protected ImageProducer cacheImageProducer;
    protected Image cacheImage;
    protected int cacheIndex = -1;
    protected int seriesIndex = 0;
    protected ImageSeriesDecodingController series;
    protected boolean synchronous;
    protected boolean builtinJPEG;
    protected ImageProducer jpegProducer;
    protected URL location;
    protected String filename;
    protected ProgressListener listener;
    protected Runnable cleanupCommand;

    protected JimiReader(JimiImageFactory jimiImageFactory) {
        this.initReader(jimiImageFactory);
    }

    protected JimiReader(JimiImageFactory jimiImageFactory, JimiDecoderFactory jimiDecoderFactory, InputStream inputStream) {
        this.initReader(jimiImageFactory, jimiDecoderFactory, inputStream);
    }

    protected JimiReader(JimiImageFactory jimiImageFactory, InputStream inputStream) {
        inputStream = new PushbackInputStream(inputStream, 128);
        JimiDecoderFactory jimiDecoderFactory = JimiControl.getDecoderForInputStream((PushbackInputStream)inputStream);
        if (jimiDecoderFactory == null) {
            throw new JimiException("Cannot find decoder for stream");
        }
        this.initReader(jimiImageFactory, jimiDecoderFactory, inputStream);
    }

    protected JimiReader(JimiImageFactory jimiImageFactory, InputStream inputStream, String string) {
        JimiDecoderFactory jimiDecoderFactory = JimiControl.getDecoderByType(string);
        if (jimiDecoderFactory == null) {
            throw new JimiException(new StringBuffer("No decoder available for ").append(string).toString());
        }
        this.initReader(jimiImageFactory, jimiDecoderFactory, inputStream);
    }

    protected JimiReader(JimiImageFactory jimiImageFactory, String object) {
        this.cleanupCommand = new d(this);
        this.filename = object;
        try {
            JimiDecoderFactory jimiDecoderFactory = JimiControl.getDecoderByFileExtension((String)object);
            if (jimiDecoderFactory == null) {
                throw new JimiException(new StringBuffer("No decoder available for file: ").append((String)object).toString());
            }
            object = new FileInputStream((String)object);
            object = new BufferedInputStream((InputStream)object, 10240);
            this.initReader(jimiImageFactory, jimiDecoderFactory, (InputStream)object);
            return;
        }
        catch (IOException iOException) {
            throw new JimiException(iOException.toString());
        }
    }

    protected JimiReader(JimiImageFactory object, String object2, String string) {
        this.cleanupCommand = new d(this);
        object = JimiControl.getDecoderByType(string);
        if (object == null) {
            throw new JimiException(new StringBuffer("No decoder available for ").append(string).toString());
        }
        try {
            object2 = new FileInputStream((String)object2);
            object2 = new BufferedInputStream((InputStream)object2, 10240);
            this.initReader(this.imageFactory, (JimiDecoderFactory)object, (InputStream)object2);
            return;
        }
        catch (IOException iOException) {
            throw new JimiException(iOException.getMessage());
        }
    }

    protected JimiReader(JimiImageFactory jimiImageFactory, URL uRL) {
        this.cleanupCommand = new d(this);
        this.location = uRL;
        try {
            JimiDecoderFactory jimiDecoderFactory = JimiControl.getDecoderByFileExtension(uRL.toString());
            Object object = uRL.openConnection();
            Object object2 = uRL.openStream();
            if (jimiDecoderFactory == null) {
                jimiDecoderFactory = JimiControl.getDecoderByType(((URLConnection)object).getContentType());
            }
            if (jimiDecoderFactory == null) {
                object = new PushbackInputStream((InputStream)object2, 128);
                jimiDecoderFactory = JimiControl.getDecoderForInputStream((PushbackInputStream)object);
                object2 = object;
            }
            if (jimiDecoderFactory == null) {
                throw new JimiException(new StringBuffer("No decoder available for location: ").append(uRL).toString());
            }
            object2 = new BufferedInputStream((InputStream)object2, 10240);
            this.initReader(jimiImageFactory, jimiDecoderFactory, (InputStream)object2);
            return;
        }
        catch (IOException iOException) {
            throw new JimiException(iOException.toString());
        }
    }

    protected JimiReader(JimiImageFactory jimiImageFactory, URL object, String object2) {
        this.cleanupCommand = new d(this);
        this.location = object;
        try {
            object2 = JimiControl.getDecoderByType((String)object2);
            if (object2 == null) {
                throw new JimiException(new StringBuffer("No decoder available for file: ").append(object).toString());
            }
            object = ((URL)object).openStream();
            object = new BufferedInputStream((InputStream)object, 10240);
            this.initReader(jimiImageFactory, (JimiDecoderFactory)object2, (InputStream)object);
            return;
        }
        catch (IOException iOException) {
            throw new JimiException(iOException.toString());
        }
    }

    public void close() {
        if (this.decoder != null) {
            this.decoder.setFinished();
        }
    }

    protected Image getBuiltinImage() {
        JimiRasterImage jimiRasterImage;
        try {
            jimiRasterImage = this.getBuiltinJimiImage();
        }
        catch (JimiException jimiException) {
            return JimiUtil.getErrorImage();
        }
        this.cacheJimiImage = jimiRasterImage;
        this.cacheImageProducer = jimiRasterImage.getImageProducer();
        return Toolkit.getDefaultToolkit().createImage(jimiRasterImage.getImageProducer());
    }

    protected Image getBuiltinJPEG() {
        Object object = Toolkit.getDefaultToolkit();
        if (this.location != null) {
            object = ((Toolkit)object).getImage(this.location);
        } else if (this.filename != null) {
            object = ((Toolkit)object).getImage(this.filename);
        } else {
            try {
                int n;
                Object object2 = new ByteArrayOutputStream();
                byte[] byArray = new byte[10240];
                while ((n = this.input.read(byArray)) != -1) {
                    ((ByteArrayOutputStream)object2).write(byArray, 0, n);
                }
                this.input.close();
                object2 = ((ByteArrayOutputStream)object2).toByteArray();
                object = ((Toolkit)object).createImage((byte[])object2);
            }
            catch (IOException iOException) {
                object = JimiUtil.getErrorImage();
            }
        }
        return object;
    }

    protected JimiRasterImage getBuiltinJimiImage() {
        return Jimi.createRasterImage(this.getBuiltinJPEG().getSource(), this.imageFactory);
    }

    public Image getImage() {
        if (this.cacheIndex == 0) {
            if (this.cacheImage != null) {
                return this.cacheImage;
            }
            Image image = Toolkit.getDefaultToolkit().createImage(this.cacheImageProducer);
            GraphicsUtils.waitForImage(image);
            this.cacheImage = image;
            return image;
        }
        try {
            Image image = this.getNextImage();
            if (this.decoder != null) {
                this.decoder.setFinished();
            }
            return image;
        }
        catch (Exception exception) {
            return JimiUtil.getErrorImage();
        }
    }

    public Image getImage(int n) {
        if (n == this.cacheIndex && this.cacheImage != null) {
            return this.cacheImage;
        }
        Object object = this.getImageProducer(n);
        object = Toolkit.getDefaultToolkit().createImage((ImageProducer)object);
        if (this.synchronous) {
            GraphicsUtils.waitForImage((Image)object);
        }
        return object;
    }

    public Enumeration getImageEnumeration() {
        return new f(this, 0);
    }

    public ImageProducer getImageProducer() {
        try {
            if (this.cacheIndex == 0) {
                return this.cacheImageProducer;
            }
            if (this.seriesIndex == 0) {
                ImageProducer imageProducer = this.getNextImageProducer();
                if (this.decoder != null) {
                    this.decoder.setFinished();
                }
                return imageProducer;
            }
        }
        catch (JimiException jimiException) {}
        return JimiUtil.getErrorImageProducer();
    }

    /*
     * Unable to fully structure code
     */
    public ImageProducer getImageProducer(int var1_1) {
        if (var1_1 >= this.seriesIndex) ** GOTO lbl4
        throw new JimiException(new StringBuffer("Unable to access image number ").append(var1_1).toString());
lbl-1000:
        // 1 sources

        {
            this.skipNextImage();
lbl4:
            // 2 sources

            ** while (this.seriesIndex < var1_1)
        }
lbl5:
        // 1 sources

        return this.getNextImageProducer();
    }

    public Enumeration getImageProducerEnumeration() {
        return new f(this, 2);
    }

    protected JimiDecodingController getNextController() {
        return this.series.getNextController();
    }

    protected Image getNextImage() {
        if (this.builtinJPEG) {
            if (this.cacheIndex == 0) {
                if (this.cacheImage != null) {
                    return this.cacheImage;
                }
                Image image = Toolkit.getDefaultToolkit().createImage(this.cacheImageProducer);
                GraphicsUtils.waitForImage(image);
                return image;
            }
            if (this.seriesIndex == 0) {
                Image image = this.getBuiltinJPEG();
                this.cacheIndex = 0;
                this.cacheImage = image;
                this.cacheImageProducer = image.getSource();
                ++this.seriesIndex;
                GraphicsUtils.waitForImage(image);
                return image;
            }
            throw new JimiException();
        }
        Object object = this.getNextImageProducer();
        this.cacheImage = object = Toolkit.getDefaultToolkit().createImage((ImageProducer)object);
        GraphicsUtils.waitForImage((Image)object);
        return object;
    }

    protected ImageProducer getNextImageProducer() {
        JimiRasterImage jimiRasterImage;
        if (this.builtinJPEG) {
            if (this.cacheIndex == 0) {
                return this.cacheImageProducer;
            }
            if (this.seriesIndex == 0) {
                Image image = this.getBuiltinJPEG();
                this.cacheIndex = 0;
                this.cacheImage = image;
                this.cacheImageProducer = image.getSource();
                ++this.seriesIndex;
                return image.getSource();
            }
            throw new JimiException();
        }
        this.cacheJimiImage = jimiRasterImage = this.getNextJimiImage(false);
        this.cacheImageProducer = jimiRasterImage.getImageProducer();
        this.cacheIndex = this.seriesIndex;
        return jimiRasterImage.getImageProducer();
    }

    protected JimiRasterImage getNextJimiImage() {
        return this.getNextJimiImage(true);
    }

    protected JimiRasterImage getNextJimiImage(boolean bl) {
        JimiRasterImage jimiRasterImage;
        if (this.builtinJPEG) {
            if (this.cacheIndex == 0) {
                return this.cacheJimiImage;
            }
            if (this.seriesIndex == 0) {
                Image image;
                this.cacheImage = image = this.getBuiltinJPEG();
                this.cacheImageProducer = null;
                this.cacheJimiImage = null;
                this.cacheIndex = 0;
                ++this.seriesIndex;
                return Jimi.createRasterImage(image.getSource());
            }
            throw new JimiException();
        }
        JimiDecodingController jimiDecodingController = this.series.getNextController();
        JimiImage jimiImage = jimiDecodingController.getJimiImage();
        if (bl && this.synchronous) {
            jimiDecodingController.requestDecoding();
            jimiImage.waitFinished();
        }
        if ((jimiRasterImage = JimiUtil.asJimiRasterImage(jimiImage)) == null) {
            throw new JimiException();
        }
        this.cacheJimiImage = jimiRasterImage;
        this.cacheImageProducer = jimiRasterImage.getImageProducer();
        this.cacheImage = null;
        this.cacheIndex = this.seriesIndex++;
        return jimiRasterImage;
    }

    public int getNumberOfImages() {
        return -1;
    }

    public JimiRasterImage getRasterImage() {
        if (this.cacheIndex == 0) {
            if (this.cacheJimiImage != null) {
                return this.cacheJimiImage;
            }
            return Jimi.createRasterImage(this.cacheImageProducer);
        }
        if (this.seriesIndex == 0) {
            JimiRasterImage jimiRasterImage = this.getNextJimiImage();
            if (this.decoder != null) {
                this.decoder.setFinished();
            }
            return jimiRasterImage;
        }
        throw new JimiException();
    }

    public Enumeration getRasterImageEnumeration() {
        return new f(this, 1);
    }

    public Dimension getSize() {
        JimiRasterImage jimiRasterImage = this.getRasterImage();
        jimiRasterImage.waitInfoAvailable();
        return new Dimension(jimiRasterImage.getWidth(), jimiRasterImage.getHeight());
    }

    protected boolean hasMoreElements() {
        if (this.builtinJPEG) {
            return this.seriesIndex == 0;
        }
        return this.series.hasMoreImages();
    }

    protected void initReader(JimiImageFactory jimiImageFactory) {
        this.imageFactory = jimiImageFactory;
    }

    protected void initReader(JimiImageFactory jimiImageFactory, JimiDecoderFactory jimiDecoderFactory) {
        if (jimiDecoderFactory instanceof FreeFormat) {
            jimiImageFactory = JimiUtil.stripStamping(jimiImageFactory);
        }
        this.initReader(jimiImageFactory);
        this.decoderFactory = jimiDecoderFactory;
        this.decoder = jimiDecoderFactory.createDecoder();
        if (this.listener != null) {
            this.decoder.setProgressListener(this.listener);
        }
        if (jimiDecoderFactory.getClass().getName().equals("com.sun.jimi.core.decoder.builtin.BuiltinDecoderFactory")) {
            this.builtinJPEG = true;
            return;
        }
        if (this.cleanupCommand != null) {
            this.decoder.addCleanupCommand(this.cleanupCommand);
        }
    }

    protected void initReader(JimiImageFactory jimiImageFactory, JimiDecoderFactory jimiDecoderFactory, InputStream inputStream) {
        if (jimiDecoderFactory instanceof FreeFormat) {
            jimiImageFactory = JimiUtil.stripStamping(jimiImageFactory);
        }
        this.imageFactory = jimiImageFactory;
        this.decoderFactory = jimiDecoderFactory;
        this.decoder = jimiDecoderFactory.createDecoder();
        if (this.listener != null && this.decoder != null) {
            this.decoder.setProgressListener(this.listener);
        }
        this.input = inputStream;
        if (jimiDecoderFactory.getClass().getName().equals("com.sun.jimi.core.decoder.builtin.BuiltinDecoderFactory")) {
            this.builtinJPEG = true;
            return;
        }
        if (this.cleanupCommand != null) {
            this.decoder.addCleanupCommand(this.cleanupCommand);
        }
        this.series = this.decoder.initDecoding(jimiImageFactory, inputStream);
    }

    public void setBlocking(boolean bl) {
        this.synchronous = bl;
    }

    public void setMimeType(String string) {
        JimiDecoderFactory jimiDecoderFactory = JimiControl.getDecoderByType(string);
        if (jimiDecoderFactory == null) {
            throw new JimiException(new StringBuffer("Cannot find decoder for type: ").append(string).toString());
        }
        if (this.input != null) {
            this.initReader(this.imageFactory, jimiDecoderFactory, this.input);
            return;
        }
        this.initReader(this.imageFactory, jimiDecoderFactory);
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.listener = progressListener;
        if (this.decoder != null) {
            this.decoder.setProgressListener(progressListener);
        }
    }

    public void setSource(InputStream inputStream) {
        this.initReader(this.imageFactory, this.decoderFactory, inputStream);
    }

    public void setSource(String string) {
        InputStream inputStream;
        try {
            inputStream = new FileInputStream(string);
            this.filename = string;
            inputStream = new BufferedInputStream(inputStream, 10240);
        }
        catch (Exception exception) {
            throw new JimiException("Unable to open source file.");
        }
        this.initReader(this.imageFactory, this.decoderFactory, inputStream);
    }

    public void setSource(URL uRL) {
        try {
            InputStream inputStream = uRL.openStream();
            this.location = uRL;
            new BufferedInputStream(inputStream, 10240);
            return;
        }
        catch (IOException iOException) {
            throw new JimiException("Unable to open source URL.");
        }
    }

    public void skipNextImage() {
        if (!this.series.hasMoreImages()) {
            this.series.skipNextImage();
            ++this.seriesIndex;
            return;
        }
        throw new JimiException("Attemping to move beyond last image.");
    }
}

