/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.MemoryJimiImageFactory;

public class JimiFactoryManager {
    protected static JimiImageFactory memoryFactory;
    protected static JimiImageFactory oneshotFactory;
    protected static JimiImageFactory vmemFactory;
    protected static boolean stampingAvailable;
    protected static boolean vmemInitialized;
    protected static final String ONESHOT_FACTORY_NAME = "com.sun.jimi.core.OneshotJimiImageFactory";
    protected static final String VMEM_FACTORY_NAME = "com.sun.jimi.core.VMemJimiImageFactory";

    static {
        try {
            memoryFactory = new MemoryJimiImageFactory();
            try {
                oneshotFactory = (JimiImageFactory)Class.forName(ONESHOT_FACTORY_NAME).newInstance();
            }
            catch (Exception exception) {
                oneshotFactory = memoryFactory;
            }
            stampingAvailable = false;
        }
        catch (Exception exception) {}
    }

    public static JimiImageFactory getMemoryFactory() {
        return memoryFactory;
    }

    public static JimiImageFactory getOneshotFactory() {
        return oneshotFactory;
    }

    public static JimiImageFactory getVMemFactory() {
        if (!vmemInitialized) {
            JimiFactoryManager.initVMemFactory();
        }
        return vmemFactory;
    }

    protected static void initVMemFactory() {
        vmemInitialized = true;
        try {
            vmemFactory = (JimiImageFactory)Class.forName(VMEM_FACTORY_NAME).newInstance();
            return;
        }
        catch (Exception exception) {
            vmemFactory = memoryFactory;
            return;
        }
    }
}

