/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.JimiControl;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiFactoryManager;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.JimiProExtension;
import com.sun.jimi.core.JimiReader;
import com.sun.jimi.core.JimiWriter;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.raster.JimiRasterImageImporter;
import com.sun.jimi.core.util.JimiImageFactoryProxy;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.QueuedImageProducerProxy;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public class Jimi {
    public static final int ASYNCHRONOUS = 1;
    public static final int SYNCHRONOUS = 2;
    public static final int IN_MEMORY = 4;
    public static final int VIRTUAL_MEMORY = 8;
    public static final int ONE_SHOT = 16;
    protected static int defaultFlags;
    protected static JimiImageFactory memoryFactory;
    protected static JimiImageFactory vmemFactory;
    protected static JimiImageFactory oneshotFactory;
    private static Class a;

    static {
        if (System.getSecurityManager() == null) {
            System.runFinalizersOnExit((boolean)true);
        }
        defaultFlags = 5;
        JimiControl.addExtension(new JimiProExtension());
        memoryFactory = JimiFactoryManager.getMemoryFactory();
        oneshotFactory = JimiFactoryManager.getOneshotFactory();
    }

    private Jimi() {
    }

    private static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static JimiReader createJimiReader(InputStream inputStream) {
        return Jimi.createJimiReader(inputStream, defaultFlags);
    }

    public static JimiReader createJimiReader(InputStream inputStream, int n) {
        return new JimiReader(Jimi.getFactory(n), inputStream);
    }

    public static JimiReader createJimiReader(String string) {
        return Jimi.createJimiReader(string, defaultFlags);
    }

    public static JimiReader createJimiReader(String string, int n) {
        return new JimiReader(Jimi.getFactory(n), string);
    }

    public static JimiReader createJimiReader(URL uRL) {
        return Jimi.createJimiReader(uRL, defaultFlags);
    }

    public static JimiReader createJimiReader(URL uRL, int n) {
        return new JimiReader(Jimi.getFactory(n), uRL);
    }

    public static JimiWriter createJimiWriter(String string) {
        return new JimiWriter(string);
    }

    public static JimiWriter createJimiWriter(String string, OutputStream outputStream) {
        return new JimiWriter(outputStream, string);
    }

    public static JimiRasterImage createRasterImage(ImageProducer imageProducer) {
        return Jimi.createRasterImage(imageProducer, 4);
    }

    public static JimiRasterImage createRasterImage(ImageProducer imageProducer, int n) {
        if (imageProducer instanceof QueuedImageProducerProxy) {
            imageProducer = ((QueuedImageProducerProxy)imageProducer).getImageProducer();
        }
        if (imageProducer instanceof JimiRasterImage) {
            return (JimiRasterImage)((Object)imageProducer);
        }
        return Jimi.createRasterImage(imageProducer, Jimi.getFactory(n));
    }

    protected static JimiRasterImage createRasterImage(ImageProducer imageProducer, JimiImageFactory jimiImageFactory) {
        while (jimiImageFactory instanceof JimiImageFactoryProxy) {
            jimiImageFactory = ((JimiImageFactoryProxy)jimiImageFactory).getProxiedFactory();
        }
        return JimiRasterImageImporter.importImage(imageProducer, jimiImageFactory);
    }

    public static JimiReader createTypedJimiReader(InputStream inputStream, String string) {
        while (true) {
            // Infinite loop
        }
    }

    public static JimiReader createTypedJimiReader(InputStream inputStream, String string, int n) {
        return new JimiReader(Jimi.getFactory(n), inputStream, string);
    }

    public static JimiReader createTypedJimiReader(String string) {
        return Jimi.createTypedJimiReader(string, defaultFlags);
    }

    public static JimiReader createTypedJimiReader(String string, int n) {
        JimiReader jimiReader = new JimiReader(Jimi.getFactory(n));
        jimiReader.setMimeType(string);
        return jimiReader;
    }

    public static JimiWriter createTypedJimiWriter(String string) {
        return new JimiWriter(null, string);
    }

    public static String[] getDecoderTypes() {
        String[] stringArray = new String[JimiControl.mimeToDecoderMap.size()];
        Enumeration enumeration = JimiControl.mimeToDecoderMap.keys();
        int n = 0;
        while (n < stringArray.length && enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public static String[] getEncoderTypes() {
        String[] stringArray = new String[JimiControl.mimeToEncoderMap.size()];
        Enumeration enumeration = JimiControl.mimeToEncoderMap.keys();
        int n = 0;
        while (n < stringArray.length && enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public static JimiImageFactory getFactory(int n) {
        if ((n & 0x10) != 0) {
            return oneshotFactory;
        }
        if ((n & 8) != 0) {
            if (vmemFactory == null) {
                try {
                    vmemFactory = (JimiImageFactory)Class.forName("com.sun.jimi.core.VMemJimiImageFactory").newInstance();
                }
                catch (Exception exception) {
                    vmemFactory = memoryFactory;
                }
            }
            return vmemFactory;
        }
        return memoryFactory;
    }

    public static Image getImage(InputStream inputStream) {
        return Jimi.getImage(inputStream, defaultFlags);
    }

    public static Image getImage(InputStream inputStream, int n) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(inputStream, n));
    }

    public static Image getImage(InputStream inputStream, String string) {
        return Jimi.getImage(inputStream, string, defaultFlags);
    }

    public static Image getImage(InputStream inputStream, String string, int n) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(inputStream, string, n));
    }

    public static Image getImage(String string) {
        return Jimi.getImage(string, defaultFlags);
    }

    public static Image getImage(String string, int n) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(string, n));
    }

    public static Image getImage(String string, String string2) {
        return Jimi.getImage(string, string2, defaultFlags);
    }

    public static Image getImage(String string, String string2, int n) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(string, string2, n));
    }

    public static Image getImage(URL uRL) {
        return Jimi.getImage(uRL, defaultFlags);
    }

    public static Image getImage(URL uRL, int n) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(uRL, n));
    }

    public static Image getImage(URL uRL, String string) {
        return Jimi.getImage(uRL, string, defaultFlags);
    }

    public static Image getImage(URL uRL, String string, int n) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(uRL, string, n));
    }

    public static ImageProducer getImageProducer(InputStream inputStream) {
        return Jimi.getImageProducer(inputStream, defaultFlags);
    }

    public static ImageProducer getImageProducer(InputStream object, int n) {
        try {
            object = new JimiReader(Jimi.getFactory(n), (InputStream)object);
            ((JimiReader)object).setBlocking(JimiUtil.flagSet(n, 2));
            return ((JimiReader)object).getImageProducer();
        }
        catch (JimiException jimiException) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static ImageProducer getImageProducer(InputStream inputStream, String string) {
        return Jimi.getImageProducer(inputStream, string, defaultFlags);
    }

    public static ImageProducer getImageProducer(InputStream object, String string, int n) {
        try {
            object = new JimiReader(Jimi.getFactory(n), (InputStream)object, string);
            ((JimiReader)object).setBlocking(JimiUtil.flagSet(n, 2));
            return ((JimiReader)object).getImageProducer();
        }
        catch (JimiException jimiException) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static ImageProducer getImageProducer(String string) {
        return Jimi.getImageProducer(string, defaultFlags);
    }

    public static ImageProducer getImageProducer(String object, int n) {
        try {
            object = new JimiReader(Jimi.getFactory(n), (String)object);
            ((JimiReader)object).setBlocking(JimiUtil.flagSet(n, 2));
            return ((JimiReader)object).getImageProducer();
        }
        catch (JimiException jimiException) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static ImageProducer getImageProducer(String string, String string2) {
        return Jimi.getImageProducer(string, string2, defaultFlags);
    }

    public static ImageProducer getImageProducer(String object, String string, int n) {
        try {
            object = new JimiReader(Jimi.getFactory(n), (String)object, string);
            ((JimiReader)object).setBlocking(JimiUtil.flagSet(n, 2));
            return ((JimiReader)object).getImageProducer();
        }
        catch (JimiException jimiException) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static ImageProducer getImageProducer(URL uRL) {
        return Jimi.getImageProducer(uRL, defaultFlags);
    }

    public static ImageProducer getImageProducer(URL uRL, int n) {
        try {
            return new JimiReader(Jimi.getFactory(n), uRL).getImageProducer();
        }
        catch (JimiException jimiException) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static ImageProducer getImageProducer(URL uRL, String string) {
        return Jimi.getImageProducer(uRL, string, defaultFlags);
    }

    public static ImageProducer getImageProducer(URL uRL, String string, int n) {
        try {
            return new JimiReader(Jimi.getFactory(n), uRL, string).getImageProducer();
        }
        catch (JimiException jimiException) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static JimiRasterImage getRasterImage(InputStream inputStream) {
        return Jimi.getRasterImage(inputStream, defaultFlags);
    }

    public static JimiRasterImage getRasterImage(InputStream inputStream, int n) {
        return new JimiReader(Jimi.getFactory(n), inputStream).getRasterImage();
    }

    public static JimiRasterImage getRasterImage(InputStream inputStream, String string) {
        return Jimi.getRasterImage(inputStream, string, defaultFlags);
    }

    public static JimiRasterImage getRasterImage(InputStream inputStream, String string, int n) {
        return new JimiReader(Jimi.getFactory(n), inputStream, string).getRasterImage();
    }

    public static JimiRasterImage getRasterImage(String string) {
        return Jimi.getRasterImage(string, defaultFlags);
    }

    public static JimiRasterImage getRasterImage(String object, int n) {
        object = new JimiReader(Jimi.getFactory(n), (String)object);
        ((JimiReader)object).setBlocking(JimiUtil.flagSet(n, 2));
        return ((JimiReader)object).getRasterImage();
    }

    public static JimiRasterImage getRasterImage(URL uRL) {
        return Jimi.getRasterImage(uRL, defaultFlags);
    }

    public static JimiRasterImage getRasterImage(URL uRL, int n) {
        return new JimiReader(Jimi.getFactory(n), uRL).getRasterImage();
    }

    public static JimiRasterImage getRasterImage(URL uRL, String string) {
        return Jimi.getRasterImage(uRL, string, defaultFlags);
    }

    public static JimiRasterImage getRasterImage(URL uRL, String string, int n) {
        return new JimiReader(Jimi.getFactory(n), uRL, string).getRasterImage();
    }

    public static void main(String[] object) {
        if (((String[])object).length == 0) {
            System.err.println("Usage: Jimi <-version | -encoders | -decoders>");
        }
        if (object[0].equals("-version")) {
            try {
                object = new Properties();
                ((Properties)object).load((a != null ? a : (a = Jimi.a("com.sun.jimi.core.Jimi"))).getResourceAsStream("version"));
                System.out.println(new StringBuffer("Jimi version: ").append(((Properties)object).getProperty("jimi.version")).append(" (build ").append(((Properties)object).getProperty("jimi.build")).append(")").toString());
                return;
            }
            catch (Exception exception) {
                System.err.println(new StringBuffer("Unable to read version information: ").append(exception.toString()).toString());
                return;
            }
        }
        if (object[0].equals("-encoders")) {
            System.out.println("Supported encoder mimetypes:");
            object = Jimi.getEncoderTypes();
            int n = 0;
            while (n < ((String[])object).length) {
                System.out.println((String)object[n]);
                ++n;
            }
            return;
        }
        if (object[0].equals("-decoders")) {
            System.out.println("Supported decoder mimetypes:");
            object = Jimi.getDecoderTypes();
            int n = 0;
            while (n < ((Object)object).length) {
                System.out.println((String)object[n]);
                ++n;
            }
        }
    }

    public static void putImage(JimiImage jimiImage, String string) {
        JimiWriter jimiWriter = new JimiWriter(string);
        jimiWriter.setSource(jimiImage);
        jimiWriter.putImage(string);
    }

    public static void putImage(Image image, String string) {
        Jimi.putImage(image.getSource(), string);
    }

    public static void putImage(ImageProducer imageProducer, String string) {
        Jimi.putImage(Jimi.createRasterImage(imageProducer), string);
    }

    public static void putImage(String object, JimiImage jimiImage, OutputStream outputStream) {
        object = new JimiWriter(outputStream, (String)object);
        ((JimiWriter)object).setSource(jimiImage);
        ((JimiWriter)object).putImage(outputStream);
    }

    public static void putImage(String object, JimiImage jimiImage, String string) {
        object = new JimiWriter(string, (String)object);
        ((JimiWriter)object).setSource(jimiImage);
        ((JimiWriter)object).putImage(string);
    }

    public static void putImage(String string, Image image, OutputStream outputStream) {
        Jimi.putImage(string, image.getSource(), outputStream);
    }

    public static void putImage(String object, Image image, String string) {
        object = new JimiWriter(string, (String)object);
        ((JimiWriter)object).setSource(image);
        ((JimiWriter)object).putImage(string);
    }

    public static void putImage(String string, ImageProducer imageProducer, OutputStream outputStream) {
        Jimi.putImage(string, (JimiImage)Jimi.createRasterImage(imageProducer), outputStream);
    }

    public static void putImage(String object, ImageProducer imageProducer, String string) {
        object = new JimiWriter(string, (String)object);
        ((JimiWriter)object).setSource(imageProducer);
        ((JimiWriter)object).putImage(string);
    }

    public static void setDefaultFlags(int n) {
        defaultFlags = n;
    }
}

