unit Unit1;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, GamePan, StdCtrls, MMSystem, Buttons, About, Unit2;

type
  TForm1 = class(TForm)
    GamePan1: TGamePan;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    Memo1: TMemo;
    SpeedButton8: TSpeedButton;
    SpeedButton9: TSpeedButton;
    Panel1: TPanel;
    Shape1: TShape;
    Shape2: TShape;
    Shape3: TShape;
    Shape4: TShape;
    Panel2: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    ComboBox1: TComboBox;
    Panel3: TPanel;
    procedure GameOver;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);
    procedure EnableButtons(Sender: TObject);
    procedure SpeedButton7Click(Sender: TObject);
    procedure NextShape(lf1, tp1, lf2, tp2, lf3, tp3, lf4, tp4: Integer; Col: TColor);
    procedure FormCreate(Sender: TObject);
    procedure Shapes(var Sha: TShape);
    procedure GamePan1ArcanoidOver(Sender: TObject);
    procedure GamePan1ScrambleOver(Sender: TObject);
    procedure GamePan1TetrisOver(Sender: TObject);
    procedure GamePan1FiguresOver(Sender: TObject);
    procedure SpeedButton8Click(Sender: TObject);
    procedure GamePan1TetrisDelete(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormPaint(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure GamePan1ArcanoidEndLevel(Sender: TObject);
    procedure PlayWave(const ResName: string; SYN: Boolean);
    procedure GamePan1ArcanoidDelete(Sender: TObject);
    procedure GamePan1TetrisContact(Sender: TObject);
    procedure GamePan1FiguresMove(Sender: TObject);
    procedure GamePan1ScrambleMove(Sender: TObject);
    procedure SpeedButton9Click(Sender: TObject);
    procedure GamePan1ArcanoidContact(Sender: TObject);
  private
      Pict: TPicture;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

var
lf, wi, tp, he, StartDelay, StepDelay, Lines: Integer;
TetLevel, Levels, LevelLines, Rnd: Word;
Sound: Boolean;
sur: String;

{$R *.DFM}
{$R puz4.res}


procedure TForm1.FormCreate(Sender: TObject);
var
delay: Cardinal;
begin
Delay:=GetTickCount;
lf:=GamePan1.Left;
wi:=Gamepan1.Width;
tp:=GamePan1.Top;
he:=GamePan1.Height;
StartDelay:=510; StepDelay:=50; Sound:=True;
Levels:=10; LevelLines:=10;
Randomize;
Pict:=nil;
Rnd:=Random(2)+1;
sur:='backgr'+IntToStr(Rnd)+'.bmp';
GamePan1.BStPicture:=sur;
GamePan1.AOverPicture:=sur;
if Rnd=2 then begin Memo1.Color:=clSilver; GamePan1.ColorTF:=clSilver; end;
 if Pict = nil then Pict := TPicture.Create;
try
  Pict.LoadFromFile (sur);
except
ShowMessage('Cannot Open '+sur);
Pict.Free; Pict:=nil; sur:='';
GamePan1.BStPicture:='';
GamePan1.AOverPicture:='';
end;
While (GetTickCount<delay+3000) do {nothing}
end;

procedure TForm1.PlayWave(const ResName : string; SYN: Boolean);
var
  hWaveRes : THandle;
  ResPtr : pointer;
begin
  hWaveRes:=LoadResource(hInstance,
      FindResource(hInstance,PChar(ResName),RT_RCDATA));
  if hWaveRes=0 then
    raise Exception.Create('Resource not found');
  ResPtr:=LockResource(hWaveRes);
  if SYN then
  sndPlaySound(ResPtr,SND_MEMORY or SND_SYNC)
  else
  sndPlaySound(ResPtr,SND_MEMORY or SND_ASYNC);
  UnlockResource(hWaveRes);
  FreeResource(HWaveRes);
end;

procedure TForm1.GameOver;
begin
if Form2<>nil then
begin
Form2.sur:=sur;
Form2.LoadPict;
Form2.RC:=IntToStr(GamePan1.SRowsColumns);
if GamePan1.FSquare=Big then
Form2.FG:='First' else Form2.FG:='Second';
Form2.AR:=IntToStr(GamePan1.ARows);
Form2.AC:=IntToStr(GamePan1.AColumns);
Form2.TR:=IntToStr(GamePan1.TRows);
Form2.TC:=IntToStr(GamePan1.TColumns);
Form2.lf:=Left; Form2.tp:=Top;
Case GamePan1.State of
Tetris:
begin Form2.ST:='T'; Form2.GP:='Tetris'; End;
Arcanoid:
begin if GamePan1.AStrongShapes then Form2.ST:='' else Form2.ST:=''; Form2.GP:='Arcanoid'; end;
Scramble:
begin Form2.GP:='Scramble'; Form2.SRC:=IntToStr(GamePan1.SRowsColumns); end;
Figures: Form2.Gp:='Figures';
end;
end;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
if (Sound) then PlayWave('zari', False);
EnableButtons(Sender);
SpeedButton6.Enabled:=False;
GamePan1.State:=stPanel;
GamePan1.Hide;
Memo1.Show;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
GamePan1.Hide; Memo1.Hide;
GamePan1.ClientWidth:=GamePan1.ClientHeight div 2;
GamePan1.Left:=80+(wi-GamePan1.Width) div 2;
GamePan1.Top:=tp;
GamePan1.Height:=he;
EnableButtons(Sender);
Panel2.Show;
GamePan1.State:=Tetris;
if (Sound) then PlayWave('step', False);
GamePan1.Show;
end;

procedure TForm1.EnableButtons(Sender: TObject);
var
i: Integer;
begin
for i:=0 to ControlCount-1 do
begin
if (Controls[i] is TSpeedButton) then
(Controls[i] as TSpeedButton).Enabled:=True;
end;
(Sender as TSpeedButton).Enabled:=False;
SpeedButton9.Caption:='Pa&use';
SpeedButton9.Enabled:=False;
Panel1.Hide; Panel2.Hide; Panel3.Hide;
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
GamePan1.Hide; Memo1.Hide;
GamePan1.SetBounds(lf, tp, wi, he);
EnableButtons(Sender);
GamePan1.State:=Arcanoid;
if (Sound) then PlayWave('step', False);
GamePan1.Show;
end;

procedure TForm1.BitBtn4Click(Sender: TObject);
begin
GamePan1.Hide; Memo1.Hide;
GamePan1.ClientWidth:=GamePan1.ClientHeight;
GamePan1.Left:=80+(wi-GamePan1.Width) div 2;
GamePan1.Top:=tp;
GamePan1.Height:=he;
EnableButtons(Sender);
GamePan1.State:=Scramble;
if (Sound) then PlayWave('step', False);
GamePan1.Show;
end;

procedure TForm1.BitBtn5Click(Sender: TObject);
begin
GamePan1.Hide; Memo1.Hide;
GamePan1.ClientWidth:=GamePan1.ClientHeight;
GamePan1.Left:=80+(wi-GamePan1.Width) div 2;
GamePan1.Top:=tp;
GamePan1.Height:=he;
EnableButtons(Sender);
GamePan1.State:=Figures;
if (Sound) then PlayWave('step', False);
GamePan1.Show;
end;

procedure TForm1.BitBtn6Click(Sender: TObject);
begin
SpeedButton6.Enabled:=False;
SpeedButton9.Enabled:=True;
if GamePan1.State=Tetris then
begin
Panel3.Show;
Panel3.Caption:='Level '+ComboBox1.Text;
TetLevel:=StrToInt(ComboBox1.Text);
GamePan1.TCoeff:=TetLevel*TetLevel;
GamePan1.TDelay:=StartDelay-StepDelay*(TetLevel-1);
Lines:=0;
Panel2.Hide;
Panel1.Show;
end;
if (Sound) then PlayWave('zari', False);
GamePan1.Start:=True;
end;

procedure TForm1.SpeedButton7Click(Sender: TObject);
begin
Close;
end;

procedure TForm1.GamePan1ArcanoidOver(Sender: TObject);
begin
Form2:=TForm2.Create(Application);
GameOver;
Try
Form2.Moves:=IntToStr(GamePan1.AScores);
Form2.Caption:='Game Over! Result:'+Form2.Moves;
Form2.Left:=Left;
Form2.Top:=Top;
Form2.ShowModal;
Finally
if (Form2.Pict<>nil)then Form2.Pict.Free;
Form2.Free; Form2:=nil;
end;
SpeedButton6.Enabled:=True;
SpeedButton9.Enabled:=False;
end;

procedure TForm1.GamePan1ScrambleOver(Sender: TObject);
begin
Form2:=TForm2.Create(Application);
GameOver;
Try
Form2.Moves:=IntToStr(GamePan1.smoves);
Form2.Caption:='Game Over! Result:'+Form2.Moves;
Form2.ShowModal;
Finally
if (Form2.Pict<>nil)then Form2.Pict.Free;
Form2.Free; Form2:=nil;
end;
SpeedButton6.Enabled:=True;
SpeedButton9.Enabled:=False;
end;

procedure TForm1.GamePan1TetrisOver(Sender: TObject);
begin
Form2:=TForm2.Create(Application);
GameOver;
Try
Form2.Moves:=IntToStr(GamePan1.TScores);
Form2.Caption:='Game Over! Result:'+Form2.Moves;
Form2.ShowModal;
Finally
if (Form2.Pict<>nil)then Form2.Pict.Free;
Form2.Free; Form2:=nil;
end;
Panel1.Hide; Panel2.Show;
SpeedButton6.Enabled:=True;
SpeedButton9.Enabled:=False;
end;

procedure TForm1.GamePan1FiguresOver(Sender: TObject);
begin
Form2:=TForm2.Create(Application);
GameOver;
Try
Form2.Moves:=IntToStr(GamePan1.fmoves);
Form2.Caption:='Game Over! Result:'+Form2.Moves;
Form2.ShowModal;
Finally
if (Form2.Pict<>nil)then Form2.Pict.Free;
Form2.Free; Form2:=nil;
end;
SpeedButton6.Enabled:=True;
SpeedButton9.Enabled:=False;
end;

procedure TForm1.SpeedButton8Click(Sender: TObject);
begin
if (Sound) then PlayWave('zari', False);
AboutBox:=TAboutbox.Create(Application);
Try
AboutBox.Lf:=Left;
Aboutbox.Tp:=Top;
AboutBox.Height:=400;
AboutBox.sur:=sur;
AboutBox.LoadPict;
Aboutbox.ShowModal;
finally
if (AboutBox.Pict<>nil)then AboutBox.Pict.Free;
Aboutbox.Free; Aboutbox:=nil;
end;
if (Sound) then PlayWave('zari', False);
end;

procedure TForm1.GamePan1TetrisDelete(Sender: TObject);
var
i, j, r: Integer;
begin

if (Sound) then PlayWave('step', False);
Inc(Lines);
if TetLevel<>Levels then
begin
j:=0;
for i:=1 to TetLevel do j:=j+i*i*LevelLines;
if (GamePan1.TScores>=j)then
begin
Inc(TetLevel);
Panel3.Caption:='Level '+IntToStr(TetLevel);
With GamePan1 do
begin

Randomize; r:=Random(4);
if r<=1 then ShapesTShape:=stRoundRect else
if r=2 then ShapesTShape:=stRectangle else
ShapesTShape:=stEllipse;

Randomize; r:=random(5);
if r=1 then ShapesTBrushStyle:=bsDiagCross
else
if r=2 then ShapesTBrushStyle:=bsCross
else
ShapesTBrushStyle:=bsSolid;

Randomize; r:=random(3);
if r=1 then ColorTShapesPen:=clBlack
else ColorTShapesPen:=clWhite;

Randomize; r:=random(2);
if r=1 then OneColorTShapes:=clBlack
else OneColorTShapes:=clWhite;

Randomize; r:=random(6);
if (r<=1) then ColorTShapes:=ColorRandom
else if(r=2)then ColorTShapes:=ColorOne
else ColorTShapes:=ColorFixed2;

TCoeff:=TetLevel*TetLevel;
TDelay:=StartDelay-(TetLevel-1)*StepDelay;

end;
end;
end;
end;

procedure TForm1.Shapes(var Sha: TShape);
begin
With GamePan1 do
begin
if ColorTShapes=ColorOne then Sha.Brush.Color:=OneColorTShapes;
Sha.Pen.Color:=ColorTShapesPen;
Sha.Brush.Style:=ShapesTBrushStyle;
Sha.Shape:=ShapesTShape;
end;
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
if (Key = vk_Return)then if (GamePan1.State<>stPanel) then if
(GamePan1.Start=False) then BitBtn6Click(Sender);
if (Key = vk_Space)then if GamePan1.Start then
With GamePan1 do
if State=Arcanoid then GKey:=Up
else
if State=Tetris then GKey:=Drp;
end;

procedure TForm1.FormPaint(Sender: TObject);
var
i,j: Integer;
begin
if Pict=nil then exit;
for i:=0 to width div Pict.Graphic.Width do
for j:=0 to height div Pict.Graphic.height do
Canvas.Draw(i*Pict.Graphic.width, j*Pict.Graphic.Height, Pict.Graphic);
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if MessageDlg('Close Program?', mtInformation, [mbOk, mbNo], 0) = mrOk then
  begin
  if Pict <> nil then begin Pict.Free; Pict:=nil; end;
  CanClose := True;
  end
  else
  begin
    CanClose := False;
    if (Sound) then PlayWave('zari', False);
  end;
end;

procedure TForm1.GamePan1ArcanoidEndLevel(Sender: TObject);
var
r: word;
begin
With GamePan1 do
begin
Randomize;
r:=Random(4);
if (r=0)then ShapesAShape:=stEllipse
else if (r=1)then ShapesAShape:=stRectangle
else ShapesAShape:=stRoundRect;
end;
end;

procedure TForm1.GamePan1ArcanoidDelete(Sender: TObject);
begin
if (Sound) then PlayWave('zari', False);
end;

procedure TForm1.NextShape(lf1, tp1, lf2, tp2, lf3, tp3, lf4, tp4: Integer; Col: TColor);
begin
Shape1.Left:=lf1;
Shape2.Left:=lf2;
Shape4.Left:=lf4;
Shape3.Left:=lf3;
Shape1.Top:=tp1;
Shape2.Top:=tp2;
Shape4.Top:=tp4;
Shape3.Top:=tp3;
Shape1.Brush.Color:=Col;
Shape2.Brush.Color:=Col;
Shape3.Brush.color:=Col;
Shape4.Brush.color:=Col;
Shapes(Shape1);
Shapes(Shape2);
Shapes(Shape3);
Shapes(Shape4);
end;

procedure TForm1.GamePan1TetrisContact(Sender: TObject);
begin
if (Sound) then PlayWave('zari', False);
with GamePan1 do
  case NextTShape of
    1: NextShape(16, 24,  32, 24,  16, 40,  16, 56, clAqua);
    2: NextShape(16, 24,  32, 24,  32, 40,  32, 56, clRed);
    3: NextShape(32, 24,  16, 40,  32, 40,  32, 56, clLime);
    4: NextShape(32, 24,  16, 40,  32, 40,  16, 56, clYellow);
    5: NextShape(16, 24,  32, 40,  16, 40,  32, 56, clBlue);
    6: NextShape(24, 16,  24, 32,  24, 48,  24, 64, clFuchsia);
    7: NextShape(16, 32,  32, 32,  16, 48,  32, 48, clSilver);
    end;
end;

procedure TForm1.GamePan1FiguresMove(Sender: TObject);
begin
if (Sound) then PlayWave('step', False);
end;

procedure TForm1.GamePan1ScrambleMove(Sender: TObject);
begin
if (Sound) then PlayWave('step', False);
end;

procedure TForm1.SpeedButton9Click(Sender: TObject);
begin
With GamePan1 do
if Pause then
begin
Pause:=False;
SpeedButton9.Caption:='Pa&use';
end
else
begin
Pause:=True;
SpeedButton9.Caption:='Contin&ue';
end;
end;

procedure TForm1.GamePan1ArcanoidContact(Sender: TObject);
begin
if (Sound) then PlayWave('step', False);
end;

end.
