<?php

/***********************************************************************
*                                                                      *
*                                                                      *
*                            PHP CONV                                  *
*                                                                      *
*                      iconv emultation tool                           *
*                                                                      *
*                                                                      *
*               for include PHP CONV use this code                     *
*                                                                      *
*               $iconv='php_conv/charsets.php';                        *
*               $charsets_dir="php_conv/incl";                         *
*               if (file_exists($iconv)) include ($iconv);             *
*                                                                      *
*                                                                      *
*            Copyright(c) 2004 http://www.php-messenger.com            *
*                                                                      *
***********************************************************************/




if (!function_exists('iconv'))
{
	$inner_coding='UTF-8';
	$charsets=array(
	'ASCII'=>FALSE,
	'ISO-8859-1'=>FALSE,
	'ISO-8859-2'=>FALSE,
	'ISO-8859-3'=>FALSE,
	'ISO-8859-4'=>FALSE,
	'ISO-8859-5'=>FALSE,
	'ISO-8859-7'=>FALSE,
	'ISO-8859-9'=>FALSE,
	'ISO-8859-10'=>FALSE,
	'ISO-8859-13'=>FALSE,
	'ISO-8859-14'=>FALSE,
	'ISO-8859-15'=>FALSE,
	'ISO-8859-16'=>FALSE,
	'KOI8-R'=>FALSE,
	'KOI8-U'=>FALSE,
	'CP1250'=>FALSE,
	'CP1251'=>FALSE,
	'CP1252'=>FALSE,
	'CP1253'=>FALSE,
	'CP1254'=>FALSE,
	'CP1257'=>FALSE,
	'CP850'=>FALSE,
	'CP866'=>FALSE,
	'MacCyrillic'=>FALSE,
	'Macintosh'=>FALSE,
	'ISO-8859-8'=>FALSE,
	'CP1255'=>FALSE,
	'CP1256'=>FALSE,
	'CP862'=>FALSE,
	'SHIFT_JIS'=>FALSE,
	'CP932'=>FALSE,
	'EUC-JP'=>FALSE,
	'EUC-CN'=>FALSE,
	'GBK'=>FALSE,
	'GB18030'=>FALSE,
	'EUC-TW'=>FALSE,
	'BIG5'=>FALSE,
	'CP950'=>FALSE,
	'BIG5-HKSCS'=>FALSE,
	'EUC-KR'=>FALSE,
	'CP949'=>FALSE,
	'JOHAB'=>FALSE,
	'ARMSCII-8'=>FALSE,
	'Georgian-Academy'=>FALSE,
	'Georgian-PS'=>FALSE,
	'KOI8-T'=>FALSE,
	'TIS-620'=>FALSE,
	'CP874'=>FALSE,
	'CP1133'=>FALSE,
	'VISCII'=>FALSE,
	'TCVN'=>FALSE,
	'CP1258'=>FALSE,
	'HP-ROMAN8'=>FALSE,
	'UCS-2'=>FALSE,
	'UCS-2BE'=>FALSE,
	'UCS-2LE'=>FALSE,
	'UTF-16BE'=>FALSE,
	'UTF-16LE'=>FALSE,
	'CP437'=>FALSE,
	'CP737'=>FALSE,
	'CP775'=>FALSE,
	'CP852'=>FALSE,
	'CP855'=>FALSE,
	'CP857'=>FALSE,
	'CP860'=>FALSE,
	'CP861'=>FALSE,
	'CP863'=>FALSE,
	'CP865'=>FALSE,
	'CP869'=>FALSE,
	'CP1125'=>FALSE,
	'CP864'=>FALSE);
	
	$charsets_inv=$charsets;
	function do_str(&$arr,$str)
	{
		$out_value='';
		$look_from=0;
		for ($i=0;$i<strlen($str);$i++)
		{
			if (array_key_exists(substr($str,$look_from,$i-$look_from+1),$arr))
			{
				$out_value.=$arr[substr($str,$look_from,$i-$look_from+1)];
				$look_from=$i+1;
			}elseif ($i-$look_from>5 && $i+1<strlen($str))
			{
				$look_from++;
				$out_value.="?";
			}elseif ($i>$look_from && $i+1==strlen($str))
			{
				$out_value.="?";
				$look_from++;
				$i--;
			}
		}
		return $out_value;
	}
	
	function do_chars($charset,$str,$mode)
	{
		global $charsets,$charsets_inv,$inner_coding,$path_to_php_conv_incl;
		if ($inner_coding==$charset)
		{
			return $str;
		}else
		{
			if (!$charsets[$charset])
			{
				if (file_exists("$path_to_php_conv_incl/$charset.php"))
				{
					require ("$path_to_php_conv_incl/$charset.php");
					$charsets_inv[$charset]=array();
					foreach ($charsets[$charset] as $key => $val)
					{
						$charsets_inv[$charset][$val]=$key;
					}
				}else
				{
					echo "File $path_to_php_conv_incl/$charset.php not found!\n";
				}
				
			}
			if ($mode==1)
			{
				return do_str($charsets_inv[$charset],$str);
			}else
			{
				return do_str($charsets[$charset],$str);
			}
		}
	}
	

	function iconv($in_charset, $out_charset, $str)
	{
		global $charsets,$inner_coding;
		if ($in_charset==$out_charset)
		{
			return $str;
		}elseif ((array_key_exists($in_charset,$charsets) || $in_charset==$inner_coding) && (array_key_exists($out_charset,$charsets) || $out_charset==$inner_coding))
		{
			return do_chars($out_charset,do_chars($in_charset, $str,0),1);
		}else
		{
			return 'Unqnown charset!';
		}
	}

}






?>