<?php

$config['mail_target'] = $vashemail; // емайл адрес - в настройках сайта. 
$config['smtp']          = false; //отправка через smtp. true - да, false - нет, отправка через php_mail()
$config['smtp_debug']    = true; //Если Вы хотите видеть сообщения ошибок, укажите true вместо false
$config['smtp_username'] = 'my@yandex.ru'; //Смените на имя своего почтового ящика. Требуется для авторизации
$config['smtp_password'] = 'VASHPAROL'; //Измените пароль
$config['smtp_port']     = '25'; // Порт, для yandex.ru - 25, для mail.ru и hotbox.ru - 25 или 2525
$config['smtp_host']     = 'smtp.yandex.ru'; //сервер для отправки, яндекс - smtp.yandex.ru
$config['smtp_charset']  = 'UTF-8'; //кодировка сообщений. (или UTF-8, итд)

function safestr($str)
{
    return str_replace("\n", "<br />", str_replace("\r\n", "<br />", htmlspecialchars(strip_tags($str))));
}
function valid_email($mail)
{
    return preg_match("/^[a-zA-Z0-9_\-\.]+@[a-zA-Z0-9\-]{2,}\.[a-zA-Z0-9\-\.]+$/i", $mail);
}
//функция составления тела сообщения.
function message_body($mail){
  $message = '' . $mail['message'] . '<br />
------------------ <br />
 ' . $mail['name'] . ' ' . $mail['sname'] . '<br />';
    return $message;
}
function message_headers($mail)
{
    global $config;
    $avtor_name="=?UTF-8?Q?".str_replace("+","_",str_replace("%","=",urlencode($mail['name'])))."?= ";
    $headers = "Date: " . date("D, d M Y H:i:s") . " UT\r\n";
    $headers .= "Subject: =?" . $config['smtp_charset'] . "?B?" . base64_encode($mail['subject']) . "?=\r\n";
    $headers .= "Reply-To: ".$avtor_name." <" . $mail['email'] . ">\r\n";
    $headers .= "Content-Type: text/html; charset=\"" . $config['smtp_charset'] . "\"\r\n";
    $headers .= "Content-Transfer-Encoding: 8bit\r\n";
    $headers .= "From: ".$avtor_name." <".$mail['email'].">\r\n";
    $headers .= "X-Priority: 3";
    $headers .= "X-Mailer: PHP/" . phpversion() . "\r\n";
    return $headers;
}
//========================================
//  функция отправки по smtp
function smtpmail($headers, $message)
{
    global $config;
    $SEND = $headers . $message;
    echo $SEND;
    if (!$socket = fsockopen($config['smtp_host'], $config['smtp_port'], $errno, $errstr, 30)) {
        if ($config['smtp_debug'])
            echo $errno . "&lt;br&gt;" . $errstr;
        return false;
    }
    
    if (!server_parse($socket, "220", __LINE__))
        return false;
    
    fputs($socket, "HELO " . $config['smtp_host'] . "\r\n");
    if (!server_parse($socket, "250", __LINE__)) {
        if ($config['smtp_debug'])
            echo '<p>Не могу отправить HELO!</p>';
        fclose($socket);
        return false;
    }
    fputs($socket, "AUTH LOGIN\r\n");
    if (!server_parse($socket, "334", __LINE__)) {
        if ($config['smtp_debug'])
            echo '<p>Не могу найти ответ на запрос авторизаци.</p>';
        fclose($socket);
        return false;
    }
    fputs($socket, base64_encode($config['smtp_username']) . "\r\n");
    if (!server_parse($socket, "334", __LINE__)) {
        if ($config['smtp_debug'])
            echo '<p>Логин авторизации не был принят сервером!</p>';
        fclose($socket);
        return false;
    }
    fputs($socket, base64_encode($config['smtp_password']) . "\r\n");
    if (!server_parse($socket, "235", __LINE__)) {
        if ($config['smtp_debug'])
            echo '<p>Пароль не был принят сервером как верный! Ошибка авторизации!</p>';
        fclose($socket);
        return false;
    }
    fputs($socket, "MAIL FROM: <" . $config['smtp_username'] . ">\r\n");
    if (!server_parse($socket, "250", __LINE__)) {
        if ($config['smtp_debug'])
            echo '<p>Не могу отправить комманду MAIL FROM: </p>';
        fclose($socket);
        return false;
    }
    fputs($socket, "RCPT TO: <" . $config['mail_target'] . ">\r\n");
    
    if (!server_parse($socket, "250", __LINE__)) {
        if ($config['smtp_debug'])
            echo '<p>Не могу отправить комманду RCPT TO: </p>';
        fclose($socket);
        return false;
    }
    fputs($socket, "DATA\r\n");
    
    if (!server_parse($socket, "354", __LINE__)) {
        if ($config['smtp_debug'])
            echo '<p>Не могу отправить комманду DATA</p>';
        fclose($socket);
        return false;
    }
    fputs($socket, $SEND . "\r\n.\r\n");
    
    if (!server_parse($socket, "250", __LINE__)) {
        if ($config['smtp_debug'])
            echo '<p>Не смог отправить тело письма. Письмо не было отправленно!</p>';
        fclose($socket);
        return false;
    }
    fputs($socket, "QUIT\r\n");
    fclose($socket);
    return TRUE;
}
function server_parse($socket, $response, $line = __LINE__)
{
    global $config;
    while (substr(@$server_response, 3, 1) != ' ') {
        if (!($server_response = fgets($socket, 256))) {
            if ($config['smtp_debug'])
                echo "<p>Проблемы с отправкой почты!</p>$response<br>$line<br>";
            return false;
        }
    }
    if (!(substr(@$server_response, 0, 3) == $response)) {
        if ($config['smtp_debug'])
            echo "<p>Проблемы с отправкой почты!</p>$response<br>$line<br>";
        return false;
    }
    return true;
}

//=============================================

$mail = array(
    'name' => @safestr($_POST['name']),
    'email' => @safestr($_POST['email']),
    'subject' => @safestr($_POST['subject']),
    'message' => @safestr($_POST['message']),
    'validate' => @safestr($_POST['validate'])
);

$show_form = true;
if (count($_POST) > 0) {
    //проверка введенного на валидность
    if ($mail['validate'] != '') {
        //открываем файл с массивом ключей
        $file = @file("mycode/key_captcha.dat");
        if ($file)
            $keys = unserialize(str_replace("\n", "", str_replace("\r", "", $file[0])));
        else
            $keys = array();
        if ($keys[$_SERVER['REMOTE_ADDR']] != $mail["validate"])
            $err[] = 'Неверно введена проверочная сумма';
    } else {
        $err[] = 'Вы не ввели проверочную сумму цифр';
    }
    if ($mail['name'] == '')
        $err[] = 'Укажите свое имя';
    if (!valid_email($mail['email']))
        $err[] = 'Необходимо ввести существующий E-mail для связи';
    if ($mail['subject'] == '')
        $err[] = 'Заполните тему сообщения';
    if (strlen($mail['subject']) > 100)
        $err[] = 'Вы ввели слишком длинную тему сообщения. Заглавие должно быть коротким и емким, не более 100 символов.';
    if ($mail['message'] == '')
        $err[] = 'Вы не ввели текст сообщения';
    //if(strlen($mail['message'])>1000) { $err[]='Вы ввели слишком длинное сообщение. Это книга отзывов, а не блог'; }
    //окончание проверок
    
    //обработка результата проверок
    if (count($err) == 0) {
        $show_form = false;
        /*** Отправляем E-Mail ***/
        $headers   = message_headers($mail);
        $message   = message_body($mail);
        if ($config['smtp'])
            $mail_result = @smtpmail($headers, $message);
        else
            $mail_result = mail($config['mail_target'], $mail['subject'], $message, $headers);
        /*************************/
        if (!$mail_result) {
            $info[] = "Ваше сообщение по каким-то техническим причинам не было отправлено. Попробуй отправить позже еще раз.";
        } else {
            $info[] = 'Ваше сообщение отправлено';
            $info[] = 'Благодарим за проявленный интерес.';
        }
        echo '<div class="info">';
        for ($i = 0; $i < count($info); $i++) {
            echo '<font color="green">&raquo; </font>' . $info[$i] . '<br />';
        }
        echo '</div>';
    } else {
        $err[] = '<b>Сообщение не было отправлено!</b><br>';
        echo '<div class="error">';
        for ($i = 0; $i < count($err); $i++) {
            echo '<font color="#FF0000">&raquo; </font>' . $err[$i] . '<br />';
        }
        echo '</div>';
    }
}
if ($show_form)
    echo '
			<p class="text-center">Все поля формы обязательны для заполнения.</p>
			<div class="col-md-offset-1 col-md-10 col-sm-12 wow fadeIn" data-wow-delay="0.9s">
				<form action="contact.html" method="post">
					<div class="col-md-6 col-sm-6">
						<input name="name" type="text" class="form-control" id="name" placeholder="Имя">
				  </div>
					<div class="col-md-6 col-sm-6">
						<input name="email" type="email" class="form-control" id="email" placeholder="Email"><br />
				  </div>
					<div class="col-md-12 col-sm-12">
						<input name="subject" type="text" class="form-control" id="subject" placeholder="Тема сообщения"><br />
				  </div>
					<div class="col-md-12 col-sm-12">
						<textarea name="message" rows="8" class="form-control" id="message" placeholder="Текст сообщения"></textarea><br />
					</div>
					<div class="col-md-6 col-sm-6">
						<input name="validate" type="text" class="form-control" id="validate" placeholder="Сумма цифр">
				  </div>
					<div class="col-md-6 col-sm-6">
						<img src="captcha.php" id="captcha" alt="код подтверждения" onclick="document.getElementById(\'captcha\').src = \'captcha.php?rid=\' + Math.random();" title="Щелкните, чтобы обновить картинку" /><br />
				  </div>
					<div class="col-md-offset-3 col-md-6 col-sm-offset-3 col-sm-6">
						<br /><input name="submit" type="submit" class="btn btn-info form-control" id="submit" value="Отправить">
					</div>
				</form>
			</div>
			<p class="text-center">&nbsp;</p>

';

?>