<?php
//$ip=strip_tags($_GET["ip"]);
$ip                = $_SERVER['REMOTE_ADDR'];
$db                = "key_captcha.dat";
$key_to_store      = 10; //Незачем хранить много ключей. Чем более посещаемый сайт, тем больше ключей следует хранить
$rand_from         = 2; //Сколько знаков в числе минимально
$rand_to           = 4; //максимально
$width             = 60; //ширина холста
$height            = 20; //высота холста
$font_size_min     = 16; // минимальная высота символа
$font_size_max     = 16; // максимальная высота символа
$font_file         = str_replace("\\", "/", dirname(__FILE__)) . "/num.ttf"; // путь к файлу шрифта
$char_angle_min    = -10; // максимальный наклон символа влево
$char_angle_max    = 10; // максимальный наклон символа вправо
$char_angle_shadow = 5; // размер тени
$char_align        = 16; // выравнивание символа по-вертикали
$start             = 5; // позиция первого символа по-горизонтали
$interval          = 10; // интервал между началами символов
$chars             = "0123456789"; // набор символов
$digit_sum         = 1; //включать функцию подсчета цифр?

//открываем файл с массивом ключей
@chmod($db, 0777);
$file = @file($db);
if ($file)
    $keys = unserialize(str_replace("\n", "", str_replace("\r", "", $file[0])));
else
    $keys = array();
//чистка
if (count($keys) > $key_to_store)
    array_slice($keys, 1, $key_to_store - 1, 1);

//формируем изображение
$im          = imageCreateTrueColor($width, $height);
$font_color  = imagecolorallocate($im, 240, 240, 240); // rbg-цвет текста
$font_shadow = imagecolorallocate($im, 30, 30, 30); // rbg-цвет тени
$bg_color    = imagecolorallocate($im, 255, 255, 255); //rgb-цвет фона
imageFill($im, 0, 0, $bg_color);

//генерируем надпись
$rand_rand = rand($rand_from, $rand_to);
$str       = "";
$num_chars = strlen($chars);
for ($i = 0; $i < $rand_rand; $i++) {
    $char       = $chars[rand(0, $num_chars - 1)];
    $font_size  = rand($font_size_min, $font_size_max);
    $char_angle = rand($char_angle_min, $char_angle_max);
    imagettftext($im, $font_size, $char_angle, $start, $char_align, $font_shadow, $font_file, $char);
    imagettftext($im, $font_size, $char_angle + $char_angle_shadow * (rand(0, 1) * 2 - 1), $start, $char_align, $font_color, $font_file, $char);
    $start += $interval;
    $str .= $char;
}
$result = 0;
//обрабатываем число с картинки в зависимости от предпочтения
//в данном случае, предпочитаем считать цифры
if ($digit_sum) {
    $key = intval($str);
    while ($key >= 1) {
        $result = $result + fmod($key, 10);
        $key    = floor($key / 10);
    }
} else
    $result = $str;
//запоминаем в массив
$keys[$ip] = $result;

//вывод на экран
Header("Content-type: image/png");
imagePng($im);
imagedestroy($im); //очистка памяти

//запоминаем результат в массив
$keys[$ip] = $result;
//сохраняем массив ключей
$file      = fopen($db, "w+");
fwrite($file, serialize($keys));
fclose($file);
@chmod($db, 0644);

?>