<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs" version="2.0">
    <xsl:output omit-xml-declaration="yes" indent="yes"/>
    <xsl:param name="rootName">topicmeta</xsl:param>
    <xsl:param name="keywords">keywords</xsl:param>
    <xsl:param name="element">keyword</xsl:param>
    
    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="*[name() = $rootName][count(child::*[name() = $keywords]) = 0]">
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:apply-templates select="node()"/>
            <xsl:element name="{$keywords}">
                <xsl:element name="{$element}">$select("Insert <xsl:value-of select="$element"/> here")</xsl:element>
            </xsl:element>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="*[name() = $rootName]/*[name() = $keywords]">  
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:apply-templates select="node()"/>
            <xsl:element name="{$element}">$select("Insert <xsl:value-of select="$element"/> here")</xsl:element>
        </xsl:copy>
    </xsl:template>

</xsl:stylesheet>
