/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.xsd.documentation;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.Oxygen;
import ro.sync.exml.editor.xmleditor.ErrorListException;
import ro.sync.exml.f;
import ro.sync.exml.options.td;
import ro.sync.licensemanager.eb;
import ro.sync.licensemanager.h;
import ro.sync.net.protocol.Installer;
import ro.sync.options.k;
import ro.sync.ui.application.b.l;
import ro.sync.util.PlatformDetector;
import ro.sync.util.Resource;
import ro.sync.util.URLUtil;
import ro.sync.util.c.c;
import ro.sync.util.ic;
import ro.sync.util.oc;
import ro.sync.xsd.documentation.XSDDocumentationOptions;
import ro.sync.xsd.documentation.i;
import ro.sync.xsd.documentation.n;
import ro.sync.xsd.documentation.x;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class XSDSchemaDocumentationGenerator {
    private static void c() {
        System.out.println();
        if (PlatformDetector.isWin32()) {
            System.out.print("schemaDocumentation ");
        } else if (PlatformDetector.isMacOS()) {
            System.out.print("sh schemaDocumentationMac.sh ");
        } else {
            System.out.print("sh schemaDocumentation.sh ");
        }
        System.out.println("schemaFile [ [-cfg:configFile] | [[-out:outputFile] [-format:<value>] [-xsl:xslFile] [-split:<value>] [-openInBrowser:<value>]] | [--help | -help | --h | -h]\n");
        System.out.println("Where:");
        System.out.println("   schemaFile = the XML Schema file");
        System.out.println("   -cfg:configfile = the configuration file.      It contains the output file, split method, output format options\n     and some advanced options regarding the included components and components details.\n     If an external configuration file is specified all other supplied arguments except the XML Schema file will be ignored.\n     You can create such a file in the Oxygen \"Schema Documentation\" dialog. See the Oxygen user manual for additional information on how to create one.\n");
        System.out.println("   -out:outputFile = the file where the generated documentation will be saved.\n     By default it is the name of the schema file with 'html' extension.");
        System.out.println("   -format:<value> = the output format type used when generating the documentation.\n     value = [html | pdf | docbook | custom]\n             html    = generate documentation in HTML format.\n             pdf     = generate documentation in PDF format.\n             docbook = generate documentation in DocBook format.\n             custom  = generate documentation in a custom format.\n");
        System.out.println("   -xsl:<xslFile> = the XSL file to be applied on the intermediate xml format. \n     If there is no xsl file provided then the result will be in the HTML format.");
        System.out.println("   -split:<value>  = the split method used when generating the documentation. Splitting is recommended for large schemas\n     value = [none | namespace | | component | location].\n             none      = generate one single output file.\n             namespace = generate an output file for every namespace in the schema.\n             component = generate an output file for every component in the schema.\n             location  = generate an output file for every schema location.\n     By default the used method is 'none'");
        System.out.println("   -openInBrowser:<value> = open the result of the transformation in browser.\n     value = [true | false].\n             true = open the resulted file in browser.\n             false = do not open the resulted file in browser.\n     By default the value is false.\n\n   --help | -help | --h | -h = show this help.");
        System.out.println();
        System.out.print("Example: ");
        if (PlatformDetector.isWin32()) {
            System.out.print("schemaDocumentation ");
        } else if (PlatformDetector.isMacOS()) {
            System.out.print("sh schemaDocumentationMac.sh ");
        } else {
            System.out.print("sh schemaDocumentation.sh ");
        }
        System.out.println("example.xsd -out:schemaDocumentation.html -format:custom -xsl:example.xsl -split:namespace");
        System.exit(1);
    }

    private static int b(String string) {
        int n2 = -1;
        if ("none".equals(string = string.substring(string.indexOf(58) + 1))) {
            n2 = 1;
        } else if ("namespace".equals(string)) {
            n2 = 2;
        } else if ("location".equals(string)) {
            n2 = 3;
        } else if ("component".equals(string)) {
            n2 = 4;
        } else {
            System.out.println("Invalid split method!");
            XSDSchemaDocumentationGenerator.c();
        }
        return n2;
    }

    private static int d(String string) {
        int n2 = -1;
        if ("html".equals(string = string.substring(string.indexOf(58) + 1))) {
            n2 = 1;
        } else if ("pdf".equals(string)) {
            n2 = 2;
        } else if ("docbook".equals(string)) {
            n2 = 3;
        } else if ("custom".equals(string)) {
            n2 = 4;
        } else {
            System.out.println("Invalid output format type!");
            XSDSchemaDocumentationGenerator.c();
        }
        return n2;
    }

    public static void main(String[] stringArray) throws MalformedURLException, IOException, ParserConfigurationException, TransformerException {
        System.setProperty("com.oxygenxml.editor.home.url", URLUtil.correct(new File(".")).toString());
        boolean bl = c.c();
        ic.b();
        Installer.installProtocols();
        File file = Resource.getLibDir();
        Oxygen.setOxygenHome(file);
        oc.j(l.e().n());
        f f2 = new f(new String[]{"XML-Developer", "XML-Editor"});
        h h2 = f2.licenseCheck(false);
        c.b(bl);
        System.out.println();
        if (h2 == null) {
            System.err.println("ERROR: No valid oXygen license found, image generation aborted...:");
            System.err.println("--------------------------------------------------");
            System.err.println("Please register a valid license key in one of the following ways:");
            System.err.println("    1) Start oXygen and enter a valid license key for registration");
            System.err.println("    2) Place the license key in a file named \"licensekey.txt\" in the same directory as this script");
            System.err.println("--------------------------------------------------");
            System.exit(1);
        } else {
            Object object;
            URL uRL = null;
            eb.k().b(h2);
            XSDDocumentationOptions xSDDocumentationOptions = null;
            if (stringArray.length < 1 || stringArray.length > 6) {
                System.out.println("Invalid number of arguments!");
                XSDSchemaDocumentationGenerator.c();
            } else if (stringArray.length == 1 && ("--help".equals(stringArray[0]) || "--h".equals(stringArray[0]) || "-help".equals(stringArray[0]) || "-h".equals(stringArray[0]))) {
                XSDSchemaDocumentationGenerator.c();
            } else {
                object = stringArray[0];
                if (((String)object).startsWith("www")) {
                    object = "http://" + (String)object;
                }
                String string = null;
                try {
                    uRL = new URL(URLUtil.correct((String)object, false));
                }
                catch (MalformedURLException malformedURLException) {
                    File file2 = new File((String)object);
                    if (file2.isFile() && file2.exists()) {
                        try {
                            uRL = URLUtil.correct(file2);
                        }
                        catch (MalformedURLException malformedURLException2) {}
                    }
                    string = "Specified schema file does not exist: " + file2.getAbsolutePath();
                }
                if (uRL == null) {
                    if (string != null) {
                        System.out.println(string);
                    } else {
                        XSDSchemaDocumentationGenerator.c();
                    }
                } else {
                    xSDDocumentationOptions = XSDSchemaDocumentationGenerator.e(stringArray, uRL);
                }
            }
            if (xSDDocumentationOptions != null) {
                object = new i();
                ((i)object).cb(new x());
                try {
                    ((i)object).vb(xSDDocumentationOptions, uRL);
                    System.out.println("Schema documentation generation successful.");
                }
                catch (ErrorListException errorListException) {
                    System.out.println(n.l(errorListException.getErrorList(), "Schema documentation generation failed: "));
                    System.exit(1);
                }
            } else {
                System.out.println("Schema documentation generation failed.");
                System.exit(1);
            }
        }
        System.exit(0);
    }

    static XSDDocumentationOptions e(String[] stringArray, URL uRL) throws IOException {
        XSDDocumentationOptions xSDDocumentationOptions = null;
        if (stringArray.length > 1 && stringArray[1].startsWith("-cfg:")) {
            String string = stringArray[1].substring(5);
            if (string.length() > 0) {
                File file = new File(string);
                if (file.exists()) {
                    k k2 = new k(false, td.b);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    k2.load(bufferedInputStream);
                    xSDDocumentationOptions = (XSDDocumentationOptions)k2.getObjectProperty("xsd.documentation.options");
                    if (xSDDocumentationOptions == null) {
                        System.out.println("Invalid configuration file format!");
                    }
                } else {
                    System.out.println("The configuration file '" + file + "' could not be found!");
                }
            } else {
                System.out.println("Invalid configuration file name!");
                XSDSchemaDocumentationGenerator.c();
            }
        } else {
            String string = "${cfn}.html";
            int n2 = 1;
            File file = null;
            int n3 = 1;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = true;
            boolean bl6 = false;
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2];
                if (string2.startsWith("-split:")) {
                    if (!bl3) {
                        n3 = XSDSchemaDocumentationGenerator.b(string2);
                        bl3 = true;
                        continue;
                    }
                    bl5 = false;
                    System.out.println("Split method already specified!");
                    XSDSchemaDocumentationGenerator.c();
                    break;
                }
                if (string2.startsWith("-format:")) {
                    if (!bl2) {
                        n2 = XSDSchemaDocumentationGenerator.d(string2);
                        bl2 = true;
                        if (bl) continue;
                        switch (n2) {
                            case 1: {
                                string = "${cfn}.html";
                                break;
                            }
                            case 2: {
                                string = "${cfn}.pdf";
                                break;
                            }
                            case 3: {
                                string = "${cfn}.xml";
                                break;
                            }
                            case 4: {
                                string = "${cfn}.xml";
                            }
                        }
                        continue;
                    }
                    bl5 = false;
                    System.out.println("Output format type already specified!");
                    XSDSchemaDocumentationGenerator.c();
                    break;
                }
                if (string2.startsWith("-xsl:")) {
                    if (!bl4) {
                        file = new File(string2.substring(5));
                        bl4 = true;
                        continue;
                    }
                    bl5 = false;
                    System.out.println("Stylesheet file already specified!");
                    XSDSchemaDocumentationGenerator.c();
                    break;
                }
                if (string2.startsWith("-out:")) {
                    if (!bl) {
                        string = string2.substring(5);
                        bl = true;
                        continue;
                    }
                    bl5 = false;
                    System.out.println("Output file already specified!");
                    XSDSchemaDocumentationGenerator.c();
                    break;
                }
                if (string2.startsWith("-openInBrowser:")) {
                    bl6 = Boolean.valueOf(string2.substring(15));
                    continue;
                }
                bl5 = false;
                System.out.println("Invalid argument: " + string2);
                XSDSchemaDocumentationGenerator.c();
                break;
            }
            if (bl5) {
                File file2 = new File(string);
                if (!uRL.getProtocol().equals("file") && !file2.isAbsolute()) {
                    bl5 = false;
                    System.out.println("Relative output is not supported for remote schemas. Please specify a local output file!");
                    XSDSchemaDocumentationGenerator.c();
                } else {
                    xSDDocumentationOptions = new XSDDocumentationOptions();
                    xSDDocumentationOptions.setOutputFile(string);
                    xSDDocumentationOptions.setFormat(n2);
                    xSDDocumentationOptions.setOpenOutputInBrowser(bl6);
                    if (n2 == 4) {
                        xSDDocumentationOptions.setCustomXSL(URLUtil.correct(file));
                    }
                    if (n2 == 1 || n2 == 4) {
                        xSDDocumentationOptions.setSplitMethod(n3);
                    } else {
                        xSDDocumentationOptions.setSplitMethod(1);
                    }
                }
            }
        }
        return xSDDocumentationOptions;
    }
}

