/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.util.security.manager;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import sun.net.util.IPAddressUtil;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public final class URLPermission
extends Permission {
    private static final long serialVersionUID = -2702463814894478682L;
    private transient String scheme;
    private transient String ssp;
    private transient String path;
    private transient List<String> methods;
    private transient List<String> requestHeaders;
    private transient _c authority;
    private String actions;
    private boolean acceptAll;

    public URLPermission(String string, String string2) {
        super(string);
        this.init(string2);
    }

    private void init(String string) {
        String string2;
        String string3;
        this.parseURI(this.getName());
        int n2 = string.indexOf(58);
        if (string.lastIndexOf(58) != n2) {
            throw new IllegalArgumentException("invalid actions string");
        }
        if (n2 == -1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(0, n2);
            string2 = string.substring(n2 + 1);
        }
        List<String> list = this.normalizeMethods(string3);
        Collections.sort(list);
        this.methods = Collections.unmodifiableList(list);
        list = this.normalizeHeaders(string2);
        Collections.sort(list);
        this.requestHeaders = Collections.unmodifiableList(list);
        this.actions = this.actions();
    }

    public URLPermission(String string) {
        this(string, "*:*");
    }

    @Override
    public String getActions() {
        return this.actions;
    }

    @Override
    public boolean implies(Permission permission) {
        if (!this.acceptAll || "java.net.URLPermissions".equals(permission.getClass().getName())) {
            // empty if block
        }
        if (!(permission instanceof URLPermission)) {
            return false;
        }
        URLPermission uRLPermission = (URLPermission)permission;
        if (!this.methods.get(0).equals("*") && Collections.indexOfSubList(this.methods, uRLPermission.methods) == -1) {
            return false;
        }
        if (this.requestHeaders.isEmpty() && !uRLPermission.requestHeaders.isEmpty()) {
            return false;
        }
        if (!this.requestHeaders.isEmpty() && !this.requestHeaders.get(0).equals("*") && Collections.indexOfSubList(this.requestHeaders, uRLPermission.requestHeaders) == -1) {
            return false;
        }
        if (!this.scheme.equals(uRLPermission.scheme)) {
            return false;
        }
        if (this.ssp.equals("*")) {
            return true;
        }
        if (!this.authority.e(uRLPermission.authority)) {
            return false;
        }
        if (this.path == null) {
            return uRLPermission.path == null;
        }
        if (uRLPermission.path == null) {
            return false;
        }
        if (this.path.endsWith("/-")) {
            String string = this.path.substring(0, this.path.length() - 1);
            return uRLPermission.path.startsWith(string);
        }
        if (this.path.endsWith("/*")) {
            String string = this.path.substring(0, this.path.length() - 1);
            if (!uRLPermission.path.startsWith(string)) {
                return false;
            }
            String string2 = uRLPermission.path.substring(string.length());
            if (string2.indexOf(47) != -1) {
                return false;
            }
            return !string2.equals("-");
        }
        return this.path.equals(uRLPermission.path);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof URLPermission)) {
            return false;
        }
        URLPermission uRLPermission = (URLPermission)object;
        if (!this.scheme.equals(uRLPermission.scheme)) {
            return false;
        }
        if (!this.getActions().equals(uRLPermission.getActions())) {
            return false;
        }
        if (!this.authority.b(uRLPermission.authority)) {
            return false;
        }
        if (this.path != null) {
            return this.path.equals(uRLPermission.path);
        }
        return uRLPermission.path == null;
    }

    @Override
    public int hashCode() {
        return this.getActions().hashCode() + this.scheme.hashCode() + this.authority.hashCode() + (this.path == null ? 0 : this.path.hashCode());
    }

    private List<String> normalizeMethods(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == ',') {
                String string2 = stringBuilder.toString();
                if (string2.length() > 0) {
                    arrayList.add(string2);
                }
                stringBuilder = new StringBuilder();
                continue;
            }
            if (c2 == ' ' || c2 == '\t') {
                throw new IllegalArgumentException("white space not allowed");
            }
            if (c2 >= 'a' && c2 <= 'z') {
                c2 = (char)(c2 - 32);
            }
            stringBuilder.append(c2);
        }
        String string3 = stringBuilder.toString();
        if (string3.length() > 0) {
            arrayList.add(string3);
        }
        return arrayList;
    }

    private List<String> normalizeHeaders(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= 'a' && c2 <= 'z') {
                if (bl) {
                    c2 = (char)(c2 - 32);
                    bl = false;
                }
                stringBuilder.append(c2);
                continue;
            }
            if (c2 == ' ' || c2 == '\t') {
                throw new IllegalArgumentException("white space not allowed");
            }
            if (c2 == '-') {
                bl = true;
                stringBuilder.append(c2);
                continue;
            }
            if (c2 == ',') {
                String string2 = stringBuilder.toString();
                if (string2.length() > 0) {
                    arrayList.add(string2);
                }
                stringBuilder = new StringBuilder();
                bl = true;
                continue;
            }
            bl = false;
            stringBuilder.append(c2);
        }
        String string3 = stringBuilder.toString();
        if (string3.length() > 0) {
            arrayList.add(string3);
        }
        return arrayList;
    }

    private void parseURI(String string) {
        String string2;
        int n2 = string.length();
        int n3 = string.indexOf(58);
        if (n3 == -1 || n3 + 1 == n2) {
            throw new IllegalArgumentException("invalid URL string");
        }
        this.scheme = string.substring(0, n3).toLowerCase();
        this.ssp = string.substring(n3 + 1);
        if (!this.ssp.startsWith("//")) {
            if (!this.ssp.equals("*")) {
                throw new IllegalArgumentException("invalid URL string");
            }
            this.authority = new _c(this.scheme, "*");
            return;
        }
        String string3 = this.ssp.substring(2);
        n3 = string3.indexOf(47);
        if (n3 == -1) {
            this.path = "";
            string2 = string3;
        } else {
            string2 = string3.substring(0, n3);
            this.path = string3.substring(n3);
        }
        this.authority = new _c(this.scheme, string2.toLowerCase());
    }

    private String actions() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.methods) {
            stringBuilder.append(string);
        }
        stringBuilder.append(":");
        for (String string : this.requestHeaders) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        String string = (String)getField.get("actions", null);
        this.init(string);
    }

    static class _c {
        _b b;

        _c(String string, String string2) {
            int n2 = string2.indexOf(64);
            this.b = n2 == -1 ? new _b(string, string2) : new _b(string, string2.substring(n2 + 1));
        }

        boolean e(_c _c2) {
            return this.c(_c2) && this.d(_c2);
        }

        private boolean c(_c _c2) {
            String string = this.b.d();
            String string2 = _c2.b.d();
            if (this.b.i() && string.equals("")) {
                return true;
            }
            if (_c2.b.i() && string2.equals("")) {
                return false;
            }
            if (string.equals(string2)) {
                return true;
            }
            if (this.b.i()) {
                return string2.endsWith(string);
            }
            return false;
        }

        private boolean d(_c _c2) {
            int[] nArray = this.b.j();
            int[] nArray2 = _c2.b.j();
            if (nArray[0] == -1) {
                return true;
            }
            return nArray[0] <= nArray2[0] && nArray[1] >= nArray2[1];
        }

        boolean b(_c _c2) {
            return this.b.e(_c2.b);
        }

        public int hashCode() {
            return this.b.hashCode();
        }
    }

    private static class _b {
        String k;
        String c;
        int[] f;
        boolean d;
        boolean m;
        boolean h;
        boolean j;
        static final int g = 0;
        static final int l = 65535;
        static final int n = -32;
        static final int[] b = new int[]{80, 80};
        static final int[] i = new int[]{443, 443};
        static final int[] e = new int[]{-1, -1};

        boolean e(_b _b2) {
            return this.k.equals(_b2.k) && this.f[0] == _b2.f[0] && this.f[1] == _b2.f[1] && this.d == _b2.d && this.m == _b2.m;
        }

        public int hashCode() {
            return this.k.hashCode() + this.f[0] + this.f[1];
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        _b(String string, String string2) {
            String string3 = null;
            this.c = string;
            if (string2.charAt(0) == '[') {
                byte[] byArray;
                this.m = true;
                this.h = true;
                int n2 = string2.indexOf(93);
                if (n2 == -1) {
                    throw new IllegalArgumentException("invalid IPv6 address: " + string2);
                }
                String string4 = string2.substring(1, n2);
                int n3 = string2.indexOf(58, n2 + 1);
                if (n3 != -1 && string2.length() > n3) {
                    string3 = string2.substring(n3 + 1);
                }
                if ((byArray = IPAddressUtil.textToNumericFormatV6(string4)) == null) {
                    throw new IllegalArgumentException("illegal IPv6 address");
                }
                StringBuilder stringBuilder = new StringBuilder();
                Formatter formatter = new Formatter(stringBuilder, Locale.US);
                formatter.format("%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x", byArray[0], byArray[1], byArray[2], byArray[3], byArray[4], byArray[5], byArray[6], byArray[7], byArray[8], byArray[9], byArray[10], byArray[11], byArray[12], byArray[13], byArray[14], byArray[15]);
                this.k = stringBuilder.toString();
                formatter.close();
            } else {
                String string5;
                int n4 = string2.indexOf(58);
                if (n4 != -1 && string2.length() > n4) {
                    string5 = string2.substring(0, n4);
                    string3 = string2.substring(n4 + 1);
                } else {
                    String string6 = string5 = n4 == -1 ? string2 : string2.substring(0, n4);
                }
                if (string5.startsWith("*")) {
                    this.d = true;
                    if (string5.equals("*")) {
                        string5 = "";
                    } else {
                        if (!string5.startsWith("*.")) throw new IllegalArgumentException("invalid host wildcard specification");
                        string5 = _b.g(string5.substring(1));
                    }
                } else {
                    int n5 = string5.lastIndexOf(46);
                    if (n5 != -1 && string5.length() > 1) {
                        boolean bl = true;
                        int n6 = string5.length();
                        for (int i2 = n5 + 1; i2 < n6; ++i2) {
                            char c2 = string5.charAt(i2);
                            if (c2 >= '0' && c2 <= '9') continue;
                            bl = false;
                            break;
                        }
                        this.j = this.m = bl;
                        if (bl) {
                            byte[] byArray = IPAddressUtil.textToNumericFormatV4(string5);
                            if (byArray == null) {
                                throw new IllegalArgumentException("illegal IPv4 address");
                            }
                            StringBuilder stringBuilder = new StringBuilder();
                            Formatter formatter = new Formatter(stringBuilder, Locale.US);
                            formatter.format("%d.%d.%d.%d", byArray[0], byArray[1], byArray[2], byArray[3]);
                            string5 = stringBuilder.toString();
                            formatter.close();
                        } else {
                            string5 = _b.g(string5);
                        }
                    }
                }
                this.k = string5;
            }
            try {
                this.f = this.b(string3);
                return;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("invalid port range: " + string3);
            }
        }

        private static String g(String string) {
            return string.toLowerCase();
        }

        public boolean h() {
            return this.m;
        }

        public boolean f() {
            return this.j;
        }

        public boolean c() {
            return this.h;
        }

        public String d() {
            return this.k;
        }

        public int[] j() {
            return this.f;
        }

        public boolean i() {
            return this.d;
        }

        private int[] k() {
            if (this.c.equals("http")) {
                return b;
            }
            if (this.c.equals("https")) {
                return i;
            }
            return e;
        }

        private int[] b(String string) {
            if (string == null || string.equals("")) {
                return this.k();
            }
            if (string.equals("*")) {
                return new int[]{0, 65535};
            }
            try {
                int n2 = string.indexOf(45);
                if (n2 == -1) {
                    int n3 = Integer.parseInt(string);
                    return new int[]{n3, n3};
                }
                String string2 = string.substring(0, n2);
                String string3 = string.substring(n2 + 1);
                int n4 = string2.equals("") ? 0 : Integer.parseInt(string2);
                int n5 = string3.equals("") ? 65535 : Integer.parseInt(string3);
                if (n4 < 0 || n5 < 0 || n5 < n4) {
                    return this.k();
                }
                return new int[]{n4, n5};
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return this.k();
            }
        }
    }
}

