/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.template;

import java.io.File;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.editor.EditorTemplate;
import ro.sync.options.PersistentObject;
import ro.sync.template.f;
import ro.sync.util.Equaler;
import ro.sync.util.URLUtil;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public abstract class AbstractTemplate
implements EditorTemplate,
PersistentObject {
    public static final String SMALL_ICON = "smallIcon";
    public static final String BIG_ICON = "bigIcon";
    public static final String LONG_DESC_REF = "longDescriptionReference";
    public static final String TYPE = "type";
    protected File templateLocation;
    protected final String sourceInformation;
    private boolean isFromFrameworks = false;
    private String smallIconPath;
    private String bigIconPath;
    private f longDescriptionProvider;
    private String typeProperty;

    public AbstractTemplate(File file, String string, boolean bl, String string2, String string3, String string4) {
        this.templateLocation = file;
        this.sourceInformation = string;
        this.isFromFrameworks = bl;
        this.smallIconPath = string2;
        this.bigIconPath = string3;
        this.typeProperty = string4;
    }

    public abstract String getTemplateFileName();

    @Override
    public String getExtension() {
        return URLUtil.getExtension(this.getTemplateFileName());
    }

    @Override
    public String getDescription() {
        String string = this.getName();
        if (this.sourceInformation != null) {
            string = this.sourceInformation + " - " + string;
        }
        return string;
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean equals(Object object) {
        if (object instanceof AbstractTemplate) {
            if (object.getClass().equals(this.getClass())) {
                AbstractTemplate abstractTemplate = (AbstractTemplate)object;
                File file = abstractTemplate.templateLocation;
                if (file != null && file.getAbsolutePath().equals(this.templateLocation.getAbsolutePath())) {
                    return Equaler.verifyEquals(this.getAdditionalInformation(), abstractTemplate.getAdditionalInformation());
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        if (this.getAdditionalInformation() != null) {
            return this.getAdditionalInformation().hashCode() + this.templateLocation.hashCode();
        }
        return this.templateLocation.hashCode();
    }

    @Override
    public String getSource() {
        return this.templateLocation.getAbsolutePath();
    }

    public static int getTemplateType(File file) {
        int n2 = 2;
        String string = file.getName();
        if (string.endsWith(".bin")) {
            n2 = 3;
        }
        return n2;
    }

    @Override
    public Object clone() {
        try {
            AbstractTemplate abstractTemplate = (AbstractTemplate)super.clone();
            abstractTemplate.templateLocation = this.templateLocation;
            return abstractTemplate;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public String getName() {
        return URLUtil.removeExtension(this.getTemplateFileName());
    }

    public File getLocation() {
        return this.templateLocation;
    }

    @Override
    public String getAdditionalInformation() {
        return this.sourceInformation;
    }

    public boolean isFromFrameworks() {
        return this.isFromFrameworks;
    }

    @Override
    public boolean isCustomizable() {
        return false;
    }

    @Override
    public String getCustomizePageID() {
        return null;
    }

    public String getSmallIconPath() {
        return this.smallIconPath;
    }

    public String getBigIconPath() {
        return this.bigIconPath;
    }

    @Override
    public int getCaretPosition() {
        return 0;
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return new String[]{"longDescriptionProvider"};
    }

    @Override
    public String getLongDescription() {
        return this.longDescriptionProvider != null ? this.longDescriptionProvider.b() : null;
    }

    public void setLongDescriptionProvider(f f2) {
        this.longDescriptionProvider = f2;
    }

    @Override
    public String getTypeProperty() {
        return this.typeProperty;
    }
}

