/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.svn.trees.wc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class SyncNodeState
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2436380768449203675L;
    public static final byte CONTENT_INCOMING = 0;
    public static final byte CONTENT_OUTGOING = 1;
    public static final byte CONTENT_CONFLICT = 2;
    public static final byte PROPERTIES_INCOMING = 3;
    public static final byte PROPERTIES_OUTGOING = 4;
    public static final byte PROPERTIES_CONFLICT = 5;
    private static final String[] ALL_FLAGS_DESCRIPTION = new String[]{"content.incoming", "content.outgoing", "content.conflict", "properties.incoming", "properties.outgoing", "properties.conflict"};
    public static final byte[] ALL_FLAGS = new byte[]{0, 1, 2, 3, 4, 5};
    public static final byte[] INCOMING_FLAGS = new byte[]{0, 3};
    public static final byte[] OUTGOING_FLAGS = new byte[]{1, 4};
    public static final byte[] CONFLICT_FLAGS = new byte[]{2, 5};
    private transient byte flags;

    public void setProperty(byte by, boolean bl) {
        this.flags = bl ? (byte)(this.flags | 2 << by) : (byte)(this.flags & 127 - (2 << by));
    }

    public boolean getStatusProperty(byte by) {
        return (this.flags & 2 << by) != 0;
    }

    public boolean equals(Object object) {
        return object instanceof SyncNodeState && this.flags == ((SyncNodeState)object).flags;
    }

    public int hashCode() {
        return this.flags;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < 6; ++i2) {
            stringBuilder.append(ALL_FLAGS_DESCRIPTION[i2] + " -- " + (this.flags & 2 << i2) + "\n");
        }
        return stringBuilder.toString();
    }

    public Object clone() {
        SyncNodeState syncNodeState = new SyncNodeState();
        syncNodeState.flags = this.flags;
        return syncNodeState;
    }

    String dumpInformation() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Content IN: ").append(this.getStatusProperty((byte)0));
        stringBuilder.append("\nContent OUT: ").append(this.getStatusProperty((byte)1));
        stringBuilder.append("\nContent C: ").append(this.getStatusProperty((byte)2));
        stringBuilder.append("\nProp IN: ").append(this.getStatusProperty((byte)3));
        stringBuilder.append("\nProp OUT: ").append(this.getStatusProperty((byte)4));
        stringBuilder.append("\nProp C: ").append(this.getStatusProperty((byte)5));
        return stringBuilder.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.setProperty((byte)2, !this.getStatusProperty((byte)0) && this.getStatusProperty((byte)2));
        this.setProperty((byte)0, false);
        this.setProperty((byte)5, !this.getStatusProperty((byte)3) && this.getStatusProperty((byte)5));
        this.setProperty((byte)3, false);
        objectOutputStream.writeByte(this.flags);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.flags = objectInputStream.readByte();
    }
}

