/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.svn.locks;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import org.tmatesoft.svn.core.SVNLock;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.util.Equaler;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class SVNLockInfo
implements Serializable {
    private static final long serialVersionUID = -2177465886741634560L;
    private String lockID;
    private String lockOwner;
    private transient Date lockCreationDate;
    private transient Date lockExpirationDate;
    private String lockComment;

    public static SVNLockInfo getLockInfo(SVNLock sVNLock, boolean bl) {
        SVNLockInfo sVNLockInfo = null;
        if (sVNLock != null) {
            String string = sVNLock.getComment();
            if (string != null && string.trim().length() == 0) {
                string = null;
            }
            sVNLockInfo = new SVNLockInfo(sVNLock.getID(), sVNLock.getOwner(), sVNLock.getCreationDate(), sVNLock.getExpirationDate(), string, bl);
        }
        return sVNLockInfo;
    }

    private SVNLockInfo(String string, String string2, Date date, Date date2, String string3, boolean bl) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("Wrong lock token", new Exception());
        }
        if (date == null) {
            throw new IllegalArgumentException("Locks must have creation date", new Exception());
        }
        this.lockID = string;
        this.lockOwner = bl ? string2.intern() : string2;
        this.lockCreationDate = date;
        this.lockComment = string3 != null ? string3.trim() : null;
    }

    public String getLockID() {
        return this.lockID;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public Date getLockCreationDate() {
        return this.lockCreationDate;
    }

    public Date getLockExpirationDate() {
        return this.lockExpirationDate;
    }

    public String getLockComment() {
        return this.lockComment;
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object instanceof SVNLockInfo) {
            SVNLockInfo sVNLockInfo = (SVNLockInfo)object;
            bl = Equaler.verifyEquals(this.lockID, sVNLockInfo.lockID) && Equaler.verifyEquals(this.lockOwner, sVNLockInfo.lockOwner) && Equaler.verifyEquals(this.lockCreationDate, sVNLockInfo.lockCreationDate) && Equaler.verifyEquals(this.lockExpirationDate, sVNLockInfo.lockExpirationDate) && Equaler.verifyEquals(this.lockComment, sVNLockInfo.lockComment);
        }
        return bl;
    }

    public int hashCode() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.lockID);
        stringBuilder.append(this.lockOwner);
        stringBuilder.append(this.lockCreationDate.getTime());
        stringBuilder.append(this.lockExpirationDate.getTime());
        stringBuilder.append(this.lockComment);
        return stringBuilder.toString().hashCode();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.lockID);
        objectOutputStream.writeUTF(this.lockOwner);
        objectOutputStream.writeLong(this.lockCreationDate.getTime());
        boolean bl = this.lockExpirationDate == null;
        objectOutputStream.writeBoolean(bl);
        if (!bl) {
            objectOutputStream.writeLong(this.lockExpirationDate.getTime());
        }
        bl = this.lockComment == null;
        objectOutputStream.writeBoolean(bl);
        if (!bl) {
            objectOutputStream.writeUTF(this.lockComment);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.lockID = objectInputStream.readUTF();
        this.lockOwner = objectInputStream.readUTF().intern();
        this.lockCreationDate = new Date(objectInputStream.readLong());
        boolean bl = objectInputStream.readBoolean();
        if (!bl) {
            this.lockExpirationDate = new Date(objectInputStream.readLong());
        }
        if (!(bl = objectInputStream.readBoolean())) {
            this.lockComment = objectInputStream.readUTF();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nlockID: ").append(this.lockID);
        stringBuilder.append("\nlockOwner: ").append(this.lockOwner);
        stringBuilder.append("\nlockDate: ").append(this.lockCreationDate);
        stringBuilder.append("\nlockExpireDate: ").append(this.lockExpirationDate);
        stringBuilder.append("\nlockComment: ").append(this.lockComment);
        return stringBuilder.toString();
    }
}

