/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.net.protocol.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.FileNameMap;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.io.FileSystemUtil;
import ro.sync.net.protocol.FileBrowsingConnection;
import ro.sync.net.protocol.FolderEntryDescriptor;
import ro.sync.net.protocol.e;
import ro.sync.net.protocol.file.b;
import ro.sync.net.protocol.j;
import ro.sync.util.BasicURLUtil;
import ro.sync.util.URLUtil;

@SkipObfuscate(classes=SkipLevel.PUBLIC, fields=SkipLevel.PROTECTED, methods=SkipLevel.PROTECTED)
public class FileURLConnection
extends URLConnection
implements e,
j,
FileBrowsingConnection {
    private static b d;
    protected File file = null;
    public static StringBuilder DEBUG_BUILDER;

    public FileURLConnection(URL uRL) {
        super(uRL);
        this.file = BasicURLUtil.getCanonicalFileFromFileUrl(uRL);
    }

    @Override
    public void connect() {
        this.connected = true;
    }

    @Override
    public String getHeaderField(String string) {
        if ("content-length".equals(string)) {
            return String.valueOf(this.file.length());
        }
        if ("last-modified".equals(string)) {
            return new Date(this.file.lastModified()).toString();
        }
        if ("content-type".equals(string) && this.file != null && !this.file.isDirectory()) {
            FileNameMap fileNameMap = URLConnection.getFileNameMap();
            String string2 = fileNameMap.getContentTypeFor(this.file.toString());
            if (string2 == null) {
                string2 = "text/plain";
            }
            return string2;
        }
        return null;
    }

    @Override
    public String getHeaderField(int n2) {
        switch (n2) {
            case 0: {
                return String.valueOf(this.file.length());
            }
            case 1: {
                return String.valueOf(this.file.lastModified());
            }
        }
        return null;
    }

    @Override
    public String getHeaderFieldKey(int n2) {
        switch (n2) {
            case 0: {
                return "content-length";
            }
            case 1: {
                return "last-modified";
            }
        }
        return null;
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (DEBUG_BUILDER != null) {
            DEBUG_BUILDER.append("GET INPUT STREAM " + this.url).append("\n");
        }
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        RandomAccessFile randomAccessFile;
        block3: {
            boolean bl = this.file.exists();
            randomAccessFile = new RandomAccessFile(this.file, "rw");
            if (d != null && !bl) {
                d.b(this.file);
            }
            try {
                randomAccessFile.setLength(0L);
            }
            catch (IOException iOException) {
                if (randomAccessFile.length() == 0L) break block3;
                throw iOException;
            }
        }
        return new OutputStream(){

            @Override
            public void write(int n2) throws IOException {
                randomAccessFile.write(n2);
            }

            @Override
            public void close() throws IOException {
                randomAccessFile.close();
            }

            @Override
            public void write(byte[] byArray, int n2, int n3) throws IOException {
                randomAccessFile.write(byArray, n2, n3);
            }
        };
    }

    @Override
    public void removeResource() throws IOException {
        this.connect();
        if (this.file != null) {
            FileSystemUtil.deleteRecursivelly(this.file);
        }
    }

    public static void setFileURLConnectionListener(b b2) {
        d = b2;
    }

    @Override
    public List<FolderEntryDescriptor> listFolder() throws IOException {
        ArrayList<FolderEntryDescriptor> arrayList;
        block10: {
            File file;
            block9: {
                arrayList = new ArrayList<FolderEntryDescriptor>();
                String string = this.url.getPath();
                if (string.equals("/")) break block9;
                String string2 = string.startsWith("/") ? string.substring(1) : string;
                File file2 = BasicURLUtil.getAbsoluteFileFromFileUrl(this.url);
                if (!file2.isDirectory() || file2.list() == null) break block10;
                for (String string3 : file2.list()) {
                    File file3 = new File(file2, string3);
                    if (!string2.endsWith("/")) {
                        string2 = string2 + "/";
                    }
                    String string4 = string2 + URLUtil.encodeURIComponent(string3);
                    if (file3.isDirectory()) {
                        string4 = string4 + "/";
                    }
                    arrayList.add(new FolderEntryDescriptor("/" + string4));
                }
                break block10;
            }
            File[] fileArray = File.listRoots();
            if (fileArray.length > 1) {
                for (File file4 : fileArray) {
                    String string = file4.getAbsolutePath().replace("\\", "/");
                    string = string.endsWith("/") ? string : string + "/";
                    arrayList.add(new FolderEntryDescriptor("/" + string));
                }
            } else if (fileArray.length == 1 && (file = fileArray[0]).isDirectory() && file.list() != null) {
                String string = file.getAbsolutePath();
                for (String string5 : file.list()) {
                    File file5 = new File(file, string5);
                    String string6 = string + "/" + URLUtil.encodeURIComponent(string5);
                    if (file5.isDirectory()) {
                        string6 = string6 + "/";
                    }
                    arrayList.add(new FolderEntryDescriptor("/" + string6));
                }
            }
        }
        return arrayList;
    }
}

